/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import pk.com.softech.tradingterminal.CheckForUpdate;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class TradingTerminalPlugin
extends AbstractUIPlugin {
    private static TradingTerminalPlugin plugin;
    public static IStatusLineManager statusManager;

    public TradingTerminalPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.copyWorkspaceFile("currencies.xml");
        this.copyWorkspaceFile("securities.xml");
        this.copyWorkspaceFile("watchlists.xml");
        this.copyWorkspaceFile("config/terminal.ini");
        this.copyWorkspaceFile("config/client.keystore");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static TradingTerminalPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"pk.com.softech.tradingterminal", (String)path);
    }

    public void copyWorkspaceFile(String file) {
        File f = new File(Platform.getLocation().toFile(), file);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            try {
                byte[] buffer = new byte[10240];
                FileOutputStream os = new FileOutputStream(f);
                InputStream is = FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("data/" + file), (boolean)false);
                int readed = 0;
                do {
                    readed = is.read(buffer);
                    ((OutputStream)os).write(buffer, 0, readed);
                } while (readed == buffer.length);
                ((OutputStream)os).close();
                is.close();
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    public void checkForUpdate() {
        new CheckForUpdate();
    }

    public void copyTerminalFile(String file) {
        try {
            InputStream inputFile;
            URL url = new URL(String.valueOf(file) + "config/terminal.ini");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            int responseCode = connection.getResponseCode();
            System.out.println("Response Code : " + responseCode);
            if (responseCode != 404 && (inputFile = connection.getInputStream()) != null) {
                try {
                    byte[] buffer = new byte[10240];
                    File configFile = new File(Platform.getLocation().toFile(), "config/terminal.ini");
                    FileOutputStream os = new FileOutputStream(configFile);
                    int readed = 0;
                    do {
                        readed = inputFile.read(buffer);
                        ((OutputStream)os).write(buffer, 0, readed);
                    } while (readed == buffer.length);
                    ((OutputStream)os).close();
                    inputFile.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

