/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal;

import java.awt.Dimension;
import java.awt.Toolkit;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import pk.com.softech.tradingterminal.ApplicationActionBarAdvisor;
import pk.com.softech.tradingterminal.TradingTerminalPlugin;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.internal.AccessSourceProvider;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static String title = Resources.PRODUCT_NAME.toString();

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public boolean isDurableFolder(String perspectiveId, String folderId) {
        if ("org.eclipsetrader.ui.charts".equals(perspectiveId) && "center".equals(folderId)) {
            return true;
        }
        return super.isDurableFolder(perspectiveId, folderId);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        configurer.setInitialSize(new Point((int)dim.getWidth(), (int)dim.getHeight()));
        configurer.setShowMenuBar(true);
        configurer.setShowCoolBar(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowFastViewBars(false);
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                try {
                    if (Resources.accessControl != null) {
                        Resources.accessControl.disableViews();
                    }
                }
                catch (Exception exception) {}
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            }
        });
    }

    public void postWindowOpen() {
        String[] deleted = new String[]{"org.eclipse.help.ui.browsersPreferencePage", "org.eclipse.update.internal.ui.preferences.MainPreferencePage", "org.eclipse.equinox.security.ui.category", "org.eclipse.equinox.security.ui.storage"};
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        pm.getRootSubNodes();
        int i = 0;
        while (i < deleted.length) {
            pm.remove(deleted[i]);
            ++i;
        }
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellIconified(ShellEvent e) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display.getSystemTray() != null && CorePlugin.getDefault().getPreferenceStore().getBoolean("MINIMIZE_TO_TRAY")) {
                    shell.setVisible(false);
                    final TrayItem trayItem = new TrayItem(display.getSystemTray(), 0);
                    final Image image = TradingTerminalPlugin.getImageDescriptor("icons/window32.gif").createImage();
                    trayItem.setImage(image);
                    trayItem.setToolTipText(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getTitle());
                    trayItem.addListener(35, new Listener(){
                        Menu menu = new Menu((Decorations)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8);

                        public void handleEvent(Event event) {
                            MenuItem[] items = this.menu.getItems();
                            int i = 0;
                            while (i < items.length) {
                                items[i].dispose();
                                ++i;
                            }
                            MenuItem item = new MenuItem(this.menu, 0);
                            item.setText("Restore Terminal");
                            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    Shell workbenchWindowShell = ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell();
                                    workbenchWindowShell.setVisible(true);
                                    workbenchWindowShell.setActive();
                                    workbenchWindowShell.setFocus();
                                    workbenchWindowShell.setMinimized(false);
                                    trayItem.dispose();
                                    if (image != null) {
                                        image.dispose();
                                    }
                                }
                            });
                            this.menu.setVisible(true);
                        }
                    });
                }
            }
        });
        CorePlugin.createTradeSourcePlugin((String)Resources.softechTradingProvider);
        CorePlugin.statusManager = TradingTerminalPlugin.statusManager;
        this.updateTitle(this.computeTitle(Resources.loginStatus));
        Resources.accessControl = AccessSourceProvider.INSTANCE;
        Resources.accessControl.register();
        Resources.accessControl.setLoggedIn(Resources.loginStatus);
        super.postWindowOpen();
    }

    public boolean preWindowShellClose() {
        IPreferenceStore preferenceStore = CorePlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = preferenceStore.getBoolean("PROMPT_ON_EXIT");
        if (promptOnExit) {
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getWindowConfigurer().getWindow().getShell(), (String)"Confirm Exit", (String)"Exit Trading Terminal ?", (String)"Always exit without prompt", (boolean)false, null, null);
            if (dlg.getReturnCode() != 0) {
                return false;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue("PROMPT_ON_EXIT", !dlg.getToggleState());
        }
        return super.preWindowShellClose();
    }

    private String computeTitle(boolean status) {
        String newTitle = title;
        if (status) {
            newTitle = String.valueOf(Resources.applicationTitle) + "   :   " + Resources.userId + " Connected " + Resources.getClientVersion();
        }
        return newTitle;
    }

    private void updateTitle(String newTitle) {
        try {
            IWorkbenchWindowConfigurer configurer;
            Resources.configurer = configurer = this.getWindowConfigurer();
            CorePlugin.getDefault().getPreferenceStore().setValue(CorePlugin.USER_STATUS, Resources.loginStatus);
            String oldTitle = configurer.getTitle();
            if (!newTitle.equals(oldTitle)) {
                configurer.setTitle(newTitle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postWindowCreate() {
        super.postWindowCreate();
    }
}

