/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import pk.com.softech.tradingterminal.ApplicationWorkbenchWindowAdvisor;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.internal.XMLRepository;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        super.initialize(configurer);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return null;
    }

    public String getMainPreferencePageId() {
        return "pk.com.softech.tradingterminal";
    }

    public void eventLoopException(Throwable exception) {
        if (exception instanceof OutOfMemoryError) {
            try {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)shell.getText(), (String)("An unexpected error " + exception.toString() + ". The program will be closed."));
                if (!PlatformUI.getWorkbench().close()) {
                    System.exit(0);
                }
            }
            catch (Throwable throwable) {
                System.exit(0);
            }
        } else {
            super.eventLoopException(exception);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)shell.getText(), (String)("An unexpected error " + exception.toString() + " occured, please check the log file."));
        }
    }

    public void preStartup() {
        if (Resources.isDevelopment) {
            System.out.println("Application Start");
        }
    }

    public boolean preShutdown() {
        XMLRepository repository = (XMLRepository)CorePlugin.getRepository();
        if (repository != null) {
            if (Resources.isMapDbEnabled) {
                repository.saveSecuritiesMapDb();
                repository.saveWatchListsMapDb(0);
                repository.saveWatchListsMapDb(1);
                repository.saveNewsMapDb();
                repository.saveAlertsMapDb();
            } else {
                repository.saveSecurities();
                repository.saveWatchlists(0);
                repository.saveWatchlists(1);
                repository.saveAlerts();
                repository.saveNews();
            }
            repository.saveAnnouncements();
            repository.saveEvents();
            if (repository.getTradingRepository() != null) {
                repository.getTradingRepository().saveTradingSystems();
            }
        }
        return true;
    }

    public void postShutdown() {
    }
}

