/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.views;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;
import pk.com.softech.tradingterminal.core.ui.actions.ColorAndFontAction;
import pk.com.softech.tradingterminal.core.ui.actions.EditColumnsAction;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.ColumnsOptionDialog;
import pk.com.softech.tradingterminal.ext.Activator;
import pk.com.softech.tradingterminal.ext.dialog.SymbolSettingDialog;

public class WaterfallTickerView
extends ViewPart
implements Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.ext.views.WaterfallTickerView";
    static final String PREF_SYMBOL_LIST = "PREF_WFT_SYMBOL_LIST";
    public static final String PREFS_TICKER_VIEW_COLUMNS = "TICKER_VIEW_COLUMNS";
    public static final String PREFS_TICKER_VIEW_COLUMNS_SIZE = "TICKER_VIEW_COLUMNS_SIZE";
    Security security;
    Table table;
    Composite parent;
    boolean columnMove = false;
    ITheme theme;
    Color background1;
    Color background2;
    private String WFV_BG_COLOR1 = "WFV_BG_COLOR1";
    private String WFV_BG_COLOR2 = "WFV_BG_COLOR2";
    private String WFV_FONT_NAME = "WFV_FONT_NAME";
    private IAction editColumnsAction;
    Action symbolListAction;
    IPreferenceStore preferences;
    LabelProvidersRegistry registry = new LabelProvidersRegistry("pk.com.softech.tradingterminal.ext.views.WaterfallTickerView");
    ArrayList<Security> symbolList = new ArrayList();
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < WaterfallTickerView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(WaterfallTickerView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            WaterfallTickerView.this.preferences.setValue(WaterfallTickerView.PREFS_TICKER_VIEW_COLUMNS_SIZE, sizes.toString());
        }

        public void controlMoved(ControlEvent e) {
            if (!WaterfallTickerView.this.columnMove) {
                return;
            }
            int[] ord = WaterfallTickerView.this.table.getColumnOrder();
            int[] newOrd = new int[ord.length];
            StringBuffer ids = new StringBuffer();
            int i = 0;
            while (i < WaterfallTickerView.this.table.getColumnCount()) {
                newOrd[i] = i;
                TableColumn col = WaterfallTickerView.this.table.getColumn(ord[i]);
                ids.append(col.getData("columnId") + ";");
                ++i;
            }
            WaterfallTickerView.this.table.setColumnOrder(newOrd);
            WaterfallTickerView.this.preferences.setValue(WaterfallTickerView.PREFS_TICKER_VIEW_COLUMNS, ids.toString());
        }
    };
    IPropertyChangeListener prefChangeListenr = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(WaterfallTickerView.this.WFV_BG_COLOR1)) {
                WaterfallTickerView.this.background1 = WaterfallTickerView.this.theme.getColorRegistry().get(WaterfallTickerView.this.WFV_BG_COLOR1);
                WaterfallTickerView.this.clearTable();
                WaterfallTickerView.this.setRendererColors();
            }
            if (event.getProperty().equals(WaterfallTickerView.this.WFV_BG_COLOR2)) {
                WaterfallTickerView.this.background2 = WaterfallTickerView.this.theme.getColorRegistry().get(WaterfallTickerView.this.WFV_BG_COLOR2);
                WaterfallTickerView.this.clearTable();
                WaterfallTickerView.this.setRendererColors();
            }
            if (event.getProperty().equals(WaterfallTickerView.this.WFV_FONT_NAME)) {
                WaterfallTickerView.this.table.setFont(WaterfallTickerView.this.theme.getFontRegistry().get(WaterfallTickerView.this.WFV_FONT_NAME));
            }
            if (event.getProperty().equals(WaterfallTickerView.PREFS_TICKER_VIEW_COLUMNS)) {
                WaterfallTickerView.this.updateTable();
            }
        }
    };
    private int totalRows;
    private int rowPrinted;
    private boolean toggle;
    private Color color;

    private void clearTable() {
        this.table.clearAll();
        while (this.table.getItemCount() > 0) {
            this.table.getItem(0).dispose();
        }
        this.rowPrinted = 0;
    }

    public void init(IViewSite site) throws PartInitException {
        this.preferences = Activator.getDefault().getPreferenceStore();
        String[] ids = Activator.getDefault().getPreferenceStore().getString(PREF_SYMBOL_LIST).split(",");
        int i = 0;
        while (i < ids.length) {
            Security sec = CorePlugin.getRepository().getSecurityById(ids[i]);
            if (sec != null) {
                this.symbolList.add(sec);
            }
            ++i;
        }
        this.subscribeSymbols();
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.table = new Table(parent, 65808);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (WaterfallTickerView.this.table.getItem(new Point(e.x, e.y)) == null) {
                    WaterfallTickerView.this.table.deselectAll();
                }
            }
        });
        this.makeViewActions();
        this.preferences.addPropertyChangeListener(this.prefChangeListenr);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.theme = themeManager.getCurrentTheme();
        if (this.theme != null) {
            this.color = this.background1 = this.theme.getColorRegistry().get(this.WFV_BG_COLOR1);
            this.background2 = this.theme.getColorRegistry().get(this.WFV_BG_COLOR2);
            this.table.setFont(this.theme.getFontRegistry().get(this.WFV_FONT_NAME));
            this.theme.addPropertyChangeListener(this.prefChangeListenr);
        }
        this.contributeToActionBar();
        this.updateTable();
        this.calculateRows();
        parent.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                WaterfallTickerView.this.calculateRows();
            }
        });
    }

    private void subscribeSymbols() {
        int i = 0;
        while (i < this.symbolList.size()) {
            Security sec = this.symbolList.get(i);
            if (sec != null) {
                sec.getQuoteMonitor().addObserver((Observer)this);
                FeedMonitor.monitor((Security)sec);
            }
            ++i;
        }
    }

    private void unSubscribeSymbols() {
        int i = 0;
        while (i < this.symbolList.size()) {
            Security sec = this.symbolList.get(i);
            if (sec != null) {
                sec.getQuoteMonitor().deleteObserver((Observer)this);
                FeedMonitor.monitor((Security)sec);
            }
            ++i;
        }
    }

    private void calculateRows() {
        int rowHt = this.table.getItemHeight();
        int tHeight = this.parent.getSize().y - this.table.getHeaderHeight();
        this.totalRows = tHeight / rowHt;
    }

    public void verifyAdd(Security tm) {
        if (this.table != null && !this.table.isDisposed()) {
            int itemCount = this.table.getItemCount();
            if (itemCount < this.totalRows) {
                this.addTableRecord(tm);
            } else {
                if (this.rowPrinted > this.totalRows) {
                    this.rowPrinted = 0;
                }
                if (this.rowPrinted == 0) {
                    this.setRendererColors();
                }
                this.updateRecord(this.rowPrinted, tm);
                ++this.rowPrinted;
            }
        }
    }

    private void addTableRecord(final Security tm) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableItem tableItem = new TableItem(WaterfallTickerView.this.table, 0);
                WaterfallTickerView.this.update(tableItem, tm);
                int itemCount = WaterfallTickerView.this.table.getItemCount();
                if (itemCount > 1) {
                    tableItem.setBackground(WaterfallTickerView.this.table.getItem(itemCount - 2).getBackground());
                } else {
                    tableItem.setBackground(WaterfallTickerView.this.color);
                }
            }
        });
    }

    private void updateRecord(int rowPrinted, Security tm) {
        if (rowPrinted < this.table.getItemCount()) {
            TableItem item = this.table.getItem(rowPrinted);
            item.setBackground(this.color);
            this.update(item, tm);
        }
    }

    private void contributeToActionBar() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator("group6"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.appendToGroup("group1", (IAction)this.symbolListAction);
        menuManager.appendToGroup("group2", this.editColumnsAction);
        menuManager.appendToGroup("group2", (IAction)new ResizeColumnsAction(this.table));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("begin"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("group6"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("end"));
        toolBarManager.appendToGroup("group1", (IAction)this.symbolListAction);
        toolBarManager.appendToGroup("group1", (IAction)new ColorAndFontAction(new String[]{"ext.waterfallTicker"}));
    }

    private void makeViewActions() {
        this.editColumnsAction = new EditColumnsAction((Dialog)new ColumnsOptionDialog((IViewPart)this, PREFS_TICKER_VIEW_COLUMNS, PREFS_TICKER_VIEW_COLUMNS_SIZE, this.preferences));
        this.symbolListAction = new Action("Symbol Setting"){

            public void run() {
                SymbolSettingDialog symbol = new SymbolSettingDialog(WaterfallTickerView.this.symbolList, WaterfallTickerView.this.preferences, "WFTV");
                if (symbol.open() == 0) {
                    WaterfallTickerView.this.unSubscribeSymbols();
                    WaterfallTickerView.this.symbolList = symbol.getSymbolList();
                    WaterfallTickerView.this.preferences.setValue(WaterfallTickerView.PREF_SYMBOL_LIST, symbol.getPreference());
                    WaterfallTickerView.this.clearTable();
                    WaterfallTickerView.this.subscribeSymbols();
                }
            }
        };
        this.symbolListAction.setImageDescriptor(Activator.getImageDescriptor("icons/etool16/coins_add.png"));
    }

    public void updateTable() {
        this.columnMove = false;
        if (this.table != null && !this.table.isDisposed()) {
            int index = 0;
            String[] id = this.preferences.getString(PREFS_TICKER_VIEW_COLUMNS).split(";");
            int i = 0;
            while (i < id.length) {
                TableColumn tableColumn;
                String name = "";
                int style = 16384;
                Image image = null;
                ILabelProvider provider = this.registry.createLabelProvider(id[i]);
                if (provider != null) {
                    name = this.registry.getName(id[i]);
                    style = this.registry.getOrientation(id[i]);
                    if (provider instanceof ITableLabelProvider) {
                        name = ((ITableLabelProvider)provider).getColumnText(null, i);
                        image = ((ITableLabelProvider)provider).getColumnImage(null, i);
                    }
                } else {
                    LogFactory.getLog(this.getClass()).warn((Object)("Missing column [" + id[i] + "]"));
                }
                if (index < this.table.getColumnCount()) {
                    tableColumn = this.table.getColumn(index);
                    if (tableColumn.getData("labelProvider") != null) {
                        ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                    }
                } else {
                    tableColumn = new TableColumn(this.table, style);
                    tableColumn.addControlListener(this.columnControlListener);
                    tableColumn.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (e.widget.getData("labelProvider") != null) {
                                ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                            }
                        }
                    });
                }
                tableColumn.setText(name);
                tableColumn.setAlignment(style);
                tableColumn.setImage(image);
                tableColumn.setMoveable(true);
                tableColumn.setData("labelProvider", (Object)provider);
                tableColumn.setData("columnId", (Object)id[i]);
                ++index;
                ++i;
            }
            while (index < this.table.getColumnCount()) {
                this.table.getColumn(index).dispose();
            }
            this.table.removeAll();
            String[] sizes = this.preferences.getString(PREFS_TICKER_VIEW_COLUMNS_SIZE).split(";");
            int i2 = 0;
            while (i2 < this.table.getColumnCount()) {
                if (i2 < sizes.length && sizes[i2].length() != 0) {
                    this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
                } else {
                    this.table.getColumn(i2).setWidth(100);
                }
                ++i2;
            }
            if ("gtk".equals(SWT.getPlatform())) {
                this.table.getColumn(this.table.getColumnCount() - 1).pack();
            }
        }
        this.columnMove = true;
    }

    void update(TableItem tableItem, Security data) {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(i);
            ILabelProvider label = (ILabelProvider)tableColumn.getData("labelProvider");
            if (label != null) {
                tableItem.setText(i, label.getText((Object)data));
            }
            ++i;
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.unSubscribeSymbols();
        super.dispose();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof Security) {
            final Security s = (Security)arg1;
            if (this.parent != null && !this.parent.isDisposed()) {
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (s != null && s.getQuote() != null && s.getQuote().getLast() != 0.0 && s.getQuote().getQuoteType().equals("LLT")) {
                            WaterfallTickerView.this.verifyAdd(s);
                        }
                    }
                });
            }
        }
    }

    private void setRendererColors() {
        this.toggle = !this.toggle;
        this.color = this.toggle ? this.background2 : this.background1;
    }
}

