/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.views;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.TickerData;
import pk.com.softech.tradingterminal.core.ui.views.TickerView;
import pk.com.softech.tradingterminal.ext.Activator;
import pk.com.softech.tradingterminal.ext.dialog.SymbolSettingDialog;
import pk.com.softech.tradingterminal.trading.views.QuoteRequestView;

public class SymbolTickerView
extends TickerView {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.ext.views.SymbolTickerView";
    Composite parent;
    Action symbolListSettingAction;
    static final String PREF_SYMBOL_LIST_SETTINGS = "STV_SYMBOL_LIST_SETTINGS";
    IPreferenceStore prefs;
    NumberFormat priceFormat = CorePlugin.getPriceFormatter();
    NumberFormat percentFormat = CorePlugin.getPercentageFormatter();
    ArrayList<Security> symbolList = new ArrayList();
    MouseListener mouseClickListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(final MouseEvent e) {
            SymbolTickerView.this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (e.getSource() instanceof Label) {
                            Label lbl = (Label)e.getSource();
                            TickerData data = (TickerData)lbl.getData();
                            Security sec = CorePlugin.getRepository().getSecurityById(data.getId());
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            QuoteRequestView qrView = (QuoteRequestView)page.showView("pk.com.softech.tradingterminal.trading.quoteRequest");
                            if (sec != null) {
                                qrView.setSecurity(sec);
                            }
                        }
                    }
                    catch (PartInitException e2) {
                        e2.printStackTrace();
                    }
                }
            });
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };
    Observer securityObserver = new Observer(){

        @Override
        public void update(Observable arg0, Object arg1) {
            Security s;
            if (arg1 instanceof Security && (s = (Security)arg1) != null && s.getQuote().getQuoteType().equals("LLT")) {
                int i = 0;
                while (i < SymbolTickerView.this.tickerData.size()) {
                    TickerData data = (TickerData)SymbolTickerView.this.tickerData.get(i);
                    if (data.getId().equals(s.getId())) {
                        SymbolTickerView.this.formateLabel(s, data);
                        break;
                    }
                    ++i;
                }
            }
        }
    };

    public SymbolTickerView() {
        super("STV_", "ext.SymbolTicker");
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.prefs = Activator.getDefault().getPreferenceStore();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        super.createPartControl(parent);
        this.addMouseClickListener(this.mouseClickListener);
        this.createActions();
        String[] ids = this.prefs.getString(PREF_SYMBOL_LIST_SETTINGS).split(",");
        int i = 0;
        while (i < ids.length) {
            Security sec = CorePlugin.getRepository().getSecurityById(ids[i]);
            if (sec != null) {
                this.symbolList.add(sec);
                this.addToList(sec);
            }
            ++i;
        }
    }

    private void addToList(Security sec) {
        sec.getQuoteMonitor().addObserver(this.securityObserver);
        FeedMonitor.monitor((Security)sec);
        TickerData data = new TickerData(sec.getId(), "", sec.getDescription());
        this.formateLabel(sec, data);
        this.tickerData.add((Object)data);
    }

    private void removeFromList(TickerData data) {
        Security s = CorePlugin.getRepository().getSecurityById(data.getId());
        if (s != null) {
            s.getQuoteMonitor().deleteObserver(this.securityObserver);
            FeedMonitor.cancelMonitor((Security)s);
            this.tickerData.remove((Object)data);
        }
    }

    private String formateLabel(Security sec, TickerData data) {
        String lable = " " + sec.getSymbol() + " " + " ";
        if (sec.getChange() > 0.0) {
            lable = String.valueOf(lable) + this.priceFormat.format(sec.getQuote().getLast()) + " (+" + this.priceFormat.format(sec.getChange()) + " " + ":" + " " + "+" + this.percentFormat.format(sec.getChangePerc()) + ")" + " ";
            data.setColor("FG_COLOR_POSITIVE");
        } else if (sec.getChange() < 0.0) {
            lable = String.valueOf(lable) + this.priceFormat.format(sec.getQuote().getLast()) + " (" + this.priceFormat.format(sec.getChange()) + " " + ":" + " " + this.percentFormat.format(sec.getChangePerc()) + ")" + " ";
            data.setColor("FG_COLOR_NEGATIVE");
        } else {
            lable = String.valueOf(lable) + this.priceFormat.format(sec.getQuote().getLast()) + " (" + this.priceFormat.format(sec.getChange()) + " " + ":" + " " + this.percentFormat.format(sec.getChangePerc()) + ")" + " ";
            data.setColor("FG_COLOR_EQUAL");
        }
        data.setLabel(lable);
        data.clearChanged();
        return lable;
    }

    private void createActions() {
        this.symbolListSettingAction = new Action("Symbol Settings"){

            public void run() {
                SymbolSettingDialog dialog = new SymbolSettingDialog(new ArrayList<Security>(SymbolTickerView.this.symbolList), SymbolTickerView.this.prefs, "STV");
                if (dialog.open() == 0) {
                    while (SymbolTickerView.this.tickerData.size() > 0) {
                        SymbolTickerView.this.removeFromList((TickerData)SymbolTickerView.this.tickerData.get(0));
                    }
                    SymbolTickerView.this.symbolList = dialog.getSymbolList();
                    SymbolTickerView.this.prefs.setValue(SymbolTickerView.PREF_SYMBOL_LIST_SETTINGS, dialog.getPreference().toString());
                    int i = 0;
                    while (i < SymbolTickerView.this.symbolList.size()) {
                        SymbolTickerView.this.addToList(SymbolTickerView.this.symbolList.get(i));
                        ++i;
                    }
                }
            }
        };
        this.symbolListSettingAction.setToolTipText("Symbol Settings");
        this.symbolListSettingAction.setImageDescriptor(Activator.getImageDescriptor("icons/etool16/coins_add.png"));
        IMenuManager menuManager = super.getViewSite().getActionBars().getMenuManager();
        menuManager.appendToGroup("top", (IAction)this.symbolListSettingAction);
        IToolBarManager toolBarManager = super.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.appendToGroup("top", (IAction)this.symbolListSettingAction);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }
}

