/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.views;

import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.SpotSymbolData;
import pk.com.softech.messages.SpotSymbolRequest;
import pk.com.softech.messages.SpotSymbolResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.ext.Activator;

public class SpotSymbolsView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.ext.views.SpotSymbolView";
    public static final String PREFS_SPOT_SYMBOLS_VIEW_COLUMNS_SIZE = "PREFS_SPOT_SYMBOLS_VIEW_COLUMNS_SIZE";
    private static final int LABEL_WIDTH = 125;
    private static final int LABEL_HEIGHT = 15;
    private static final int TEXT_WIDTH = 90;
    private static final int TEXT_HEIGHT = 15;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 22;
    private Composite parent;
    Composite content;
    Button btnFetch = null;
    Text txtDate = null;
    Table table_acc = null;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    Font font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    private NumberFormat nf = CorePlugin.getNumberFormatter();
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < SpotSymbolsView.this.table_acc.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(SpotSymbolsView.this.table_acc.getColumn(i).getWidth())) + ";");
                ++i;
            }
            Activator.getDefault().getPreferenceStore().setValue(SpotSymbolsView.PREFS_SPOT_SYMBOLS_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };

    public SpotSymbolsView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridData lblGridData = new GridData(125, 15);
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, true));
        this.createLabel(composite, "Date", lblGridData, this.font_bold);
        this.txtDate = new Text(composite, 2048);
        this.txtDate.setText(Utility.getCurrentDate());
        this.txtDate.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtDate.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    SpotSymbolsView.this.sendSpotSymbolRequest();
                }
            }
        });
        this.btnFetch = new Button(composite, 0);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SpotSymbolsView.this.sendSpotSymbolRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table_acc = new Table(this.content, 68354);
        this.table_acc.setHeaderVisible(true);
        this.table_acc.setLinesVisible(true);
        lblGridData = new GridData(4, 4, true, true, 3, 1);
        this.table_acc.setLayoutData((Object)lblGridData);
        TableColumn column = new TableColumn(this.table_acc, 0);
        column.setText("Symbol");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Spot Date");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Spot Date Till");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Face Value (in Rs.)");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Dividend (in %-age)");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Bonus Share(in %-age)");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Right Share (in %-age)");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Premium(in Rs.)");
        column.addControlListener(this.columnControlListener);
        String[] sizes = Activator.getDefault().getPreferenceStore().getString(PREFS_SPOT_SYMBOLS_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < this.table_acc.getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                this.table_acc.getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                this.table_acc.getColumn(i).setWidth(100);
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            this.table_acc.getColumn(this.table_acc.getColumnCount() - 1).pack();
        }
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
    }

    private void sendSpotSymbolRequest() {
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            Date fromDate = Utility.getDate((String)this.txtDate.getText());
            if (fromDate != null) {
                SpotSymbolRequest spotRequest = new SpotSymbolRequest(fromDate);
                if (Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)spotRequest)) {
                    this.btnFetch.setEnabled(false);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Invalid date pattern, expected : " + CorePlugin.getDateParse().toPattern());
            }
        }
    }

    private Label createLabel(Composite parent, String label, GridData gridData, Font font) {
        Label temp = new Label(parent, 0);
        temp.setFont(font);
        temp.setText(label);
        return temp;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof SpotSymbolResponse) {
                        SpotSymbolResponse rsp = (SpotSymbolResponse)o;
                        SpotSymbolsView.this.recieveSpotSymbolResponse(rsp);
                        SpotSymbolsView.this.btnFetch.setEnabled(true);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void recieveSpotSymbolResponse(final SpotSymbolResponse resp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    SpotSymbolsView.this.table_acc.removeAll();
                    SpotSymbolData[] tempData = resp.getrows();
                    int i = 0;
                    while (i < tempData.length) {
                        Date date;
                        TableItem item = new TableItem(SpotSymbolsView.this.table_acc, 0);
                        if (tempData[i].getSymbolName() != null) {
                            item.setText(0, tempData[i].getSymbolName().toString());
                        }
                        if (tempData[i].getSpotDate() != null) {
                            date = tempData[i].getSpotDate();
                            item.setText(1, CorePlugin.getDateFormat().format(date));
                        }
                        if (tempData[i].getSpotTillDate() != null) {
                            date = tempData[i].getSpotTillDate();
                            item.setText(2, CorePlugin.getDateFormat().format(date));
                        }
                        item.setText(3, SpotSymbolsView.this.nf.format(tempData[i].getFaceValue()));
                        item.setText(4, SpotSymbolsView.this.pf.format(tempData[i].getDividend()));
                        item.setText(5, SpotSymbolsView.this.pf.format(tempData[i].getBonusShare()));
                        item.setText(6, SpotSymbolsView.this.pf.format(tempData[i].getRightShare()));
                        item.setText(7, SpotSymbolsView.this.pf.format(tempData[i].getPremium()));
                        ++i;
                    }
                }
                catch (Exception e) {
                    SpotSymbolsView.this.logger.error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }
}

