/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LockedSymbolData;
import pk.com.softech.messages.LockedSymbolRequest;
import pk.com.softech.messages.LockedSymbolResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.LockedSecurity;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.ext.Activator;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class LockedSymbolsView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.ext.views.LockedSymbolView";
    public static final String PREFS_UPPER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE = "PREFS_UPPER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE";
    public static final String PREFS_LOWER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE = "PREFS_LOWER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE";
    private static final SimpleDateFormat sdf = CorePlugin.getDateTimeFormatLong();
    private static final NumberFormat nf = CorePlugin.getNumberFormatter();
    private Composite parent;
    Group cmpNorth;
    Composite content;
    Action refreshAction;
    Text txtDate = null;
    Table table_upper_locked = null;
    Table table_lower_locked = null;
    protected Log logger = LogFactory.getLog(this.getClass());
    static final int MARKET = 0;
    static final int SYMBOL = 1;
    static final int VOLUME = 2;
    static final int PRICE = 3;
    static final int DATE = 4;
    static final String[] COLUMN_NAMES = new String[]{"Market", "Symbol", "Volume", "Last Price", "LTrdTime"};
    Font font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
    Color ulsColor = new Color(null, new RGB(176, 255, 176));
    Color llsColor = new Color(null, new RGB(255, 157, 157));
    private ControlListener columnUpperControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizesUpperLockedSymbols = new StringBuffer();
            int i = 0;
            while (i < LockedSymbolsView.this.table_upper_locked.getColumnCount()) {
                sizesUpperLockedSymbols.append(String.valueOf(String.valueOf(LockedSymbolsView.this.table_upper_locked.getColumn(i).getWidth())) + ";");
                ++i;
            }
            Activator.getDefault().getPreferenceStore().setValue(LockedSymbolsView.PREFS_UPPER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE, sizesUpperLockedSymbols.toString());
        }
    };
    private ControlListener columnLowerControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizesLowerLockedSymbols = new StringBuffer();
            int i = 0;
            while (i < LockedSymbolsView.this.table_lower_locked.getColumnCount()) {
                sizesLowerLockedSymbols.append(String.valueOf(String.valueOf(LockedSymbolsView.this.table_lower_locked.getColumn(i).getWidth())) + ";");
                ++i;
            }
            Activator.getDefault().getPreferenceStore().setValue(LockedSymbolsView.PREFS_LOWER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE, sizesLowerLockedSymbols.toString());
        }
    };

    public LockedSymbolsView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allLockedSymbols().addCollectionObserver((ICollectionObserver)this);
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                LockedSymbolsView.this.sendLockedSymbolRequest();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor((String)"icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor((String)"icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
    }

    private void contributeToActionBars() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator("top"));
        manager.add((IContributionItem)new Separator("group0"));
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IContributionItem)new Separator("group3"));
        manager.add((IContributionItem)new Separator("group4"));
        manager.add((IContributionItem)new Separator("group5"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content.setLayout((Layout)new GridLayout(1, false));
        Group grpLockedSymbol = new Group(this.content, 0);
        grpLockedSymbol.setText("");
        grpLockedSymbol.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)grpLockedSymbol);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)grpLockedSymbol);
        Group grpUpperLockedSymbol = new Group((Composite)grpLockedSymbol, 0);
        grpUpperLockedSymbol.setText("Upper Locked Symbols");
        grpUpperLockedSymbol.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)grpUpperLockedSymbol);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)grpUpperLockedSymbol);
        this.table_upper_locked = new Table((Composite)grpUpperLockedSymbol, 68354);
        this.table_upper_locked.setHeaderVisible(true);
        this.table_upper_locked.setLinesVisible(true);
        this.table_upper_locked.setLayoutData((Object)new GridData(4, 4, true, true));
        Group grpLowerLockedSymbol = new Group((Composite)grpLockedSymbol, 0);
        grpLowerLockedSymbol.setText("Lower Locked Symbols");
        grpLowerLockedSymbol.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)grpLowerLockedSymbol);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)grpLowerLockedSymbol);
        this.table_lower_locked = new Table((Composite)grpLowerLockedSymbol, 68354);
        this.table_lower_locked.setHeaderVisible(true);
        this.table_lower_locked.setLinesVisible(true);
        this.table_lower_locked.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn column = new TableColumn(this.table_upper_locked, 0);
        column.setText(COLUMN_NAMES[0]);
        column.addControlListener(this.columnUpperControlListener);
        column = new TableColumn(this.table_upper_locked, 0);
        column.setText(COLUMN_NAMES[1]);
        column.addControlListener(this.columnUpperControlListener);
        column = new TableColumn(this.table_upper_locked, 0);
        column.setText(COLUMN_NAMES[2]);
        column.addControlListener(this.columnUpperControlListener);
        column = new TableColumn(this.table_upper_locked, 0);
        column.setText(COLUMN_NAMES[3]);
        column.addControlListener(this.columnUpperControlListener);
        column = new TableColumn(this.table_upper_locked, 0);
        column.setText(COLUMN_NAMES[4]);
        column.addControlListener(this.columnUpperControlListener);
        TableColumn lower_locked_column = new TableColumn(this.table_lower_locked, 0);
        lower_locked_column.setText(COLUMN_NAMES[0]);
        lower_locked_column.addControlListener(this.columnLowerControlListener);
        lower_locked_column = new TableColumn(this.table_lower_locked, 0);
        lower_locked_column.setText(COLUMN_NAMES[1]);
        lower_locked_column.addControlListener(this.columnLowerControlListener);
        lower_locked_column = new TableColumn(this.table_lower_locked, 0);
        lower_locked_column.setText(COLUMN_NAMES[2]);
        lower_locked_column.addControlListener(this.columnLowerControlListener);
        lower_locked_column = new TableColumn(this.table_lower_locked, 0);
        lower_locked_column.setText(COLUMN_NAMES[3]);
        lower_locked_column.addControlListener(this.columnLowerControlListener);
        lower_locked_column = new TableColumn(this.table_lower_locked, 0);
        lower_locked_column.setText(COLUMN_NAMES[4]);
        lower_locked_column.addControlListener(this.columnLowerControlListener);
        int i = 0;
        while (i < CorePlugin.getRepository().allLockedSymbols().size()) {
            this.addToTable((LockedSecurity)CorePlugin.getRepository().allLockedSymbols().get(i));
            ++i;
        }
        String[] sizes = Activator.getDefault().getPreferenceStore().getString(PREFS_UPPER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE).split(";");
        int i2 = 0;
        while (i2 < this.table_upper_locked.getColumnCount()) {
            if (i2 < sizes.length && sizes[i2].length() != 0) {
                this.table_upper_locked.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
            } else {
                this.table_upper_locked.getColumn(i2).setWidth(50);
            }
            ++i2;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            this.table_upper_locked.getColumn(this.table_upper_locked.getColumnCount() - 1).pack();
        }
        sizes = Activator.getDefault().getPreferenceStore().getString(PREFS_LOWER_LOCKED_SYMBOLS_VIEW_COLUMNS_SIZE).split(";");
        i2 = 0;
        while (i2 < this.table_lower_locked.getColumnCount()) {
            if (i2 < sizes.length && sizes[i2].length() != 0) {
                this.table_lower_locked.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
            } else {
                this.table_lower_locked.getColumn(i2).setWidth(50);
            }
            ++i2;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            this.table_lower_locked.getColumn(this.table_lower_locked.getColumnCount() - 1).pack();
        }
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        if (Resources.tcpLink && Resources.refDataComplete && Resources.trnCode.contains("OV13")) {
            this.sendLockedSymbolRequest();
        }
        this.makeViewActions();
        this.contributeToActionBars();
    }

    private Label createLabel(Composite parent, String label, GridData gridData, Font font, Color color) {
        Label temp = new Label(parent, 0);
        temp.setFont(font);
        temp.setText(label);
        temp.setForeground(color);
        temp.setLayoutData((Object)gridData);
        return temp;
    }

    private void sendLockedSymbolRequest() {
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            LockedSymbolRequest req = new LockedSymbolRequest();
            Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)req);
        }
    }

    public void setFocus() {
    }

    public void recieveLockedSymbolResponse(final LockedSymbolResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CorePlugin.getRepository().allLockedSymbols().clear();
                        LockedSymbolData[] tempData = resp.getrows();
                        LockedSymbolsView.this.filterData(tempData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.refreshAction.setEnabled(false);
        }
    }

    public LockedSecurity[] filterData(LockedSymbolData[] data) {
        LockedSecurity[] lockedSecurity = new LockedSecurity[data.length];
        if (data != null && data.length != 0) {
            int i = 0;
            while (i < data.length) {
                float change = Float.valueOf(data[i].getSymbolChange().trim()).floatValue();
                if (change < 0.0f) {
                    if (!data[i].getMarket().equalsIgnoreCase("ODL")) {
                        lockedSecurity[i] = new LockedSecurity(data[i].getMarket(), data[i].getLockedSymbol(), data[i].getSellVolume(), data[i].getLastPrice(), data[i].getLTrdTime(), false);
                    }
                } else if (!data[i].getMarket().equalsIgnoreCase("ODL")) {
                    lockedSecurity[i] = new LockedSecurity(data[i].getMarket(), data[i].getLockedSymbol(), data[i].getBuyVolume(), data[i].getLastPrice(), data[i].getLTrdTime(), true);
                }
                CorePlugin.getRepository().allLockedSymbols().add((Object)lockedSecurity[i]);
                ++i;
            }
        }
        return lockedSecurity;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LockedSymbolResponse) {
                        LockedSymbolResponse rsp = (LockedSymbolResponse)o;
                        LockedSymbolsView.this.recieveLockedSymbolResponse(rsp);
                        LockedSymbolsView.this.refreshAction.setEnabled(true);
                    } else if (o instanceof LockedSecurity) {
                        LockedSecurity rsp = (LockedSecurity)o;
                        System.out.println("LockedSecurity rsp" + rsp.getMarket());
                        if (!rsp.getMarket().equalsIgnoreCase("ODL")) {
                            rsp.addObserver((Observer)LockedSymbolsView.this);
                            LockedSymbolsView.this.addToTable(rsp);
                        }
                    }
                }
            });
        }
    }

    private void addToTable(LockedSecurity sec) {
        TableItem item;
        if (sec.isUpperLocked()) {
            item = new TableItem(this.table_upper_locked, 0);
            item.setBackground(this.ulsColor);
        } else {
            item = new TableItem(this.table_lower_locked, 0);
            item.setBackground(this.llsColor);
        }
        item.setText(0, sec.getMarket());
        item.setText(1, sec.getSymbol());
        item.setText(2, nf.format(sec.getVolume()));
        item.setText(3, sec.getLastPrice());
        try {
            item.setText(4, sdf.format(sec.getDate()));
        }
        catch (Exception exception) {
            item.setText(4, "");
        }
    }

    public void itemRemoved(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LockedSecurity) {
                        LockedSecurity rsp = (LockedSecurity)o;
                        rsp.deleteObserver((Observer)LockedSymbolsView.this);
                        LockedSymbolsView.this.removeFromTable(rsp);
                    }
                }
            });
        }
    }

    private void removeFromTable(LockedSecurity rsp) {
        TableItem item;
        int i = 0;
        while (i < this.table_lower_locked.getItemCount()) {
            item = this.table_lower_locked.getItem(i);
            if (item.getText(0).equals(rsp.getMarket()) && item.getText(1).equals(rsp.getSymbol())) {
                item.dispose();
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.table_upper_locked.getItemCount()) {
            item = this.table_upper_locked.getItem(i);
            if (item.getText(0).equals(rsp.getMarket()) && item.getText(1).equals(rsp.getSymbol())) {
                item.dispose();
                return;
            }
            ++i;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.parent != null && !this.parent.isDisposed()) {
            final LockedSecurity sec = (LockedSecurity)o;
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    block11: {
                        try {
                            if (sec.isUpperLocked()) {
                                int i = 0;
                                while (i < LockedSymbolsView.this.table_upper_locked.getItemCount()) {
                                    TableItem item = LockedSymbolsView.this.table_upper_locked.getItem(i);
                                    item.setBackground(LockedSymbolsView.this.ulsColor);
                                    if (item.getText(0).equals(sec.getMarket()) && item.getText(1).equals(sec.getSymbol())) {
                                        item.setText(2, nf.format(sec.getVolume()));
                                        item.setText(3, sec.getLastPrice());
                                        try {
                                            item.setText(4, sdf.format(sec.getDate()));
                                        }
                                        catch (Exception exception) {
                                            item.setText(4, "");
                                        }
                                        return;
                                    }
                                    ++i;
                                }
                                break block11;
                            }
                            int i = 0;
                            while (i < LockedSymbolsView.this.table_lower_locked.getItemCount()) {
                                TableItem item = LockedSymbolsView.this.table_lower_locked.getItem(i);
                                item.setBackground(LockedSymbolsView.this.llsColor);
                                if (item.getText(0).equals(sec.getMarket()) && item.getText(1).equals(sec.getSymbol())) {
                                    item.setText(2, nf.format(sec.getVolume()));
                                    item.setText(3, sec.getLastPrice());
                                    try {
                                        item.setText(4, sdf.format(sec.getDate()));
                                    }
                                    catch (Exception exception) {
                                        item.setText(4, "");
                                    }
                                    return;
                                }
                                ++i;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    public void dispose() {
        ObservableList list = CorePlugin.getRepository().allLockedSymbols();
        int i = 0;
        while (i < list.size()) {
            ((LockedSecurity)list.get(i)).deleteObserver((Observer)this);
            ++i;
        }
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        list.removeCollectionObserver((ICollectionObserver)this);
        if (this.ulsColor != null) {
            this.ulsColor.dispose();
        }
        if (this.llsColor != null) {
            this.llsColor.dispose();
        }
        super.dispose();
    }
}

