/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.trading.views;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.TradeHistoryData;
import pk.com.softech.messages.TradeHistoryRequest;
import pk.com.softech.messages.TradeHistoryResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class TradingHistoryView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.ext.views.TradingHistoryView";
    public static final int ACCOUNT = 0;
    public static final int SYMBOL = 1;
    public static final int NOOFSHARES = 2;
    public static final int CURRENTPRICE = 3;
    public static final int VALUE = 4;
    private String[] columnsName = new String[]{"Date", "Quantity", "Rate", "Cum Quantity", "W.Average", "Amount"};
    private Text txtClientCode;
    private Text txtSymbol;
    private Text txtDateFrom;
    private Text txtDateTo;
    private Button btnFetch;
    private Composite parent;
    private Table table;
    private ArrayList<TradeHistoryData> list = new ArrayList();
    private static final int VIEW_WIDTH = 635;
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    private NumberFormat nf = CorePlugin.getNumberFormatter();
    private DateFormat df = CorePlugin.getDateFormat();
    Label lblPerchased;
    Label lblSold;
    Label lblCustody;
    Label lblProfitLoss;
    Label lblNoOfShares;
    Label lblAmount;
    Label lblPerShares;
    Label lblperAmount;
    Label lblSoldShares;
    Label lblSoldAmount;
    Label lblCustodyShares;
    Label lblCustodyAmount;
    Label lblPLShares;
    Label lblPLAmount;

    public TradingHistoryView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        Composite composite = new Composite((Composite)sc, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(9).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().hint(635, -1).applyTo((Control)composite);
        Label lblClientCode = new Label(composite, 0);
        lblClientCode.setText("Client Code");
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        if (!Resources.isClientType() && Resources.loginStatus) {
            this.txtClientCode.setEnabled(true);
        } else {
            this.txtClientCode.setText(Resources.clientId);
            this.txtClientCode.setEnabled(false);
        }
        Label lblSymbol = new Label(composite, 0);
        lblSymbol.setText("Symbol");
        this.txtSymbol = new Text(composite, 2048);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    TradingHistoryView.this.sendRequest();
                }
            }
        });
        Label lblDatefrm = new Label(composite, 0);
        lblDatefrm.setText("Date From");
        this.txtDateFrom = new Text(composite, 2048);
        this.txtDateFrom.setText(Utility.getCurrentDate());
        Label lblDateTo = new Label(composite, 0);
        lblDateTo.setText("Date To");
        this.txtDateTo = new Text(composite, 2048);
        this.txtDateTo.setText(Utility.getCurrentDate());
        this.txtDateFrom.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    TradingHistoryView.this.sendRequest();
                }
            }
        });
        this.txtDateTo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    TradingHistoryView.this.sendRequest();
                }
            }
        });
        this.txtClientCode.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    TradingHistoryView.this.sendRequest();
                }
            }
        });
        this.btnFetch = new Button(composite, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    TradingHistoryView.this.sendRequest();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group grpSummary = new Group(composite, 1);
        grpSummary.setText("Summary");
        Font fontBold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        grpSummary.setFont(fontBold);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 4).span(9, 1).applyTo((Control)grpSummary);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).applyTo((Composite)grpSummary);
        this.createLable(grpSummary, "");
        this.createLable(grpSummary, "Quantity").setFont(fontBold);
        this.createLable(grpSummary, "Amount").setFont(fontBold);
        this.createLable(grpSummary, "Purchased").setFont(fontBold);
        this.lblPerShares = this.createLable(grpSummary, "");
        this.lblperAmount = this.createLable(grpSummary, "");
        this.createLable(grpSummary, "Sold").setFont(fontBold);
        this.lblSoldShares = this.createLable(grpSummary, "");
        this.lblSoldAmount = this.createLable(grpSummary, "");
        this.createLable(grpSummary, "Custody").setFont(fontBold);
        this.lblCustodyShares = this.createLable(grpSummary, "");
        this.lblCustodyAmount = this.createLable(grpSummary, "");
        this.createLable(grpSummary, "Profit/Loss").setFont(fontBold);
        this.lblPLShares = this.createLable(grpSummary, "");
        this.lblPLAmount = this.createLable(grpSummary, "");
        this.table = new Table(composite, 65540);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(9, 1).applyTo((Control)this.table);
        TableColumn tc = new TableColumn(this.table, 0x1000000);
        tc.setText(this.columnsName[0]);
        tc.setWidth(100);
        tc.setAlignment(131072);
        int i = 1;
        while (i < this.columnsName.length) {
            this.createColumns(this.columnsName[i], 131072);
            ++i;
        }
        this.table.setHeaderVisible(true);
        sc.setContent((Control)composite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(635, -1);
    }

    private Label createLable(Group grpSummary, String text) {
        Label lbl = new Label((Composite)grpSummary, 0);
        lbl.setText(text);
        return lbl;
    }

    private void createColumns(String columnsName, int allignment) {
        TableColumn tc = new TableColumn(this.table, 0x1000000);
        tc.setText(columnsName);
        tc.setWidth(100);
        tc.setAlignment(allignment);
    }

    public void sendRequest() {
        block14: {
            if (!(this.txtClientCode.getText().equals("") || this.txtSymbol.getText().equals("") || this.txtDateFrom.getText().equals("") || this.txtDateTo.getText().equals(""))) {
                try {
                    Date from = this.df.parse(this.txtDateFrom.getText());
                    Date to = this.df.parse(this.txtDateTo.getText());
                    if (!to.before(from)) {
                        if (Resources.getServerLink((String)"", (boolean)false, (boolean)true) != null) {
                            TradeHistoryRequest req = new TradeHistoryRequest();
                            req.setSymbol(this.txtSymbol.getText());
                            req.setClient(this.txtClientCode.getText());
                            req.setFromDate(from);
                            req.setToDate(to);
                            if (Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)req)) {
                                this.table.removeAll();
                                this.list.clear();
                                this.btnFetch.setEnabled(false);
                            }
                        }
                        break block14;
                    }
                    MessageDialog.openError(null, (String)"Date Error", (String)"From date is greater than To date");
                }
                catch (Exception exception) {
                    MessageDialog.openError(null, (String)"Date Error", (String)"Invalid Date");
                }
            } else if (this.txtClientCode.getText().trim().equals("")) {
                MessageDialog.openError(null, (String)"Invalid Client Code", (String)"Please enter client code");
            } else if (this.txtSymbol.getText().trim().equals("")) {
                MessageDialog.openError(null, (String)"Invalid Symbol", (String)"Please enter valid symbol");
            } else if (this.txtDateFrom.getText().equals("")) {
                MessageDialog.openError(null, (String)"Invalid From Date", (String)"Please enter from date");
            } else if (this.txtDateTo.getText().equals("")) {
                MessageDialog.openError(null, (String)"Invalid To Date", (String)"Please enter to date");
            }
        }
    }

    public void recieveResponse(final TradeHistoryResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TradingHistoryView.this.list.addAll(Arrays.asList(resp.getRows()));
                        TradingHistoryView.this.CreateItems();
                        TradingHistoryView.this.btnFetch.setEnabled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void CreateItems() {
        int totalBuy = 0;
        int totalSell = 0;
        int perAmount = 0;
        int sellAmount = 0;
        Iterator<TradeHistoryData> itr = this.list.iterator();
        double lastPrice = 0.0;
        while (itr.hasNext()) {
            String volume;
            TradeHistoryData custodyobj = itr.next();
            if (custodyobj.getVolume() >= 0) {
                volume = this.nf.format(custodyobj.getVolume());
                totalBuy += custodyobj.getVolume();
                perAmount = (int)((double)perAmount + (double)custodyobj.getVolume() * custodyobj.getPrice());
            } else {
                volume = "(" + this.nf.format(Math.abs(custodyobj.getVolume())) + ")";
                totalSell += Math.abs(custodyobj.getVolume());
                sellAmount = (int)((double)sellAmount + (double)Math.abs(custodyobj.getVolume()) * custodyobj.getPrice());
            }
            lastPrice = custodyobj.getwAvgPrice();
            String[] itemData = new String[]{this.df.format(custodyobj.getTradeDate()), volume, this.pf.format(custodyobj.getPrice()), this.nf.format(custodyobj.getCumVolume()), this.pf.format(custodyobj.getwAvgPrice()), this.pf.format((double)custodyobj.getCumVolume() * custodyobj.getwAvgPrice())};
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(itemData);
        }
        this.lblPerShares.setText(this.nf.format(totalBuy));
        this.lblperAmount.setText(this.pf.format(perAmount));
        this.lblSoldShares.setText("(" + this.nf.format(totalSell) + ")");
        this.lblSoldAmount.setText("(" + this.pf.format(sellAmount) + ")");
        double custodyAmt = lastPrice * (double)(totalBuy - totalSell);
        if (totalBuy - totalSell < 0) {
            this.lblCustodyShares.setText("(" + this.nf.format(Math.abs(totalBuy - totalSell)) + ")");
        } else {
            this.lblCustodyShares.setText(this.nf.format(totalBuy - totalSell));
        }
        if (custodyAmt < 0.0) {
            this.lblCustodyAmount.setText("(" + this.pf.format(Math.abs(custodyAmt)) + ")");
        } else {
            this.lblCustodyAmount.setText(this.pf.format(custodyAmt));
        }
        double profitLoss = custodyAmt + (double)sellAmount - (double)perAmount;
        this.lblPLShares.setText(this.nf.format(totalSell));
        if (profitLoss < 0.0) {
            this.lblPLAmount.setText("(" + this.pf.format(Math.abs(profitLoss)) + ")");
        } else {
            this.lblPLAmount.setText(this.pf.format(profitLoss));
        }
    }

    public void setFocus() {
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        if (!Resources.isClientType()) {
                            TradingHistoryView.this.txtClientCode.setEnabled(true);
                            TradingHistoryView.this.txtClientCode.setText("");
                        } else {
                            TradingHistoryView.this.txtClientCode.setEnabled(false);
                            TradingHistoryView.this.txtClientCode.setText(Resources.clientId);
                        }
                    } else if (o instanceof TradeHistoryResponse) {
                        TradeHistoryResponse rsp = (TradeHistoryResponse)o;
                        TradingHistoryView.this.recieveResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }
}

