/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.trading.views;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.SymbolPositionsData;
import pk.com.softech.messages.SymbolPositionsRequest;
import pk.com.softech.messages.SymbolPositionsResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class SymbolPositionView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.ext.views.symbolPositiontView";
    public static final int ACCOUNT = 0;
    public static final int SYMBOL = 1;
    public static final int NOOFSHARES = 2;
    public static final int CURRENTPRICE = 3;
    public static final int VALUE = 4;
    private String[] columnsName = new String[]{"Accounts", "Symbol", "No.Of Shares", "Current Price", "Value"};
    private Text txtClientCode;
    private Text txtSymbol;
    private Button btnFetch;
    private Composite parent;
    private Table table;
    private ArrayList<SymbolPositionsData> list = new ArrayList();
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    private NumberFormat nf = CorePlugin.getNumberFormatter();
    int sortColumn = 0;
    int sortDirection = 1;
    Comparator<SymbolPositionsData> custodySorter = new Comparator<SymbolPositionsData>(){

        @Override
        public int compare(SymbolPositionsData o1, SymbolPositionsData o2) {
            if (SymbolPositionView.this.sortColumn == 0) {
                if (SymbolPositionView.this.sortDirection == 0) {
                    return o1.getClientCode().compareTo(o2.getClientCode());
                }
                return o2.getClientCode().compareTo(o1.getClientCode());
            }
            if (SymbolPositionView.this.sortColumn == 1) {
                if (SymbolPositionView.this.sortDirection == 0) {
                    return o1.getSymbol().compareTo(o2.getSymbol());
                }
                return o2.getSymbol().compareTo(o1.getSymbol());
            }
            if (SymbolPositionView.this.sortColumn == 2) {
                if (SymbolPositionView.this.sortDirection == 0) {
                    if (o1.getNoOfShares() == o2.getNoOfShares()) {
                        return 0;
                    }
                    return o1.getNoOfShares() < o2.getNoOfShares() ? -1 : 1;
                }
                if (o1.getNoOfShares() == o2.getNoOfShares()) {
                    return 0;
                }
                return -1 * (o1.getNoOfShares() < o2.getNoOfShares() ? -1 : 1);
            }
            if (SymbolPositionView.this.sortColumn == 3) {
                if (SymbolPositionView.this.sortDirection == 0) {
                    if (o1.getPrice() == o2.getPrice()) {
                        return 0;
                    }
                    return o1.getPrice() < o2.getPrice() ? -1 : 1;
                }
                if (o1.getPrice() == o2.getPrice()) {
                    return 0;
                }
                return -1 * (o1.getPrice() < o2.getPrice() ? -1 : 1);
            }
            if (SymbolPositionView.this.sortColumn == 4) {
                if (SymbolPositionView.this.sortDirection == 0) {
                    if ((double)o1.getNoOfShares() * o1.getPrice() == (double)o2.getNoOfShares() * o2.getPrice()) {
                        return 0;
                    }
                    return (double)o1.getNoOfShares() * o1.getPrice() < (double)o2.getNoOfShares() * o2.getPrice() ? -1 : 1;
                }
                if ((double)o1.getNoOfShares() * o1.getPrice() == (double)o2.getNoOfShares() * o2.getPrice()) {
                    return 0;
                }
                return -1 * ((double)o1.getNoOfShares() * o1.getPrice() < (double)o2.getNoOfShares() * o2.getPrice() ? -1 : 1);
            }
            return 0;
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = SymbolPositionView.this.table.indexOf((TableColumn)e.widget);
            if (SymbolPositionView.this.sortColumn == index) {
                SymbolPositionView.this.sortDirection = SymbolPositionView.this.sortDirection == 0 ? 1 : 0;
            } else {
                SymbolPositionView.this.sortColumn = index;
                SymbolPositionView.this.sortDirection = 0;
            }
            SymbolPositionView.this.table.setSortColumn(SymbolPositionView.this.table.getColumn(SymbolPositionView.this.sortColumn));
            SymbolPositionView.this.table.setSortDirection(SymbolPositionView.this.sortDirection == 0 ? 128 : 1024);
            SymbolPositionView.this.updateTable();
        }
    };

    public SymbolPositionView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(5, false));
        Label lblClientCode = new Label(parent, 0);
        lblClientCode.setText("Client Code");
        this.txtClientCode = new Text(parent, 2048);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        if (!Resources.isClientType() && Resources.loginStatus) {
            this.txtClientCode.setEnabled(true);
        } else {
            this.txtClientCode.setText(Resources.clientId);
            this.txtClientCode.setEnabled(false);
        }
        Label lblSymbol = new Label(parent, 0);
        lblSymbol.setText("Symbol");
        this.txtSymbol = new Text(parent, 2048);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    SymbolPositionView.this.sendRequest();
                }
            }
        });
        this.txtClientCode.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    SymbolPositionView.this.sendRequest();
                }
            }
        });
        this.btnFetch = new Button(parent, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    SymbolPositionView.this.sendRequest();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table = new Table(parent, 65540);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(5, 1).applyTo((Control)this.table);
        TableColumn tc = new TableColumn(this.table, 0x1000000);
        tc.setText(this.columnsName[0]);
        tc.setWidth(100);
        tc.setAlignment(131072);
        tc.addSelectionListener(this.columnSelectionListener);
        int i = 1;
        while (i < this.columnsName.length) {
            this.createColumns(this.columnsName[i], 131072);
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setSortColumn(this.table.getColumn(0));
        this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
    }

    private void createColumns(String columnsName, int allignment) {
        TableColumn tc = new TableColumn(this.table, 0x1000000);
        tc.setText(columnsName);
        tc.setWidth(100);
        tc.setAlignment(allignment);
        tc.addSelectionListener(this.columnSelectionListener);
    }

    private void updateItemsData() {
        int j = 0;
        while (j < this.list.size()) {
            SymbolPositionsData custodyobj = this.list.get(j);
            String[] itemData = new String[]{custodyobj.getClientCode(), custodyobj.getSymbol(), this.nf.format(custodyobj.getNoOfShares()), this.pf.format(custodyobj.getPrice()), this.pf.format((double)custodyobj.getNoOfShares() * custodyobj.getPrice())};
            this.table.getItem(j).setText(itemData);
            ++j;
        }
    }

    public void sendRequest() {
        if (!this.btnFetch.isEnabled()) {
            return;
        }
        if (Resources.getServerLink((String)"", (boolean)false, (boolean)true) != null) {
            SymbolPositionsRequest req = new SymbolPositionsRequest();
            req.setSymbol(this.txtSymbol.getText());
            req.setClient(this.txtClientCode.getText());
            req.setAsOnDate(Resources.systemDate);
            if (Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)req)) {
                this.table.removeAll();
                this.list.clear();
                this.btnFetch.setEnabled(false);
            }
        }
    }

    public void recieveResponse(final SymbolPositionsResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        SymbolPositionView.this.list.addAll(Arrays.asList(resp.getrows()));
                        SymbolPositionView.this.CreateItems();
                        SymbolPositionView.this.updateTable();
                        SymbolPositionView.this.btnFetch.setEnabled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void CreateItems() {
        int totalNoOfShares = 0;
        double totalCurrentPrice = 0.0;
        long totalValue = 0L;
        for (SymbolPositionsData custodyobj : this.list) {
            String[] itemData = new String[]{custodyobj.getClientCode(), custodyobj.getSymbol(), this.nf.format(custodyobj.getNoOfShares()), this.pf.format(custodyobj.getPrice()), this.pf.format((double)custodyobj.getNoOfShares() * custodyobj.getPrice())};
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(itemData);
            totalNoOfShares += custodyobj.getNoOfShares();
            totalCurrentPrice += custodyobj.getPrice();
            totalValue = (long)((double)totalValue + (double)custodyobj.getNoOfShares() * custodyobj.getPrice());
        }
        TableItem totalTableItem = new TableItem(this.table, 0);
        String[] totalItemData = new String[]{"Total", "", this.nf.format(totalNoOfShares), this.pf.format(totalCurrentPrice), this.pf.format(totalValue)};
        totalTableItem.setText(totalItemData);
        Font fontBold = WidgetFactory.font_registry.get("FONT_10_BOLD");
        totalTableItem.setFont(fontBold);
    }

    private void updateTable() {
        if (this.sortColumn != -1) {
            Collections.sort(this.list, this.custodySorter);
        }
        this.updateItemsData();
    }

    public void setFocus() {
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        if (!Resources.isClientType()) {
                            SymbolPositionView.this.txtClientCode.setEnabled(true);
                            SymbolPositionView.this.txtClientCode.setText("");
                        } else {
                            SymbolPositionView.this.txtClientCode.setEnabled(false);
                            SymbolPositionView.this.txtClientCode.setText(Resources.clientId);
                        }
                    } else if (o instanceof SymbolPositionsResponse) {
                        SymbolPositionsResponse rsp = (SymbolPositionsResponse)o;
                        SymbolPositionView.this.recieveResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }
}

