/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.trading.views;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ClientsCustodyData;
import pk.com.softech.messages.ClientsCustodyRequest;
import pk.com.softech.messages.ClientsCustodyResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class ClientCustodyView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.ext.views.ClientCustodyView";
    public static final String PREFS_CLIENT_CUSTODY_VIEW_COLUMNS_SIZE = "PREFS_CLIENT_CUSTODY_VIEW_COLUMNS_SIZE";
    private static final int REFRESH_DELAY = 180000;
    RefreshThread thread;
    private static final int ACCOUNT = 0;
    private static final int CUSTODY = 1;
    private static final int CASH_BALANCE = 2;
    private static final int PORTFOLIO_VALUE = 3;
    private static final String[] COLUMN_NAMES = new String[]{"Account", "Custody", "Cash Balance", "Portfolio Value"};
    private Composite parent;
    private Composite content;
    double totalCustody;
    double totalCashBal;
    double totalValue;
    private Label lblClientCode;
    private Text txtClientCode;
    private Button btnRefresh;
    private Label lblRefreshTime;
    private Label lblTotalCustody;
    private Label lblTotalCashBal;
    private Label lblTotalValue;
    private boolean sort = false;
    TableViewer viewer;
    int sortColumn = 0;
    int sortDirection = 0;
    private DataComparator comparator;
    private DataFilter filter;
    Set<ClientsCustodyData> s = new HashSet<ClientsCustodyData>();
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    private DateFormat tf = CorePlugin.getTimeFormat();
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ClientCustodyView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientCustodyView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(ClientCustodyView.PREFS_CLIENT_CUSTODY_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ClientCustodyView.this.sort = true;
            int index = ClientCustodyView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (ClientCustodyView.this.sortColumn == index) {
                ClientCustodyView.this.sortDirection = ClientCustodyView.this.sortDirection == 0 ? 1 : 0;
            } else {
                ClientCustodyView.this.sortColumn = index;
                ClientCustodyView.this.sortDirection = 0;
            }
            ClientCustodyView.this.viewer.getTable().setSortColumn(ClientCustodyView.this.viewer.getTable().getColumn(ClientCustodyView.this.sortColumn));
            ClientCustodyView.this.viewer.getTable().setSortDirection(ClientCustodyView.this.sortDirection == 0 ? 128 : 1024);
            ClientCustodyView.this.comparator.setColumn(ClientCustodyView.this.sortColumn);
            ClientCustodyView.this.viewer.refresh();
        }
    };

    public ClientCustodyView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.totalValue = 0.0;
        this.totalCashBal = 0.0;
        this.totalCustody = 0.0;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.lblClientCode = new Label(composite, 0);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        if (!Resources.isClientType() && Resources.loginStatus) {
            this.txtClientCode.setEnabled(true);
        } else {
            this.txtClientCode.setText(Resources.clientId);
            this.txtClientCode.setEnabled(false);
        }
        this.txtClientCode.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    ClientCustodyView.this.sendRequest();
                }
            }
        });
        this.txtClientCode.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ClientCustodyView.this.sort = false;
            }
        });
        this.btnRefresh = new Button(composite, 0);
        this.btnRefresh.setText("Fetch");
        this.btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    ClientCustodyView.this.sendRequest();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblRefreshTime = new Label(composite, 0);
        this.lblRefreshTime.setText("Last Refresh = 00:00:00 ");
        this.lblRefreshTime.setVisible(false);
        Label lbl = new Label(composite, 0);
        lbl.setText("Total:");
        this.lblTotalCustody = new Label(composite, 0);
        this.lblTotalCashBal = new Label(composite, 0);
        this.lblTotalValue = new Label(composite, 0);
        GridDataFactory.fillDefaults().hint(120, 15).applyTo((Control)this.lblTotalCashBal);
        GridDataFactory.fillDefaults().hint(120, 15).applyTo((Control)this.lblTotalCustody);
        GridDataFactory.fillDefaults().hint(120, 15).applyTo((Control)this.lblTotalValue);
        this.createViewer(composite);
        this.comparator = new DataComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DataLabelProvider());
        this.comparator.setColumn(this.sortColumn);
        this.filter = new DataFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new ResizeColumnsAction(this.viewer.getTable()));
    }

    private void totalOfColumns() {
        this.lblTotalCashBal.setText("");
        this.lblTotalCustody.setText("");
        this.lblTotalValue.setText("");
        this.totalCustody = 0.0;
        this.totalCashBal = 0.0;
        this.totalValue = 0.0;
        int i = 0;
        while (i < this.s.size()) {
            ClientsCustodyData arr = (ClientsCustodyData)this.s.toArray()[i];
            this.totalCustody += arr.getCustodyValue();
            this.totalCashBal += arr.getCashBalance();
            this.totalValue += arr.getCustodyValue() + arr.getCashBalance();
            ++i;
        }
        this.lblTotalCashBal.setText(this.pf.format(this.totalCashBal));
        this.lblTotalCustody.setText(this.pf.format(this.totalCustody));
        this.lblTotalValue.setText(this.pf.format(this.totalValue));
    }

    private void startRefreshThread() {
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0, 16384);
        this.createTableViewerColumn(1, 131072);
        this.createTableViewerColumn(2, 131072);
        this.createTableViewerColumn(3, 131072);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_CLIENT_CUSTODY_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(int colNumber, int alignment) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setAlignment(alignment);
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        return viewerColumn;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        if (o instanceof LoginConfirmation) {
                            try {
                                if (!Resources.isClientType()) {
                                    ClientCustodyView.this.txtClientCode.setEnabled(true);
                                    ClientCustodyView.this.txtClientCode.setText("");
                                    break block6;
                                }
                                ClientCustodyView.this.txtClientCode.setEnabled(false);
                                ClientCustodyView.this.txtClientCode.setText(Resources.clientId);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (o instanceof ClientsCustodyResponse) {
                            ClientsCustodyResponse rsp = (ClientsCustodyResponse)o;
                            ClientCustodyView.this.recieveResponse(rsp);
                            ClientCustodyView.this.btnRefresh.setEnabled(true);
                        }
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void recieveResponse(final ClientsCustodyResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientCustodyView.this.s.addAll(Arrays.asList(resp.getrows()));
                        ClientCustodyView.this.viewer.setInput(Arrays.asList(ClientCustodyView.this.s.toArray()));
                        ClientCustodyView.this.totalOfColumns();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ClientCustodyView.this.logger.error((Object)"", (Throwable)e);
                    }
                }
            });
        }
    }

    public void sendRequest() {
        if (!this.btnRefresh.isEnabled()) {
            return;
        }
        if (Resources.getServerLink((String)"", (boolean)false, (boolean)true) != null) {
            ClientsCustodyRequest req = new ClientsCustodyRequest();
            req.setAsOnDate(Resources.systemDate);
            req.setClient(this.txtClientCode.getText());
            if (Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)req)) {
                this.viewer.getTable().removeAll();
                this.s.clear();
                this.lblRefreshTime.setText("Last Refresh = " + this.tf.format(new Date()));
                this.btnRefresh.setEnabled(false);
            }
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
        catch (Exception exception) {}
        super.dispose();
    }

    class DataComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int direction = 0;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ClientsCustodyData p1 = (ClientsCustodyData)e1;
            ClientsCustodyData p2 = (ClientsCustodyData)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getClient().compareTo(p2.getClient());
                    break;
                }
                case 1: {
                    rc = Double.valueOf(p1.getCustodyValue()).compareTo(p2.getCustodyValue());
                    break;
                }
                case 2: {
                    rc = Double.valueOf(p1.getCashBalance()).compareTo(p2.getCashBalance());
                    break;
                }
                case 3: {
                    rc = Double.valueOf(p1.getCashBalance() + p1.getCustodyValue()).compareTo(p2.getCashBalance() + p2.getCustodyValue());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class DataFilter
    extends ViewerFilter {
        private String client = "";

        DataFilter() {
        }

        public void setSearchText(String s1) {
            this.client = ".*" + s1 + ".*";
            ClientCustodyView.this.totalCustody = 0.0;
            ClientCustodyView.this.totalCashBal = 0.0;
            ClientCustodyView.this.totalValue = 0.0;
            ClientCustodyView.this.lblTotalCashBal.setText("" + ClientCustodyView.this.totalCashBal);
            ClientCustodyView.this.lblTotalCustody.setText("" + ClientCustodyView.this.totalCustody);
            ClientCustodyView.this.lblTotalValue.setText("" + ClientCustodyView.this.totalValue);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.client == null || this.client.length() == 0) {
                return true;
            }
            ClientsCustodyData p = (ClientsCustodyData)element;
            try {
                if (p.getClient().matches(this.client)) {
                    if (!ClientCustodyView.this.sort) {
                        ClientCustodyView.this.totalCustody += p.getCustodyValue();
                        ClientCustodyView.this.totalCashBal += p.getCashBalance();
                        ClientCustodyView.this.totalValue += p.getCustodyValue() + p.getCashBalance();
                        ClientCustodyView.this.lblTotalCashBal.setText(ClientCustodyView.this.pf.format(ClientCustodyView.this.totalCashBal));
                        ClientCustodyView.this.lblTotalCustody.setText(ClientCustodyView.this.pf.format(ClientCustodyView.this.totalCustody));
                        ClientCustodyView.this.lblTotalValue.setText(ClientCustodyView.this.pf.format(ClientCustodyView.this.totalValue));
                    }
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }
    }

    class DataLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DataLabelProvider() {
        }

        public String getColumnText(Object element, int colNumber) {
            ClientsCustodyData data = (ClientsCustodyData)element;
            switch (colNumber) {
                case 0: {
                    return data.getClient();
                }
                case 1: {
                    return ClientCustodyView.this.pf.format((float)data.getCustodyValue());
                }
                case 2: {
                    return ClientCustodyView.this.pf.format((float)data.getCashBalance());
                }
                case 3: {
                    return ClientCustodyView.this.pf.format((float)(data.getCustodyValue() + data.getCashBalance()));
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private class RefreshThread
    extends Thread {
        private RefreshThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (ClientCustodyView.this.parent != null && !ClientCustodyView.this.parent.isDisposed()) {
                    ClientCustodyView.this.parent.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ClientCustodyView.this.sendRequest();
                        }
                    });
                }
                try {
                    Thread.sleep(180000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

