/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.ext.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.MarketData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class SymbolSettingDialog
extends TitleAreaDialog {
    private Composite parent;
    private Label lblExchange;
    private Label lblSymbol;
    private Combo cmbExchange;
    private Combo cmbMarket;
    public static final int EXCHANGE = 0;
    public static final int MARKET = 1;
    public static final int SYMBOL = 2;
    private static String[] COLUMN_NAMES = new String[]{"Exchange", "Market", "Symbol"};
    Text txtSymbol;
    Button btnAdd;
    Button btnDelete;
    Button btnDeleteAll;
    private Button up;
    private Button down;
    private Image upImage = CorePlugin.getImageDescriptor((String)"icons/buttons16/up.gif").createImage();
    private Image downImage = CorePlugin.getImageDescriptor((String)"icons/buttons16/down.gif").createImage();
    Table table;
    private TableViewer viewer;
    private ArrayList<Security> symbolList = new ArrayList();
    private String str_pref;
    int sortColumn = 0;
    int sortDirection = 1;
    public static final String PREFS_SORT_COLUMN = "_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "_SORT_DIRECTION";
    public static final String PREFS_SYMBOL_SETTINGS_COLUMNS_SIZE = "PREFS_SYMBOL_SETTINGS_COLUMNS_SIZE";
    private String viewType;
    IPreferenceStore pref;
    private FontMetrics fontMetrics;
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < SymbolSettingDialog.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(SymbolSettingDialog.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(SymbolSettingDialog.PREFS_SYMBOL_SETTINGS_COLUMNS_SIZE, sizes.toString());
        }
    };
    Comparator<Security> symbolSorter = new Comparator<Security>(){

        @Override
        public int compare(Security o1, Security o2) {
            if (SymbolSettingDialog.this.sortColumn == 2) {
                if (SymbolSettingDialog.this.sortDirection == 0) {
                    return o1.getSymbol().compareTo(o2.getSymbol());
                }
                return o2.getSymbol().compareTo(o1.getSymbol());
            }
            if (SymbolSettingDialog.this.sortColumn == 1) {
                if (SymbolSettingDialog.this.sortDirection == 0) {
                    return o1.getMarket().compareTo(o2.getMarket());
                }
                return o2.getMarket().compareTo(o1.getMarket());
            }
            if (SymbolSettingDialog.this.sortColumn == 0) {
                if (SymbolSettingDialog.this.sortDirection == 0) {
                    return o1.getExchange().compareTo(o2.getExchange());
                }
                return o2.getExchange().compareTo(o1.getExchange());
            }
            return 0;
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = SymbolSettingDialog.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (SymbolSettingDialog.this.sortColumn == index) {
                SymbolSettingDialog.this.sortDirection = SymbolSettingDialog.this.sortDirection == 0 ? 1 : 0;
            } else {
                SymbolSettingDialog.this.sortColumn = index;
                SymbolSettingDialog.this.sortDirection = 0;
            }
            SymbolSettingDialog.this.pref.setValue(String.valueOf(SymbolSettingDialog.this.viewType) + SymbolSettingDialog.PREFS_SORT_COLUMN, SymbolSettingDialog.this.sortColumn);
            SymbolSettingDialog.this.pref.setValue(String.valueOf(SymbolSettingDialog.this.viewType) + SymbolSettingDialog.PREFS_SORT_DIRECTION, SymbolSettingDialog.this.sortDirection);
            SymbolSettingDialog.this.viewer.getTable().setSortColumn(SymbolSettingDialog.this.viewer.getTable().getColumn(SymbolSettingDialog.this.sortColumn));
            SymbolSettingDialog.this.viewer.getTable().setSortDirection(SymbolSettingDialog.this.sortDirection == 0 ? 128 : 1024);
            SymbolSettingDialog.this.updateTable();
        }
    };

    public SymbolSettingDialog(List<Security> symbolList, IPreferenceStore store, String viewType) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.symbolList = new ArrayList<Security>(symbolList);
        this.pref = store;
        this.viewType = this.viewType;
    }

    public void create() {
        super.create();
        this.setTitle("Enter symbols to subscribe.");
    }

    public int open() {
        this.create();
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Symbol Setting Dialog");
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(16384, 128, true, true));
        content.setLayout((Layout)new GridLayout(3, false));
        Composite contentLeft = new Composite(content, 0);
        contentLeft.setLayoutData((Object)new GridData(16384, 4, true, true));
        contentLeft.setLayout((Layout)new GridLayout(1, false));
        Composite contentMiddle = new Composite(content, 0);
        contentMiddle.setLayoutData((Object)new GridData(16384, 4, true, true));
        contentMiddle.setLayout((Layout)new GridLayout(1, false));
        Composite contentRight = new Composite(content, 0);
        contentRight.setLayout((Layout)new GridLayout(1, false));
        contentMiddle.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.lblExchange = new Label(contentLeft, 0);
        this.lblExchange.setText(" Exchange");
        this.cmbExchange = new Combo(contentLeft, 8);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            int i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.cmbExchange.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        Label lbl_markete = new Label(contentLeft, 0);
        lbl_markete.setText(" Market");
        this.cmbMarket = new Combo(contentLeft, 8);
        if (Resources.marketTypes != null) {
            this.cmbMarket.removeAll();
            int i = 0;
            while (i < Resources.marketTypes.size()) {
                this.cmbMarket.add((String)Resources.marketTypes.get(i));
                ++i;
            }
            try {
                this.cmbMarket.setText(MarketData.marketNames[MarketData.REGULAR]);
            }
            catch (Exception exception) {
                this.cmbMarket.select(0);
            }
        }
        this.cmbMarket.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.lblSymbol = new Label(contentLeft, 0);
        this.lblSymbol.setText(" Symbol");
        this.txtSymbol = new Text(contentLeft, 2048);
        this.txtSymbol.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SymbolSettingDialog.this.txtSymbol.setSelection(0, SymbolSettingDialog.this.txtSymbol.getText().length());
                    String exchange = SymbolSettingDialog.this.cmbExchange.getText();
                    String market = SymbolSettingDialog.this.cmbMarket.getText();
                    String symbol = SymbolSettingDialog.this.txtSymbol.getText();
                    Security security = CorePlugin.getRepository().getSecurity(exchange, market, symbol);
                    if (security != null) {
                        if (!SymbolSettingDialog.this.symbolList.contains(security)) {
                            SymbolSettingDialog.this.symbolList.add(security);
                            SymbolSettingDialog.this.add_table_item(security);
                        } else {
                            MessageDialog.openInformation(null, (String)"", (String)"Already exists");
                        }
                    } else {
                        MessageDialog.openInformation(null, (String)"", (String)"Invalid symbol");
                    }
                }
            }
        });
        Composite contentLeftBtns = new Composite(contentLeft, 0);
        contentLeftBtns.setLayout((Layout)new GridLayout(2, false));
        contentLeftBtns.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.btnAdd = new Button(contentLeftBtns, 8);
        this.btnAdd.setText("Add");
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String symbol = SymbolSettingDialog.this.txtSymbol.getText();
                String combo_markete = SymbolSettingDialog.this.cmbMarket.getItem(SymbolSettingDialog.this.cmbMarket.getSelectionIndex());
                String combo_exchange = SymbolSettingDialog.this.cmbExchange.getItem(SymbolSettingDialog.this.cmbExchange.getSelectionIndex());
                Security security = CorePlugin.getRepository().getSecurity(combo_exchange, combo_markete, symbol);
                if (security != null) {
                    if (!SymbolSettingDialog.this.symbolList.contains(security)) {
                        SymbolSettingDialog.this.symbolList.add(security);
                        SymbolSettingDialog.this.add_table_item(security);
                    } else {
                        MessageDialog.openInformation(null, (String)"", (String)"Already exists");
                    }
                } else {
                    MessageDialog.openInformation(null, (String)"", (String)"Invalid symbol");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnDelete = new Button(contentLeftBtns, 8);
        this.btnDelete.setText("Delete");
        this.btnDelete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] idxs = SymbolSettingDialog.this.table.getSelectionIndices();
                SymbolSettingDialog.this.table.remove(idxs);
                int i = 0;
                while (i < idxs.length) {
                    SymbolSettingDialog.this.symbolList.remove(idxs[i] - i);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnDeleteAll = new Button(contentLeft, 8);
        this.btnDeleteAll.setText("Delete All");
        this.btnDeleteAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SymbolSettingDialog.this.table.removeAll();
                SymbolSettingDialog.this.symbolList.clear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer(contentMiddle);
        this.viewer.setInput(this.symbolList);
        this.sortColumn = this.pref.getInt(String.valueOf(this.viewType) + PREFS_SORT_COLUMN);
        this.sortDirection = this.pref.getInt(String.valueOf(this.viewType) + PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.up = new Button(contentRight, 8);
        this.up.setImage(this.upImage);
        GridData btnLayoutUp = new GridData();
        btnLayoutUp.verticalAlignment = 1024;
        this.up.setLayoutData((Object)btnLayoutUp);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SymbolSettingDialog.this.viewer.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)SymbolSettingDialog.this.viewer.getSelection()).toArray();
                    SymbolSettingDialog.this.moveSelectionUp(s);
                    SymbolSettingDialog.this.updateControlsEnablement();
                    SymbolSettingDialog.this.sortColumn = -1;
                }
            }
        });
        this.down = new Button(contentRight, 8);
        this.down.setImage(this.downImage);
        GridData btnLayoutDown = new GridData();
        btnLayoutDown.verticalAlignment = 128;
        this.down.setLayoutData((Object)btnLayoutDown);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SymbolSettingDialog.this.viewer.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)SymbolSettingDialog.this.viewer.getSelection()).toArray();
                    SymbolSettingDialog.this.moveSelectionDown(s);
                    SymbolSettingDialog.this.updateControlsEnablement();
                    SymbolSettingDialog.this.sortColumn = -1;
                }
            }
        });
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createButton(parent, 0, "OK", false);
        this.createButton(parent, 1, "Cancel", false);
    }

    private void add_table_item(Security data) {
        this.viewer.add((Object)data);
    }

    private void updateTable() {
        if (this.sortColumn != -1) {
            Collections.sort(this.symbolList, this.symbolSorter);
        }
        this.viewer.setInput(this.symbolList);
        this.viewer.refresh();
    }

    protected void moveSelectionUp(Object[] s) {
        ArrayList<Security> l = new ArrayList<Security>();
        int index = 999999;
        int i = 0;
        while (i < s.length) {
            index = Math.min(index, this.symbolList.indexOf(s[i]));
            l.add((Security)s[i]);
            ++i;
        }
        if (index > 0) {
            this.symbolList.removeAll(l);
            this.symbolList.addAll(--index, l);
            this.viewer.refresh();
        }
    }

    protected void updateControlsEnablement() {
        int upperIndex = -1;
        int lowerIndex = 999999;
        Object[] s = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        int i = 0;
        while (i < s.length) {
            upperIndex = Math.max(upperIndex, this.symbolList.indexOf(s[i]));
            lowerIndex = Math.min(lowerIndex, this.symbolList.indexOf(s[i]));
            ++i;
        }
        this.up.setEnabled(!this.viewer.getSelection().isEmpty() && upperIndex > 0);
        this.down.setEnabled(!this.viewer.getSelection().isEmpty() && lowerIndex < this.symbolList.size() - 1);
    }

    protected void moveSelectionDown(Object[] s) {
        ArrayList<Security> l = new ArrayList<Security>();
        int index = -1;
        int i = 0;
        while (i < s.length) {
            index = Math.max(index, this.symbolList.indexOf(s[i]));
            l.add((Security)s[i]);
            ++i;
        }
        if (index < this.symbolList.size() - 1) {
            ++index;
            this.symbolList.removeAll(l);
            this.symbolList.addAll(index -= l.size() - 1, l);
            this.viewer.refresh();
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(false);
        column.setMoveable(false);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(((Security)cell.getElement()).getExchange());
                        break;
                    }
                    case 1: {
                        cell.setText(((Security)cell.getElement()).getMarket());
                        break;
                    }
                    case 2: {
                        cell.setText(((Security)cell.getElement()).getSymbol());
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                Security sec = (Security)element;
                return sec.getDescription();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0);
        this.createTableViewerColumn(1);
        this.createTableViewerColumn(2);
        int colWidth = this.convertHorizontalDLUsToPixels(150);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_SYMBOL_SETTINGS_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(colWidth);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 67586);
        this.createColumns(parent, this.viewer);
        this.table = this.viewer.getTable();
        this.table.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SymbolSettingDialog.this.updateControlsEnablement();
            }
        });
    }

    public void addTable(Composite container) {
        this.table = new Table(container, 268503042);
        GridData griddata = new GridData(1808);
        griddata.horizontalSpan = 2;
        griddata.verticalSpan = 10;
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)griddata);
        this.table.setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this.table, 16384);
        TableColumn tc2 = new TableColumn(this.table, 0x1000000);
        TableColumn tc3 = new TableColumn(this.table, 0x1000000);
        tc1.setText("Exchange");
        tc2.setText("Markete");
        tc3.setText("Symbol");
        int width = this.convertHorizontalDLUsToPixels(100);
        tc1.setWidth(width);
        tc2.setWidth(width);
        tc3.setWidth(width);
    }

    protected boolean isResizable() {
        return false;
    }

    protected void okPressed() {
        if (this.sortColumn != -1) {
            Collections.sort(this.symbolList, this.symbolSorter);
        }
        this.saveInput();
        super.okPressed();
    }

    public ArrayList<Security> getSymbolList() {
        return this.symbolList;
    }

    private void saveInput() {
        this.str_pref = "";
        int i = 0;
        while (i < this.symbolList.size()) {
            this.str_pref = String.valueOf(this.str_pref) + this.symbolList.get(i).getId() + ",";
            ++i;
        }
    }

    public String getPreference() {
        return this.str_pref;
    }
}

