/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeSet;
import javax.sql.ConnectionPoolDataSource;
import javaxt.sql.Connection;
import javaxt.sql.Driver;
import javaxt.sql.Table;
import javaxt.utils.URL;

public class Database {
    private String name;
    private String host;
    private Integer port = -1;
    private String username;
    private String password;
    private Driver driver;
    private String props;
    private String querystring;
    private static final Class<?>[] stringType = new Class[]{String.class};
    private static final Class<?>[] integerType = new Class[]{Integer.TYPE};

    public Database() {
    }

    public Database(String name, String host, int port, String username, String password, Driver driver) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.driver = driver;
    }

    public Database(java.sql.Connection conn) {
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.name = conn.getCatalog();
            this.username = dbmd.getUserName();
            this.parseURL(dbmd.getURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Database(String connStr) {
        this.parseURL(connStr);
    }

    private void parseURL(String connStr) {
        String[] arrConnStr = connStr.split(";");
        String jdbcURL = arrConnStr[0];
        if (!jdbcURL.contains("//")) {
            String protocol = jdbcURL.substring(jdbcURL.indexOf(":") + 1);
            protocol = "jdbc:" + protocol.substring(0, protocol.indexOf(":")) + ":";
            String path = jdbcURL.substring(protocol.length());
            jdbcURL = protocol + "//" + path;
        }
        URL url = new URL(jdbcURL);
        this.host = url.getHost();
        this.port = url.getPort();
        this.driver = Driver.findDriver(url.getProtocol());
        if (this.name == null) {
            this.name = url.getPath();
            if (this.name != null && this.name.startsWith("/")) {
                this.name = this.name.substring(1);
            }
        }
        this.querystring = url.getQueryString();
        if (this.querystring.length() == 0) {
            this.querystring = null;
        }
        StringBuffer props = null;
        for (int i = 1; i < arrConnStr.length; ++i) {
            String[] arrParams = arrConnStr[i].split("=");
            String paramName = arrParams[0].toLowerCase();
            String paramValue = arrParams[1];
            if (paramName.equals("database")) {
                this.name = paramValue;
                continue;
            }
            if (paramName.equals("user")) {
                this.username = paramValue;
                continue;
            }
            if (paramName.equals("password")) {
                this.password = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase("derby.system.home")) {
                System.setProperty("derby.system.home", paramValue);
                continue;
            }
            if (props == null) {
                props = new StringBuffer();
            }
            props.append(arrParams[0] + "=" + arrParams[1] + ";");
        }
        if (props != null) {
            this.props = props.toString();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHost(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setHost(String host) {
        if ((host = host.trim()).contains(":")) {
            try {
                this.host = host.substring(0, host.indexOf(":"));
                this.port = Integer.valueOf(host.substring(host.indexOf(":") + 1));
            }
            catch (Exception e) {
                this.host = host;
            }
        } else {
            this.host = host;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public void setDriver(String driver) {
        this.driver = Driver.findDriver(driver);
    }

    public void setDriver(java.sql.Driver driver) {
        this.driver = new Driver(driver);
    }

    public void setDriver(Class driver) {
        this.driver = Driver.findDriver(driver.getCanonicalName());
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionString() {
        String path = this.getURL();
        if (this.username != null) {
            path = path + ";user=" + this.username;
        }
        if (this.password != null) {
            path = path + ";password=" + this.password;
        }
        return path;
    }

    protected String getURL() {
        String server = this.host;
        if (this.port != null && this.port > 0) {
            server = server + ":" + this.port;
        }
        if (this.driver.getVendor().equals("Derby") || this.driver.getVendor().equals("SQLite")) {
            server = ":" + server;
        }
        String database = "";
        if (this.name != null && this.name.trim().length() > 0) {
            database = this.driver.getVendor().equals("SQLServer") ? ";databaseName=" + this.name : (this.driver.getVendor().equals("Derby") ? ";databaseName=" + this.name : "/" + this.name);
        }
        if (this.querystring != null) {
            database = database + "?" + this.querystring;
        }
        String path = "";
        path = this.driver.getProtocol() + "://";
        if (this.driver.getVendor().equals("Sybase")) {
            if (!path.toLowerCase().contains("tds:")) {
                path = this.driver.getProtocol() + "Tds:";
            }
        } else if (this.driver.getVendor().equals("Derby") || this.driver.getVendor().equals("SQLite")) {
            path = this.driver.getProtocol();
        }
        String properties = "";
        if (this.props != null) {
            properties = ";" + this.props;
        }
        return path + server + database + properties;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = new Connection();
        connection.open(this);
        return connection;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() throws SQLException {
        if (this.driver == null) {
            throw new SQLException("Failed to create a ConnectionPoolDataSource. Please specify a driver.");
        }
        String className = null;
        HashMap<String, Object> methods = new HashMap<String, Object>();
        if (this.driver.equals("sqlite")) {
            className = "org.sqlite.SQLiteConnectionPoolDataSource";
            methods.put("setUrl", "jdbc:sqlite:" + this.host);
        } else if (this.driver.equals("derby")) {
            className = "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource";
            methods.put("setDatabaseName", this.host);
            methods.put("setCreateDatabase", "create");
        } else if (this.driver.equals("h2")) {
            className = "org.h2.jdbcx.JdbcDataSource";
            methods.put("setURL", "jdbc:h2:file:" + this.host);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("sqlserver")) {
            className = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("postgresql")) {
            className = "org.postgresql.ds.PGConnectionPoolDataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setPortNumber", this.port);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("mysql")) {
            className = "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setPortNumber", this.port);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("oracle")) {
            String connDriver = "thin";
            String connService = "";
            className = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
            methods.put("setDriverType", connDriver);
            methods.put("setServerName", this.host);
            methods.put("setPortNumber", this.port);
            methods.put("setServiceName", connService);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("jtds")) {
            className = "net.sourceforge.jtds.jdbcx.JtdsDataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        }
        if (className != null) {
            try {
                Class<?> classToLoad = Class.forName(className);
                Object instance = classToLoad.newInstance();
                for (String methodName : methods.keySet()) {
                    Object parameter = methods.get(methodName);
                    if (parameter == null) continue;
                    Method method = null;
                    if (parameter instanceof String) {
                        method = classToLoad.getMethod(methodName, stringType);
                    } else if (parameter instanceof Integer) {
                        method = classToLoad.getMethod(methodName, integerType);
                    }
                    if (method == null) continue;
                    method.invoke(instance, parameter);
                }
                return (ConnectionPoolDataSource)instance;
            }
            catch (Exception e) {
                throw new SQLException("Failed to instantiate the ConnectionPoolDataSource.", e);
            }
        }
        throw new SQLException("Failed to find a suitable ConnectionPoolDataSource.");
    }

    public static Table[] getTables(Connection conn) {
        try {
            TreeSet<Table> tables = new TreeSet<Table>();
            DatabaseMetaData dbmd = conn.getConnection().getMetaData();
            ResultSet rs = dbmd.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                tables.add(new Table(rs, dbmd));
            }
            rs.close();
            return tables.toArray(new Table[tables.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getCatalogs(Connection conn) {
        try {
            TreeSet<String> catalogs = new TreeSet<String>();
            DatabaseMetaData dbmd = conn.getConnection().getMetaData();
            ResultSet rs = dbmd.getCatalogs();
            while (rs.next()) {
                catalogs.add(rs.getString(1));
            }
            rs.close();
            return catalogs.toArray(new String[catalogs.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void displayDbProperties(Connection conn) {
        DatabaseMetaData dm = null;
        ResultSet rs = null;
        try {
            if (conn != null) {
                dm = conn.getConnection().getMetaData();
                System.out.println("Driver Information");
                System.out.println("\tDriver Name: " + dm.getDriverName());
                System.out.println("\tDriver Version: " + dm.getDriverVersion());
                System.out.println("\nDatabase Information ");
                System.out.println("\tDatabase Name: " + dm.getDatabaseProductName());
                System.out.println("\tDatabase Version: " + dm.getDatabaseProductVersion());
                System.out.println("Avalilable Catalogs ");
                rs = dm.getCatalogs();
                while (rs.next()) {
                    System.out.println("\tcatalog: " + rs.getString(1));
                }
                rs.close();
                rs = null;
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dm = null;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Name: " + this.name + "\r\n");
        str.append("Host: " + this.host + "\r\n");
        str.append("Port: " + this.port + "\r\n");
        str.append("UserName: " + this.username + "\r\n");
        str.append("Driver: " + this.driver + "\r\n");
        str.append("URL: " + this.getURL() + "\r\n");
        str.append("ConnStr: " + this.getConnectionString());
        return str.toString();
    }
}

