/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FileFilter {
    private java.io.FileFilter fileFilter = null;
    private List<Pattern> regex = null;

    public FileFilter(Object filter) {
        if (filter == null) {
            filter = "*";
        }
        if (filter instanceof java.io.FileFilter) {
            this.fileFilter = (java.io.FileFilter)filter;
        }
        if (filter instanceof String) {
            filter = new String[]{(String)filter};
        }
        if (filter instanceof String[]) {
            this.regex = new ArrayList<Pattern>();
            String[] filters = filter;
            for (int i = 0; i < filters.length; ++i) {
                this.regex.add(Pattern.compile(this.getRegEx(filters[i]), 2));
            }
        }
    }

    public boolean accept(String file) {
        if (this.fileFilter != null) {
            return this.accept(new File(file));
        }
        if ((file = file.replace("\\", "/")).endsWith("/")) {
            return true;
        }
        file = file.substring(file.lastIndexOf("/") + 1);
        for (int i = 0; i < this.regex.size(); ++i) {
            Matcher matcher = this.regex.get(i).matcher(file);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.fileFilter != null) {
            return this.fileFilter.accept(file);
        }
        return this.accept(file.toString());
    }

    public boolean usesIOFilter() {
        return this.fileFilter != null;
    }

    private String getRegEx(String wildcardSearch) {
        String regex = wildcardSearch.trim();
        if (!regex.endsWith("*")) {
            regex = regex + "$";
        }
        if (regex.endsWith("*")) {
            regex = (regex = regex.substring(0, regex.length() - 1) + ")").contains("*") ? regex.substring(0, regex.lastIndexOf("*") + 1) + "(" + regex.substring(regex.lastIndexOf("*") + 1) : "(" + regex;
        }
        regex = regex.replace(".", "\\.");
        regex = regex.replace("*", ".*");
        return regex;
    }
}

