/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpClientFeedFetcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.INewsProvider;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.NewsItem;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.kseServer.KSEServerPlugin;
import pk.com.softech.tradingterminal.kseServer.Messages;

public class NewsProvider
implements Runnable,
INewsProvider {
    private Thread thread;
    private boolean stopping = false;
    private FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
    private HttpClientFeedFetcher fetcher = new HttpClientFeedFetcher(this.feedInfoCache);
    private static List oldItems = new ArrayList();
    private Log log = LogFactory.getLog(this.getClass());

    public void start() {
        if (this.thread == null) {
            this.stopping = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        this.stopping = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.log.error((Object)e);
            }
            this.thread = null;
        }
    }

    public void snapshot() {
        this.update();
    }

    public void snapshot(Security security) {
        try {
            this.update(new URL("http://finance.yahoo.com/rss/headline?s=" + security.getSymbol().toLowerCase()), security);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
    }

    @Override
    public void run() {
        System.currentTimeMillis();
        while (!this.stopping) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)e);
                break;
            }
        }
        this.thread = null;
    }

    private void update() {
        Object[] o = oldItems.toArray();
        int i = 0;
        while (i < o.length) {
            ((NewsItem)o[i]).setRecent(false);
            CorePlugin.getRepository().save((PersistentObject)((NewsItem)o[i]));
            ++i;
        }
        oldItems.clear();
        Job job = new Job(Messages.NewsProvider_Name){

            protected IStatus run(IProgressMonitor monitor) {
                IPreferenceStore store = KSEServerPlugin.getDefault().getPreferenceStore();
                ArrayList<String> urls = new ArrayList<String>();
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(FileLocator.openStream((Bundle)KSEServerPlugin.getDefault().getBundle(), (IPath)new Path("categories.xml"), (boolean)false));
                    NodeList childNodes = document.getFirstChild().getChildNodes();
                    int i = 0;
                    while (i < childNodes.getLength()) {
                        Node node = childNodes.item(i);
                        String nodeName = node.getNodeName();
                        if (nodeName.equalsIgnoreCase("category")) {
                            String id = node.getAttributes().getNamedItem("id").getNodeValue();
                            NodeList list = node.getChildNodes();
                            int x = 0;
                            while (x < list.getLength()) {
                                Node item = list.item(x);
                                nodeName = item.getNodeName();
                                Node value = item.getFirstChild();
                                if (value != null && nodeName.equalsIgnoreCase("url") && store.getBoolean(id)) {
                                    urls.add(value.getNodeValue());
                                }
                                ++x;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    NewsProvider.this.log.error((Object)e, (Throwable)e);
                }
                ObservableList securities = CorePlugin.getRepository().allSecurities();
                monitor.beginTask(Messages.NewsProvider_TaskName, securities.size() + urls.size());
                NewsProvider.this.log.info((Object)"Start fetching Yahoo! News");
                for (Security security : securities) {
                    try {
                        String url = "http://finance.yahoo.com/rss/headline?s=" + security.getSymbol().toLowerCase();
                        monitor.subTask(url);
                        NewsProvider.this.update(new URL(url), security);
                    }
                    catch (Exception e) {
                        NewsProvider.this.log.error((Object)e, (Throwable)e);
                    }
                    monitor.worked(1);
                }
                for (String url : urls) {
                    try {
                        monitor.subTask(url);
                        NewsProvider.this.update(new URL(url));
                    }
                    catch (Exception e) {
                        NewsProvider.this.log.error((Object)e, (Throwable)e);
                    }
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private void update(URL feedUrl) {
        this.update(feedUrl, null);
    }

    private void update(URL feedUrl, Security security) {
        Calendar limit = Calendar.getInstance();
        limit.add(5, -CorePlugin.getDefault().getPreferenceStore().getInt("PREFS_NEWS_DATE_RANGE"));
        boolean subscribersOnly = KSEServerPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_SUBSCRIBERS_ONLY");
        this.log.debug((Object)feedUrl);
        try {
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            IPreferenceStore store = CorePlugin.getDefault().getPreferenceStore();
            if (store.getBoolean("ENABLE_HTTP_PROXY")) {
                client.getHostConfiguration().setProxy(store.getString("PROXY_HOST_ADDRESS"), store.getInt("PROXY_PORT_ADDRESS"));
                if (store.getBoolean("ENABLE_PROXY_AUTHENTICATION")) {
                    client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(store.getString("PROXY_USER"), store.getString("PROXY_PASSWORD")));
                }
            }
            SyndFeed feed = this.fetcher.retrieveFeed(feedUrl, client);
            for (SyndEntry entry : feed.getEntries()) {
                int s;
                if (!subscribersOnly && entry.getTitle().indexOf("[$$]") != -1) continue;
                NewsItem news = new NewsItem();
                news.setRecent(true);
                String title = entry.getTitle();
                if (title.endsWith(")") && (s = title.lastIndexOf(40)) != -1) {
                    news.setSource(title.substring(s + 1, title.length() - 1));
                    title = title.substring(0, s - 1).trim();
                }
                news.setTitle(title);
                news.setUrl(entry.getLink());
                Date entryDate = entry.getPublishedDate();
                if (entry.getUpdatedDate() != null) {
                    entryDate = entry.getUpdatedDate();
                }
                if (entryDate != null) {
                    Calendar date = Calendar.getInstance();
                    date.setTime(entryDate);
                    date.set(13, 0);
                    date.set(14, 0);
                    news.setDate(date.getTime());
                }
                if (security != null) {
                    news.addSecurity(security);
                }
                if (news.getDate().before(limit.getTime()) || this.isDuplicated(news)) continue;
                this.log.trace((Object)(String.valueOf(news.getTitle()) + " (" + news.getSource() + ")"));
                CorePlugin.getRepository().save((PersistentObject)news);
                oldItems.add(news);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
    }

    boolean isDuplicated(NewsItem news) {
        if (news != null) {
            NewsItem[] items = (NewsItem[])CorePlugin.getRepository().allNews().toArray((Object[])new NewsItem[0]);
            int i = 0;
            while (i < items.length) {
                try {
                    if (news.getTitle().equals(items[i].getTitle()) && news.getUrl().equals(items[i].getUrl())) {
                        items[i].addSecurities(news.getSecurities());
                        CorePlugin.getRepository().save((PersistentObject)items[i]);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.log.info((Object)("Exception KseServer News Provider " + e.getMessage()));
                }
                ++i;
            }
        }
        return false;
    }
}

