/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.TransferCashResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;

public class LoginView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.kseServer";
    private Text txtClientCode;
    private Text txtCashAmnt;
    private Label lblClientCode;
    private Label lblCashAmnt;
    private Button btnSubmit;
    private Button btnCancel;
    Composite parent;
    Log logger = LogFactory.getLog(this.getClass());
    final PriceVerifyListener numberVerifyListener = new PriceVerifyListener(){

        public void verifyText(VerifyEvent e) {
            super.verifyText(e);
            LoginView.this.buttonEnablement();
        }
    };

    public LoginView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData txtGridData = new GridData(100, 15);
        GridData lblGridData = new GridData(100, 20);
        GridData btnGridData = new GridData(4, 4, true, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.lblClientCode = new Label(composite, 0x1000000);
        this.lblClientCode.setLayoutData((Object)lblGridData);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setLayoutData((Object)txtGridData);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginView.this.buttonEnablement();
            }
        });
        this.btnSubmit = new Button(composite, 8);
        this.btnSubmit.setLayoutData((Object)btnGridData);
        this.btnSubmit.setText("Submit");
        this.btnSubmit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.btnCancel = new Button(composite, 8);
        this.btnCancel.setLayoutData((Object)btnGridData);
        this.btnCancel.setText("Clear");
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Resources.isClientType() || !Resources.isClientTypeAbbasiSupport()) {
                    LoginView.this.txtClientCode.setText("");
                }
                LoginView.this.txtCashAmnt.setText("");
                LoginView.this.buttonEnablement();
            }
        });
        this.buttonEnablement();
    }

    public void itemRemoved(Object o) {
    }

    private void selectDefaultExchange() {
        try {
            String string = Resources.exchangeNames.get(Resources.exchangeCodes.indexOf(Resources.defaultStExCode.toString())).toString();
        }
        catch (Exception exception) {}
    }

    protected void receiveResponse(final TransferCashResponse response) {
        this.logger.info((Object)"cash transffer response recieved ");
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        int action = response.getAction();
                        if (action == 1) {
                            MessageDialog.openInformation((Shell)LoginView.this.getViewSite().getShell(), (String)"Cash Withdrawal", (String)response.getRemarks());
                        } else if (action == 2) {
                            MessageDialog.openError((Shell)LoginView.this.getViewSite().getShell(), (String)"Cash Withdrawal", (String)response.getRemarks());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void buttonEnablement() {
        boolean enable = true;
        if (this.txtClientCode.getText().trim().equals("")) {
            enable = false;
        }
        this.btnSubmit.setEnabled(enable && this.numberVerifyListener.isValid());
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    LoginView.this.txtClientCode.setText(Resources.clientId);
                }
            });
        }
    }

    public void itemAdded(Object o) {
    }
}

