/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.LoginMessage;
import pk.com.softech.messages.Message;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.link.TCPLink;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.kseServer.ClientRegistrationDialog;
import pk.com.softech.tradingterminal.kseServer.ForgetPasswordDialog;
import pk.com.softech.tradingterminal.kseServer.KSEServerPlugin;
import pk.com.softech.tradingterminal.kseServer.Messages;
import pk.com.softech.util.Utility;
import pk.com.softech.util.WebServiceUtil;

public class LoginDialog
extends TitleAreaDialog {
    private boolean rememberMe = false;
    private String userNameStr = "";
    private String passwordStr = "";
    private int serverIdx = 0;
    private Text txtUserId;
    private Text txtPassword;
    private Combo combo1;
    private Button btnRememberMe;
    private Button btnRegister;
    private String[] serverNames = null;
    private String[] serverHosts = null;
    private String[] serverPorts = null;
    private String[] _connStrings = null;
    Log logger = LogFactory.getLog((String)LoginDialog.class.getName());
    private static int invalidTries = 0;
    private Image image;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (LoginDialog.this.image != null) {
                LoginDialog.this.image.dispose();
            }
        }
    };

    public LoginDialog(String userName, String password, String[] connStrings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.userNameStr = userName;
        this.passwordStr = password;
        try {
            this.image = KSEServerPlugin.getImageDescriptor("icons/key.gif").createImage();
        }
        catch (Exception exception) {}
        this.parseConnStrings(connStrings);
    }

    public LoginDialog(String[] connStrings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.loadDescriptors();
        try {
            this.image = KSEServerPlugin.getImageDescriptor("icons/key.gif").createImage();
        }
        catch (Exception exception) {}
        this.parseConnStrings(connStrings);
    }

    private void parseConnStrings(String[] strings) {
        String[] temp = null;
        this._connStrings = strings;
        this.serverNames = new String[strings.length];
        this.serverHosts = new String[strings.length];
        this.serverPorts = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            temp = Utility.getTokens((String)strings[i], (String)":");
            this.serverNames[i] = temp[0];
            this.serverHosts[i] = temp[1];
            this.serverPorts[i] = temp[2];
            ++i;
        }
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(112);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LoginDialog_Caption);
        newShell.addDisposeListener(this.disposeListener);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.LoginDialog_UserName);
        this.txtUserId = new Text(composite, 2048);
        this.txtUserId.setText(this.userNameStr);
        this.txtUserId.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(140), -1));
        this.txtUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtUserId.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LoginDialog.this.txtUserId.selectAll();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.LoginDialog_Password);
        this.txtPassword = new Text(composite, 0x400800);
        this.txtPassword.setText(this.passwordStr);
        this.txtPassword.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(140), -1));
        this.txtPassword.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LoginDialog.this.txtPassword.selectAll();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.LoginDialog_Server);
        this.combo1 = new Combo(composite, 8);
        int i = 0;
        while (i < this.serverNames.length) {
            this.combo1.add(this.serverNames[i]);
            ++i;
        }
        this.combo1.select(this.serverIdx);
        this.combo1.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(100), -1));
        if (this.serverNames.length == 1) {
            this.combo1.setVisible(false);
            label.setVisible(false);
            this.combo1.select(0);
        }
        label = new Label(composite, 0);
        Composite actionComposite = new Composite(composite, 0);
        actionComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        actionComposite.setLayout((Layout)new GridLayout(2, false));
        this.btnRememberMe = new Button(actionComposite, 32);
        this.btnRememberMe.setText(Messages.LoginDialog_SavePassword);
        this.btnRememberMe.setSelection(this.rememberMe);
        Link link = new Link(actionComposite, 0);
        link.setText("<a>Forgot Password?</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT || Resources.PRODUCT_NAME == ProductNames.IMTRADE || Resources.PRODUCT_NAME == ProductNames.ITRADE || Resources.PRODUCT_NAME == ProductNames.ABBASI || Resources.PRODUCT_NAME == ProductNames.ASKARI || Resources.PRODUCT_NAME == ProductNames.BMA || Resources.PRODUCT_NAME == ProductNames.SHAJAR_PAK || Resources.PRODUCT_NAME == ProductNames.OMNI || Resources.PRODUCT_NAME == ProductNames.KTRADE || Resources.PRODUCT_NAME == ProductNames.NEXTCAP || Resources.PRODUCT_NAME == ProductNames.FOUNDATION || Resources.PRODUCT_NAME == ProductNames.ZAFFAR || Resources.PRODUCT_NAME == ProductNames.ALFLAH || Resources.PRODUCT_NAME == ProductNames.AHL || Resources.PRODUCT_NAME == ProductNames.IGI || Resources.PRODUCT_NAME == ProductNames.DYM) {
                    LoginDialog.this.cancelPressed();
                    ForgetPasswordDialog dlg = new ForgetPasswordDialog(LoginDialog.this._connStrings);
                    dlg.open();
                } else if (Resources.PRODUCT_NAME == ProductNames.IBROKER) {
                    try {
                        String url = "http://iterminal.calbrokersghana.com:7878/webterminal/forgot_password.html";
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
                    }
                    catch (Exception e) {
                        LoginDialog.this.logger.info((Object)("Exception in Forget Password Link : " + e.getMessage()));
                    }
                }
            }
        });
        if (Resources.registrationWebServicePath != null && !Resources.registrationWebServicePath.equals("")) {
            label = new Label(composite, 0);
            this.btnRegister = new Button(composite, 0);
            this.btnRegister.setText("Request for Account");
            this.btnRegister.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    LoginDialog.this.cancelPressed();
                    ClientRegistrationDialog dlg = new ClientRegistrationDialog();
                    dlg.open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        return super.createDialogArea(parent);
    }

    public int open() {
        this.create();
        if (Resources.ipWebServicePath != null && Resources.ipWebServicePath.length() > 0) {
            this.setTitle(String.valueOf(Messages.LoginDialog_Title) + " (Web Service)");
        } else {
            this.setTitle(Messages.LoginDialog_Title);
        }
        this.setMessage(Messages.LoginDialog_Description);
        this.setTitleImage(this.image);
        return super.open();
    }

    protected void okPressed() {
        Cursor cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 1);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
        this.userNameStr = this.txtUserId.getText();
        this.passwordStr = this.txtPassword.getText();
        if (this.loginValidation()) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!Resources.tcpLink) {
                        LoginDialog.this.startMessageServerLink();
                    }
                    if (Resources.tcpLink) {
                        Resources.loginRejected = false;
                        LoginDialog.this.sendLoginMessage();
                        while (!Resources.loginRejected && !Resources.loginStatus) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException e) {
                                System.out.println(e);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (Resources.loginStatus) {
                            invalidTries = 0;
                            Resources.userName = LoginDialog.this.txtUserId.getText();
                            Resources.password = LoginDialog.this.txtPassword.getText();
                            Resources.feedQueue = new FIFOQueue();
                            Resources.MBOQueue = new FIFOQueue();
                            TCPLink.alredyConnected = true;
                            try {
                                LoginDialog.this.saveDescriptors();
                                LoginDialog.this.image.dispose();
                                LoginDialog.this.image = null;
                            }
                            catch (Exception exception) {}
                            LoginDialog.super.okPressed();
                        } else {
                            invalidTries = invalidTries + 1;
                            String errorStr = Resources.loginRejReason;
                            if (invalidTries >= 5 && errorStr.contains("blocked")) {
                                errorStr = String.valueOf(errorStr) + LoginDialog.this.fetchFormatedStr();
                            }
                            MessageDialog.openError(null, (String)"Login Dialog", (String)errorStr);
                            CorePlugin.closeSockets();
                        }
                    } else {
                        CorePlugin.closeSockets();
                    }
                }
            });
            cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 0);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
        }
    }

    private void loadDescriptors() {
        try {
            IPreferenceStore preferences = KSEServerPlugin.getDefault().getPreferenceStore();
            this.rememberMe = preferences.getString("REMEMBER_ME").equalsIgnoreCase("true");
            this.userNameStr = this.rememberMe ? preferences.getString("USERNAME") : "";
            this.serverIdx = preferences.getInt("SERVER_IDX");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveDescriptors() {
        try {
            KSEServerPlugin.getDefault().getPreferenceStore().setValue("REMEMBER_ME", this.btnRememberMe.getSelection());
            KSEServerPlugin.getDefault().getPreferenceStore().setValue("USERNAME", this.txtUserId.getText());
            KSEServerPlugin.getDefault().getPreferenceStore().setValue("SERVER_IDX", this.combo1.getSelectionIndex());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public String getUserName() {
        return this.userNameStr;
    }

    public String getPassword() {
        return this.passwordStr;
    }

    /*
     * Unable to fully structure code
     */
    protected void startMessageServerLink() {
        Resources.clientLinks = new Hashtable<K, V>();
        Resources.msLinks = new HashMap<K, V>();
        host = "localhost";
        port = "6789";
        if (Resources.ipWebServicePath == null || Resources.ipWebServicePath.length() <= 0) ** GOTO lbl31
        msLinks = WebServiceUtil.getIpPort((String)this.txtUserId.getText());
        this.logger.info((Object)("MS links = " + (msLinks.length() > 200 ? msLinks.substring(0, 199) : msLinks)));
        if (msLinks == null || msLinks.equals("")) ** GOTO lbl29
        servers = msLinks.split("\\|");
        if (servers != null && servers.length > 0) {
            i = 0;
            while (i < servers.length) {
                ipPort = servers[i].split("\\:");
                if (ipPort != null && ipPort.length != 3) {
                    MessageDialog.openError(null, (String)"Invalid Server Configuration", (String)(String.valueOf(i) + "-Invalid configuration recieved from server = " + Arrays.toString(ipPort)));
                    return;
                }
                Resources.clientLinks.put(ipPort[0], String.valueOf(ipPort[1]) + ":" + (String)ipPort[2]);
                Resources.msLinks.put(String.valueOf(ipPort[1]) + ":" + (String)ipPort[2], null);
                ++i;
            }
            links = Resources.msLinks.size();
            CorePlugin.MS_CONNECTED = String.valueOf(links) + "/" + links + " MS Connected";
            CorePlugin.MS_NOT_CONNECTED = String.valueOf(links) + "/" + links + " MS Disconnected";
        } else {
            MessageDialog.openError(null, (String)"Invalid Format", (String)("Invalid format of MS configuration recieved from server = " + msLinks));
            return;
lbl29:
            // 1 sources

            MessageDialog.openError(null, (String)"Invalid Format", (String)("MS configuration not recieved from server = " + msLinks));
            return;
lbl31:
            // 1 sources

            host = this.serverHosts[this.combo1.getSelectionIndex()];
            port = this.serverPorts[this.combo1.getSelectionIndex()];
            Resources.clientLinks.put(this.txtUserId.getText(), String.valueOf(host) + ":" + port);
            Resources.msLinks.put(String.valueOf(host) + ":" + port, null);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int connected = 0;
                for (String ipPort : Resources.clientLinks.values()) {
                    if (Resources.msLinks.get(ipPort) != null) continue;
                    TCPLink link = new TCPLink(Resources.tradeQueue);
                    String[] arr = ipPort.split("\\:");
                    if (link.initTcpLink(arr[0], arr[1])) {
                        LoginDialog.this.logger.info((Object)(String.valueOf(connected) + " MS link connected " + ipPort));
                        link.setName("MS Link " + connected);
                        Resources.msLinks.put(ipPort, link);
                        Resources.tradeLink = link;
                        ++connected;
                        continue;
                    }
                    MessageDialog.openError(null, (String)"Login Dialog", (String)("Unable to connect to " + ipPort));
                    Resources.tcpLink = false;
                    return;
                }
                Resources.tcpLink = true;
            }
        });
    }

    protected void sendLoginMessage() {
        if (Resources.tradeLink != null) {
            LoginMessage msg = new LoginMessage(this.userNameStr.toUpperCase(), this.passwordStr, "", -1, invalidTries, true, LoginMessage.ECLIPSE_TERMINAL);
            msg.setEclipseVersion(Resources.eclipseVersion);
            Resources.isReconnecting = Boolean.FALSE;
            Resources.sendToAllMS((Message)msg);
        }
    }

    private boolean loginValidation() {
        block4: {
            try {
                if (!this.userNameStr.equals("")) break block4;
                MessageDialog.openError(null, (String)"Application Login", (String)"Please enter your user Id.");
                this.txtUserId.setFocus();
                return false;
            }
            catch (Exception exception) {}
        }
        if (this.passwordStr.equals("")) {
            MessageDialog.openError(null, (String)"Application Login", (String)"Please enter your password.");
            this.txtPassword.setFocus();
            return false;
        }
        return true;
    }

    private String fetchFormatedStr() {
        String errorStr = "";
        if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline 0800-52722 or email us at \nbipldirect@biplsec.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline 0800-46700 or email us at \ncs@imsecurities.com.pk\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.ITRADE) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline 0800-23434 or email us at \nitrade@i-trade.com.pk\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.ABBASI) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline +92-42-38302028 - 32300180 Ext 100 - 171 or email us at \nsupport@abbasiandcompany.com\nalong with your Account ID.";
        } else if (Resources.PRODUCT_NAME == ProductNames.ASKARI) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline + 92 51 2894521 \u00f1 4 or email us at \nservice@askarisecurities.com.pk\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.BMA) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline +92 21 111 262 872 or email us at \nbmatrade@bmacapital.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.SHAJAR_PAK) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline 042 - 3636 9991-8 or email us at \ninfo@shajarpaksecurities.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.OMNI) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline 800-880-0338 or 512-345-2566 or email us at \nsupport@omnitrader.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.KTRADE) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline (021)35171786-9 Fax  (021)35171790 or email us at \ncontact@kasb.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.NEXTCAP) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline 92-21-111-639-825 Ext 114 or email us at \ncf@nextcapital.com.pk\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.FOUNDATION) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline 0800-87233 or email us at \ninfo@fsedge.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.ZAFFAR) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline +92 308 4444013  | +92 308 4444023 or email us at \ninfo@zafarstocks.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.ALFLAH) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline +92-21-111 237 111 or email us at \ninfo@alfalahsec.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.DYM) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline +92-42-36314141, +92-42-36314176-81 or email us at \ninfo@invest.pk\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.AHL) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline +92 21 3241 5213 - 15, +92 21 3246 0717 - 19 or email us at \ninfo@arifhabibltd.com\nalong with your account id.";
        } else if (Resources.PRODUCT_NAME == ProductNames.IGI) {
            errorStr = String.valueOf(errorStr) + "\n\nFor reactivation,\nKindly call our helpline +92 21 111 444 001 or email us at \ninfo@igi.com.pk\nalong with your account id.";
        }
        return errorStr;
    }
}

