/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;
import pk.com.softech.tradingterminal.kseServer.LoginDialog;
import pk.com.softech.tradingterminal.trading.MessageCollector;

public class LinkHandler {
    public static final String NO_OF_CONNECTIONS_TAG = "NO_OF_CONNECTIONS";
    public static final String CONNECTION_TAG = "CONNECTION";
    public static final String TIME_ZONE_TAG = "TIME_ZONE";
    public static final String FEED_DUMP_FILE_TAG = "FEED_DUMP_FILE";
    public static final String READ_LOCAL_FEED_TAG = "READ_LOCAL_FEED";
    public static final String NO_OF_PORTS_TAG = "NO_OF_PORTS";
    public static final String PORT_TAG = "PORT";
    public static final String PARSER_PORT_TAG = "PARSER_PORT";
    public static final String IP_WEB_SERVICE_PATH_TAG = "IP_WEB_SERVICE_PATH";
    public static final String REGISTRATION_WEB_SERVICE_PATH_TAG = "REGISTRATION_WEB_SERVICE_PATH";
    public static final String WEB_SERVICE_PATH_TAG = "WEB_SERVICE_PATH";
    public static final String IGNORE_AUTOUPDATE_URL_TAG = "IGNORE_AUTOUPDATE_URL";
    Properties configProps = new Properties();
    private static LinkHandler instance = null;
    private String userName = "";
    private String password = "";
    private String[] connectionStrings = null;
    private MessageCollector messageCollector;
    private Log log = LogFactory.getLog(this.getClass());

    private LinkHandler() {
        Resources.tradeQueue = new FIFOQueue();
        this.messageCollector = new MessageCollector(Resources.tradeQueue);
    }

    public void init() {
        if (!Resources.loginStatus) {
            this.openLoginDialog();
        }
    }

    public static LinkHandler getInstance() {
        if (instance == null) {
            instance = new LinkHandler();
        }
        return instance;
    }

    private boolean openLoginDialog() {
        if (this.loadProperties()) {
            this.loadConnections();
            this.loadExpiredNewsUrls();
            LoginDialog dlg = new LoginDialog(this.connectionStrings);
            if (dlg.open() != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean loadProperties() {
        try {
            FileInputStream inputStream = new FileInputStream(String.valueOf(Platform.getLocation().toPortableString()) + Resources.configFile);
            this.configProps.load(inputStream);
            inputStream.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void loadConnections() {
        int noOfPorts;
        int noOfConnections = Integer.parseInt(this.configProps.getProperty(NO_OF_CONNECTIONS_TAG));
        if (noOfConnections > 0) {
            this.connectionStrings = new String[noOfConnections];
            int i = 0;
            while (i < noOfConnections) {
                this.connectionStrings[i] = this.configProps.getProperty(CONNECTION_TAG + (i + 1));
                ++i;
            }
        } else {
            MessageDialog.openError(null, (String)"Trading Terminal", (String)"Connection Failed:\nInvalid number of connections defined in the configuration file.");
            System.exit(0);
        }
        Resources.feedDumpFile = this.configProps.getProperty(FEED_DUMP_FILE_TAG);
        if (Resources.feedDumpFile != null && !Resources.feedDumpFile.trim().equals("")) {
            File f = new File(Platform.getLocation().toFile(), Resources.feedDumpFile);
            Resources.feedDumpFile = f.getAbsolutePath();
        }
        if (this.configProps.getProperty(READ_LOCAL_FEED_TAG) != null && this.configProps.getProperty(READ_LOCAL_FEED_TAG).equalsIgnoreCase("YES")) {
            Resources.localFeedOption = true;
        }
        this.log.debug((Object)("Local Feed option " + Resources.localFeedOption));
        this.log.debug((Object)("Feed Dump File " + Resources.feedDumpFile));
        if (Resources.localFeedOption && (noOfPorts = Integer.parseInt(this.configProps.getProperty(NO_OF_PORTS_TAG))) > 0) {
            Resources.udpPorts = new String[noOfPorts];
            Resources.udpPortsParsers = new String[noOfPorts];
            int i = 0;
            while (i < noOfPorts) {
                Resources.udpPorts[i] = this.configProps.getProperty(PORT_TAG + (i + 1));
                Resources.udpPortsParsers[i] = this.configProps.getProperty(PARSER_PORT_TAG + (i + 1));
                ++i;
            }
        }
        Resources.smsWebServicePath = this.configProps.getProperty(WEB_SERVICE_PATH_TAG);
        Resources.ipWebServicePath = this.configProps.getProperty(IP_WEB_SERVICE_PATH_TAG, "");
        this.log.debug((Object)("IP Web Service " + Resources.ipWebServicePath));
        Resources.registrationWebServicePath = this.configProps.getProperty(REGISTRATION_WEB_SERVICE_PATH_TAG, "");
        this.log.debug((Object)("Registration Web Service " + Resources.registrationWebServicePath));
        Resources.ignoreAutoUpdateUrl = this.configProps.getProperty(IGNORE_AUTOUPDATE_URL_TAG, "false").equalsIgnoreCase("YES");
        this.log.info((Object)("Ignore Autoupdate URL " + Resources.ignoreAutoUpdateUrl));
    }

    private void loadExpiredNewsUrls() {
        int noOfExpiredNewsUrl;
        Resources.IGNORE_NEWS_PROVIDER_URL_SET.add("www.brecorder.com");
        Resources.IGNORE_NEWS_PROVIDER_URL_SET.add("feeds.feedburner.com/TheNewsInternational-Business");
        Resources.IGNORE_NEWS_PROVIDER_URL_SET.add("feeds.feedburner.com/com/YEor");
        String noOfUrlsStr = this.configProps.getProperty("NO_OF_EXPIRED_NEWS_URL_LINKS");
        if (noOfUrlsStr != null && !"".equalsIgnoreCase(noOfUrlsStr) && (noOfExpiredNewsUrl = Integer.parseInt(noOfUrlsStr)) > 0) {
            int i = 0;
            while (i < noOfExpiredNewsUrl) {
                String url = this.configProps.getProperty("EXPIRED_URL_LINK_" + (i + 1));
                if (url != null && !"".equalsIgnoreCase(url)) {
                    Resources.IGNORE_NEWS_PROVIDER_URL_SET.add(url);
                }
                ++i;
            }
        }
    }
}

