/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.tradingterminal.core.ILevel2Feed;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Level2Ask;
import pk.com.softech.tradingterminal.core.db.Level2Bid;
import pk.com.softech.tradingterminal.core.db.Security;

public class Level2Feed
implements ILevel2Feed,
Runnable {
    private Map<String, Security> map = new HashMap<String, Security>();
    private Thread thread;
    private boolean stopping = false;
    private Log log = LogFactory.getLog(this.getClass());

    public void subscribeLevel2(Security security) {
        this.map.put(security.getId(), security);
    }

    public void unSubscribeLevel2(Security security) {
        this.map.remove(security.getId());
    }

    public void startLevel2() {
        if (this.thread == null) {
            this.stopping = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stopLevel2() {
        this.stopping = true;
        if (this.thread != null) {
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)e, (Throwable)e);
            }
            this.thread = null;
        }
    }

    public void snapshotLevel2() {
    }

    @Override
    public void run() {
        while (!this.stopping) {
            try {
                if (Resources.MBOQueue == null) continue;
                String msg = (String)Resources.MBOQueue.remove();
                this.update(msg);
            }
            catch (Exception ex) {
                this.log.error((Object)"Level2Feed run : ", (Throwable)ex);
                this.log.error((Object)ex.getMessage());
            }
        }
    }

    private void update(String msg) {
        this.log.trace((Object)("Level2 " + msg));
        String[] allTokens = this.getTokens(msg, "|");
        String[] buySellTokens = this.getTokens(allTokens[1], ";");
        String exchange = buySellTokens[0];
        String symbol = buySellTokens[1];
        String market = buySellTokens[2];
        Security security = this.map.get(String.valueOf(exchange) + "." + symbol + "(" + market + ")");
        if (security != null) {
            int i;
            String[] buyTokens = null;
            String[] sellTokens = null;
            int buyIndex = this.findStringIndex(buySellTokens, "BUY");
            int sellIndex = this.findStringIndex(buySellTokens, "SELL");
            if (buySellTokens[buyIndex].equals("BUY") && this.buyMsgExixt(buySellTokens, buyIndex)) {
                String buyMsg = buySellTokens[++buyIndex];
                buyTokens = this.getTokens(buyMsg, "$");
            }
            if (buySellTokens[sellIndex].equals("SELL") && this.sellMsgExist(buySellTokens, sellIndex)) {
                String sellMsg = buySellTokens[++sellIndex];
                sellTokens = this.getTokens(sellMsg, "$");
            }
            String[] valueTokens = null;
            Level2Bid bid = new Level2Bid();
            Level2Ask ask = new Level2Ask();
            if (buyTokens != null) {
                i = 0;
                while (i < buyTokens.length) {
                    valueTokens = this.getTokens(buyTokens[i], ",");
                    if (allTokens[0].equals("MBO")) {
                        bid.add((double)Float.parseFloat(valueTokens[0]), Integer.parseInt(valueTokens[1]), valueTokens[2], Integer.parseInt(valueTokens[3]));
                    } else if (allTokens[0].equals("MBP")) {
                        bid.add((double)Float.parseFloat(valueTokens[2]), Integer.parseInt(valueTokens[1]), Integer.parseInt(valueTokens[0]));
                    }
                    ++i;
                }
            }
            if (sellTokens != null) {
                i = 0;
                while (i < sellTokens.length) {
                    valueTokens = this.getTokens(sellTokens[i], ",");
                    if (allTokens[0].equals("MBO")) {
                        ask.add((double)Float.parseFloat(valueTokens[0]), Integer.parseInt(valueTokens[1]), valueTokens[2], Integer.parseInt(valueTokens[3]));
                    } else if (allTokens[0].equals("MBP")) {
                        ask.add((double)Float.parseFloat(valueTokens[2]), Integer.parseInt(valueTokens[1]), Integer.parseInt(valueTokens[0]));
                    }
                    ++i;
                }
            }
            if (allTokens[0].equals("MBO")) {
                security.setLevel2MBO(bid, ask);
            } else if (allTokens[0].equals("MBP")) {
                security.setLevel2MBP(bid, ask);
            }
        }
    }

    private boolean buyMsgExixt(String[] arr, int buyIndex) {
        return !arr[buyIndex + 1].equals("SELL");
    }

    private boolean sellMsgExist(String[] arr, int sellIndex) {
        return sellIndex + 2 == arr.length;
    }

    private int findStringIndex(String[] arr, String text) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String[] getTokens(String str, String delimiter) {
        String[] tokenArray = null;
        StringTokenizer st = new StringTokenizer(str, delimiter);
        int tokenCount = st.countTokens();
        tokenArray = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            tokenArray[i] = st.nextToken();
            ++i;
        }
        return tokenArray;
    }
}

