/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.awt.Desktop;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.LoginMessage;
import pk.com.softech.messages.Message;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.link.TCPLink;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.FIFOQueue;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.kseServer.ClientRegistrationDialog;
import pk.com.softech.tradingterminal.kseServer.ForgetPasswordDialog;
import pk.com.softech.tradingterminal.kseServer.KSEServerPlugin;
import pk.com.softech.tradingterminal.kseServer.Messages;
import pk.com.softech.util.Utility;
import pk.com.softech.util.WebServiceUtil;

public class KASBLoginDialog
extends TitleAreaDialog
implements Listener {
    private boolean rememberMe = false;
    private String userNameStr = "";
    private String passwordStr = "";
    private int serverIdx = 0;
    private Text txtUserId;
    private Text txtPassword;
    private Combo combo1;
    private Button btnRememberMe;
    private Button btnRegister;
    private String[] serverNames = null;
    private String[] serverHosts = null;
    private String[] serverPorts = null;
    private String[] _connStrings = null;
    Log logger = LogFactory.getLog((String)KASBLoginDialog.class.getName());
    private static int invalidTries = 0;
    GridData data;
    Label message;
    Link kasbLink;
    Composite content;
    Composite msgComposite;
    Color red;
    Color blue;
    private Image image = KSEServerPlugin.getImageDescriptor("icons/key.gif").createImage();

    public KASBLoginDialog(String userName, String password, String[] connStrings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.userNameStr = userName;
        this.passwordStr = password;
        this.parseConnStrings(connStrings);
    }

    public KASBLoginDialog(String[] connStrings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.loadDescriptors();
        this.parseConnStrings(connStrings);
    }

    private void parseConnStrings(String[] strings) {
        this._connStrings = strings;
        String[] temp = null;
        this.serverNames = new String[strings.length];
        this.serverHosts = new String[strings.length];
        this.serverPorts = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            temp = Utility.getTokens((String)strings[i], (String)":");
            this.serverNames[i] = temp[0];
            this.serverHosts[i] = temp[1];
            this.serverPorts[i] = temp[2];
            ++i;
        }
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(112);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LoginDialog_Caption);
        if (Resources.PRODUCT_NAME == ProductNames.ITRADE) {
            newShell.setSize(430, 300);
        } else {
            newShell.setSize(400, 230);
        }
        newShell.setLocation(480, 300);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
    }

    protected Control createDialogArea(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.content.setLayout((Layout)gridLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.LoginDialog_UserName);
        this.txtUserId = new Text(composite, 2048);
        this.txtUserId.setText(this.userNameStr);
        this.txtUserId.setLayoutData((Object)new GridData(100, -1));
        this.txtUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtUserId.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                KASBLoginDialog.this.txtUserId.selectAll();
            }
        });
        this.txtUserId.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = false;
                    KASBLoginDialog.this.txtPassword.setFocus();
                }
            }
        });
        this.btnRememberMe = new Button(composite, 32);
        this.btnRememberMe.setText(Messages.LoginDialog_SavePassword);
        this.btnRememberMe.setSelection(this.rememberMe);
        label = new Label(composite, 0);
        label.setText(Messages.LoginDialog_Password);
        this.txtPassword = new Text(composite, 0x400800);
        this.txtPassword.setText(this.passwordStr);
        this.txtPassword.setLayoutData((Object)new GridData(100, -1));
        this.txtPassword.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                KASBLoginDialog.this.txtPassword.selectAll();
            }
        });
        Link link = new Link(composite, 0);
        link.setText("<a>Forgot Password?</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT || Resources.PRODUCT_NAME == ProductNames.IMTRADE || Resources.PRODUCT_NAME == ProductNames.ITRADE || Resources.PRODUCT_NAME == ProductNames.ABBASI || Resources.PRODUCT_NAME == ProductNames.ASKARI || Resources.PRODUCT_NAME == ProductNames.BMA || Resources.PRODUCT_NAME == ProductNames.SHAJAR_PAK || Resources.PRODUCT_NAME == ProductNames.OMNI || Resources.PRODUCT_NAME == ProductNames.KTRADE || Resources.PRODUCT_NAME == ProductNames.NEXTCAP || Resources.PRODUCT_NAME == ProductNames.FOUNDATION || Resources.PRODUCT_NAME == ProductNames.ZAFFAR || Resources.PRODUCT_NAME == ProductNames.ALFLAH || Resources.PRODUCT_NAME == ProductNames.DYM) {
                    KASBLoginDialog.this.cancelPressed();
                    ForgetPasswordDialog dlg = new ForgetPasswordDialog(KASBLoginDialog.this._connStrings);
                    dlg.open();
                } else if (Resources.PRODUCT_NAME == ProductNames.IBROKER) {
                    try {
                        String url = "http://iterminal.calbrokersghana.com:7878/webterminal/forgot_password.html";
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
                    }
                    catch (Exception e) {
                        KASBLoginDialog.this.logger.info((Object)("Exception in Forget Password Link : " + e.getMessage()));
                    }
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.LoginDialog_Server);
        this.combo1 = new Combo(composite, 8);
        int i = 0;
        while (i < this.serverNames.length) {
            this.combo1.add(this.serverNames[i]);
            ++i;
        }
        this.combo1.select(this.serverIdx);
        this.combo1.setLayoutData((Object)new GridData(84, -1));
        if (this.serverNames.length == 1) {
            this.combo1.setVisible(false);
            label.setVisible(false);
            this.combo1.select(0);
        }
        label = new Label(composite, 0);
        label.setText("");
        if (Resources.registrationWebServicePath != null && !Resources.registrationWebServicePath.equals("")) {
            label = new Label(composite, 0);
            this.btnRegister = new Button(composite, 0);
            this.btnRegister.setText("Request for Account");
            this.btnRegister.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    KASBLoginDialog.this.cancelPressed();
                    ClientRegistrationDialog dlg = new ClientRegistrationDialog();
                    dlg.open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        Composite buttonComposite = new Composite(this.content, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.createButton(buttonComposite, 0, "Login", false);
        this.createButton(buttonComposite, 1, "Cancel", false);
        this.msgComposite = new Group(this.content, 16);
        this.msgComposite.setLayout((Layout)new GridLayout());
        this.data = new GridData(4, 4, true, true, 4, 4);
        this.msgComposite.setLayoutData((Object)this.data);
        this.message = new Label(this.msgComposite, 0);
        this.message.setText("");
        this.kasbLink = new Link(this.msgComposite, 0);
        this.kasbLink.setText("");
        Display display = Display.getCurrent();
        this.red = display.getSystemColor(3);
        this.blue = display.getSystemColor(9);
        this.data.exclude = !this.data.exclude;
        this.msgComposite.setVisible(!this.data.exclude);
        this.content.layout();
        this.txtUserId.addListener(1, (Listener)this);
        this.txtPassword.addListener(1, (Listener)this);
        return super.createDialogArea(parent);
    }

    public int open() {
        this.create();
        if (Resources.ipWebServicePath != null && Resources.ipWebServicePath.length() > 0) {
            this.setTitle(String.valueOf(Messages.LoginDialog_Title) + " (Web Service)");
        } else {
            this.setTitle(Messages.LoginDialog_Title);
        }
        this.setMessage(Messages.LoginDialog_Description);
        this.setTitleImage(this.image);
        return super.open();
    }

    protected void okPressed() {
        Cursor cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 1);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
        this.userNameStr = this.txtUserId.getText();
        this.passwordStr = this.txtPassword.getText();
        if (this.loginValidation()) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!Resources.tcpLink) {
                        KASBLoginDialog.this.startMessageServerLink();
                    }
                    if (Resources.tcpLink) {
                        Resources.loginRejected = false;
                        KASBLoginDialog.this.sendLoginMessage();
                        while (!Resources.loginRejected && !Resources.loginStatus) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException e) {
                                System.out.println(e);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (Resources.loginStatus) {
                            invalidTries = 0;
                            Resources.userName = KASBLoginDialog.this.txtUserId.getText();
                            Resources.password = KASBLoginDialog.this.txtPassword.getText();
                            Resources.feedQueue = new FIFOQueue();
                            Resources.MBOQueue = new FIFOQueue();
                            TCPLink.alredyConnected = true;
                            try {
                                KASBLoginDialog.this.saveDescriptors();
                                KASBLoginDialog.this.image.dispose();
                                KASBLoginDialog.this.image = null;
                            }
                            catch (Exception exception) {}
                            KASBLoginDialog.super.okPressed();
                        } else {
                            invalidTries = invalidTries + 1;
                            if (invalidTries >= 3 && (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT || Resources.PRODUCT_NAME == ProductNames.IMTRADE || Resources.PRODUCT_NAME == ProductNames.ITRADE || Resources.PRODUCT_NAME == ProductNames.ABBASI || Resources.PRODUCT_NAME == ProductNames.ASKARI || Resources.PRODUCT_NAME == ProductNames.BMA || Resources.PRODUCT_NAME == ProductNames.SHAJAR_PAK || Resources.PRODUCT_NAME == ProductNames.OMNI || Resources.PRODUCT_NAME == ProductNames.KTRADE || Resources.PRODUCT_NAME == ProductNames.NEXTCAP || Resources.PRODUCT_NAME == ProductNames.FOUNDATION || Resources.PRODUCT_NAME == ProductNames.ZAFFAR || Resources.PRODUCT_NAME == ProductNames.ALFLAH) || Resources.PRODUCT_NAME == ProductNames.DYM) {
                                KASBLoginDialog.this.message.setText("Account is blocked due to 3 unsuccessful attempts!");
                                KASBLoginDialog.this.message.setForeground(KASBLoginDialog.this.red);
                                if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call our helpline 0800-52722 or email us at        \n<a> bipldirect@biplsec.com</a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call our helpline 0800-46700 or email us at        \n<a> cs@imsecurities.com.pk</a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.ITRADE) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call our helpline 0800-23434 or email us at        \n<a> itrade@i-trade.com.pk</a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.ABBASI) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call +92-42-36315151 - 36282700 Ext:333,346  or email us at        \n<a>  support@abbasiandcompany.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.ASKARI) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call  + 92 51 2894521 \ufffd 4 or email us at        \n<a>   service@askarisecurities.com.pk </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.BMA) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call  +92 21 111 262 872 or email us at        \n<a>   bmatrade@bmacapital.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.SHAJAR_PAK) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call  042 - 3636 9991-8 or email us at        \n<a>  info@shajarpaksecurities.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.OMNI) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call  800-880-0338 or 512-345-2566 or email us at        \n<a>  support@omnitrader.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.KTRADE) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call  (021)35171786-9 Fax  (021)35171790  or email us at        \n<a>  contact@kasb.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.NEXTCAP) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call   92-21-111-639-825 Ext 114  or email us at        \n<a>  cf@nextcapital.com.pk </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.FOUNDATION) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call   0800-87233  or email us at        \n<a>  info@fsedge.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.ZAFFAR) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call   +92 308 4444013  | +92 308 4444023  or email us at        \n<a>  info@zafarstocks.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.ALFLAH) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call  +92-21-111 237 111  or email us at        \n<a>  info@alfalahsec.com </a> along with your account id.");
                                } else if (Resources.PRODUCT_NAME == ProductNames.DYM) {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly call  +92-42-36314141, +92-42-36314176-81  or email us at        \n<a>   info@invest.pk </a> along with your account id.");
                                } else {
                                    KASBLoginDialog.this.kasbLink.setText("For reactivation, kindly contact to System Administrator along with your account id.");
                                }
                                KASBLoginDialog.this.kasbLink.addListener(13, new Listener(){

                                    public void handleEvent(Event event) {
                                        try {
                                            if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT) {
                                                URI uri = URI.create("mailto:bipldirect@biplsec.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
                                                URI uri = URI.create("mailto:cs@imsecurities.com.pk");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.ITRADE) {
                                                URI uri = URI.create("mailto:itrade@i-trade.com.pk");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.ABBASI) {
                                                URI uri = URI.create("mailto:support@abbasiandcompany.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.ASKARI) {
                                                URI uri = URI.create("mailto:service@askarisecurities.com.pk");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.BMA) {
                                                URI uri = URI.create("mailto:bmatrade@bmacapital.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.SHAJAR_PAK) {
                                                URI uri = URI.create("mailto:info@shajarpaksecurities.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.OMNI) {
                                                URI uri = URI.create("mailto:support@omnitrader.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.KTRADE) {
                                                URI uri = URI.create("mailto:contact@kasb.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.NEXTCAP) {
                                                URI uri = URI.create("mailto:cf@nextcapital.com.pk");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.FOUNDATION) {
                                                URI uri = URI.create("mailto:info@fsedge.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.ZAFFAR) {
                                                URI uri = URI.create("mailto:info@zafarstocks.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.ALFLAH) {
                                                URI uri = URI.create("mailto:info@alfalahsec.com");
                                                Desktop.getDesktop().mail(uri);
                                            } else if (Resources.PRODUCT_NAME == ProductNames.DYM) {
                                                URI uri = URI.create("mailto:info@invest.pk");
                                                Desktop.getDesktop().mail(uri);
                                            }
                                        }
                                        catch (Exception e) {
                                            (this).KASBLoginDialog.this.logger.info((Object)e.getMessage());
                                        }
                                    }
                                });
                                Display.getDefault().getActiveShell().setSize(400, 310);
                            } else {
                                KASBLoginDialog.this.message.setText(Resources.loginRejReason);
                                KASBLoginDialog.this.showMessage();
                                Display.getDefault().getActiveShell().setSize(400, 295);
                            }
                            CorePlugin.closeSockets();
                        }
                    } else {
                        CorePlugin.closeSockets();
                    }
                }
            });
        }
        cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 0);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
    }

    private void loadDescriptors() {
        try {
            IPreferenceStore preferences = KSEServerPlugin.getDefault().getPreferenceStore();
            this.rememberMe = preferences.getString("REMEMBER_ME").equalsIgnoreCase("true");
            this.userNameStr = this.rememberMe ? preferences.getString("USERNAME") : "";
            this.serverIdx = preferences.getInt("SERVER_IDX");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveDescriptors() {
        try {
            KSEServerPlugin.getDefault().getPreferenceStore().setValue("REMEMBER_ME", this.btnRememberMe.getSelection());
            KSEServerPlugin.getDefault().getPreferenceStore().setValue("USERNAME", this.txtUserId.getText());
            KSEServerPlugin.getDefault().getPreferenceStore().setValue("SERVER_IDX", this.combo1.getSelectionIndex());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public String getUserName() {
        return this.userNameStr;
    }

    public String getPassword() {
        return this.passwordStr;
    }

    /*
     * Unable to fully structure code
     */
    protected void startMessageServerLink() {
        Resources.clientLinks = new Hashtable<K, V>();
        Resources.msLinks = new HashMap<K, V>();
        host = "localhost";
        port = "6789";
        if (Resources.ipWebServicePath == null || Resources.ipWebServicePath.length() <= 0) ** GOTO lbl37
        msLinks = WebServiceUtil.getIpPort((String)this.txtUserId.getText());
        this.logger.info((Object)("MS links = " + (msLinks.length() > 200 ? msLinks.substring(0, 199) : msLinks)));
        if (msLinks == null || msLinks.equals("")) ** GOTO lbl33
        servers = msLinks.split("\\|");
        if (servers != null && servers.length > 0) {
            i = 0;
            while (i < servers.length) {
                ipPort = servers[i].split("\\:");
                if (ipPort != null && ipPort.length != 3) {
                    this.message.setText("-Invalid configuration recieved from server = \n" + Arrays.toString(ipPort));
                    this.showMessage();
                    Display.getDefault().getActiveShell().setSize(400, 305);
                    return;
                }
                Resources.clientLinks.put(ipPort[0], String.valueOf(ipPort[1]) + ":" + (String)ipPort[2]);
                Resources.msLinks.put(String.valueOf(ipPort[1]) + ":" + (String)ipPort[2], null);
                ++i;
            }
            links = Resources.msLinks.size();
            CorePlugin.MS_CONNECTED = String.valueOf(links) + "/" + links + " MS Connected";
            CorePlugin.MS_NOT_CONNECTED = String.valueOf(links) + "/" + links + " MS Disconnected";
        } else {
            this.message.setText("Invalid format of MS configuration recieved from server = " + msLinks);
            this.showMessage();
            Display.getDefault().getActiveShell().setSize(400, 292);
            return;
lbl33:
            // 1 sources

            this.message.setText("MS configuration not recieved from server = " + msLinks);
            this.showMessage();
            Display.getDefault().getActiveShell().setSize(400, 292);
            return;
lbl37:
            // 1 sources

            host = this.serverHosts[this.combo1.getSelectionIndex()];
            port = this.serverPorts[this.combo1.getSelectionIndex()];
            Resources.clientLinks.put(this.txtUserId.getText(), String.valueOf(host) + ":" + port);
            Resources.msLinks.put(String.valueOf(host) + ":" + port, null);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int connected = 0;
                for (String ipPort : Resources.clientLinks.values()) {
                    if (Resources.msLinks.get(ipPort) != null) continue;
                    TCPLink link = new TCPLink(Resources.tradeQueue);
                    String[] arr = ipPort.split("\\:");
                    if (link.initTcpLink(arr[0], arr[1])) {
                        KASBLoginDialog.this.logger.info((Object)(String.valueOf(connected) + " MS link connected " + ipPort));
                        link.setName("MS Link " + connected);
                        Resources.msLinks.put(ipPort, link);
                        Resources.tradeLink = link;
                        ++connected;
                        continue;
                    }
                    KASBLoginDialog.this.message.setText("Unable to connect to " + ipPort);
                    KASBLoginDialog.this.showMessage();
                    Display.getDefault().getActiveShell().setSize(400, 292);
                    Resources.tcpLink = false;
                    return;
                }
                Resources.tcpLink = true;
            }
        });
    }

    protected void sendLoginMessage() {
        if (Resources.tradeLink != null) {
            LoginMessage msg = new LoginMessage(this.userNameStr.toUpperCase(), this.passwordStr.toUpperCase(), "", -1, invalidTries, true, LoginMessage.ECLIPSE_TERMINAL);
            msg.setEclipseVersion(Resources.eclipseVersion);
            Resources.sendToAllMS((Message)msg);
        }
    }

    private boolean loginValidation() {
        block4: {
            try {
                if (!this.userNameStr.equals("")) break block4;
                this.message.setText("Please enter your user Id.    ");
                this.showMessage();
                this.txtUserId.setFocus();
                return false;
            }
            catch (Exception exception) {}
        }
        if (this.passwordStr.equals("")) {
            this.message.setText("Please enter your password.    ");
            this.showMessage();
            this.txtPassword.setFocus();
            return false;
        }
        return true;
    }

    public void handleEvent(Event event) {
        if (event.character == '\r') {
            this.okPressed();
        }
    }

    public void showMessage() {
        this.message.setForeground(this.red);
        this.kasbLink.setText("");
        if (!this.msgComposite.isVisible()) {
            this.data.exclude = false;
            this.msgComposite.setVisible(true);
            this.content.layout();
            Display.getDefault().getActiveShell().setSize(400, 290);
        }
    }
}

