/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.messages.IndexGraphRequest;
import pk.com.softech.messages.SymbolChartRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IHistoryFeed;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;

public class HistoryFeed
implements IHistoryFeed {
    private Log log = LogFactory.getLog(this.getClass());

    public boolean updateHistory(Security security, int interval) {
        IndexGraphRequest request = null;
        String mktCode = null;
        String exCode = null;
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            if (interval == 8) {
                Calendar from = Calendar.getInstance();
                from.add(1, -CorePlugin.getDefault().getPreferenceStore().getInt("HISTORICAL_PRICE_RANGE"));
                from.set(2, 0);
                from.set(5, 1);
                if (security.getMarket().equalsIgnoreCase("EXCH")) {
                    request = new IndexGraphRequest(security.getSymbol(), from.getTime(), new Date());
                    mktCode = "EXCH";
                } else {
                    mktCode = (String)Resources.marketTypeCodes.get(Resources.marketTypes.indexOf(security.getMarket()));
                    request = new SymbolChartRequest(security.getSymbol(), mktCode, from.getTime(), new Date());
                }
                exCode = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(security.getExchange())).toString();
                this.log.info((Object)("Updating history chart data for: " + security.getId() + " - " + exCode + " - " + mktCode));
            } else {
                if (security.getMarket().equalsIgnoreCase("EXCH")) {
                    request = new IndexGraphRequest(security.getSymbol());
                    mktCode = "EXCH";
                } else {
                    mktCode = (String)Resources.marketTypeCodes.get(Resources.marketTypes.indexOf(security.getMarket()));
                    request = new SymbolChartRequest(security.getSymbol(), mktCode);
                }
                exCode = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(security.getExchange())).toString();
                this.log.info((Object)("Updating intraday chart data for: " + security.getId() + " - " + exCode + " - " + mktCode));
            }
            request.setStExCode(exCode);
            return Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
        }
        return false;
    }
}

