/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.ForgetPasswordRequest;
import pk.com.softech.messages.Message;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.link.TCPLink;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.kseServer.LoginDialog;
import pk.com.softech.tradingterminal.kseServer.Messages;
import pk.com.softech.util.Utility;
import pk.com.softech.util.WebServiceUtil;

public class ForgetPasswordDialog
extends TitleAreaDialog {
    Composite content;
    private Text txtUserId;
    private Text txtEmail;
    private String userIdStr = "";
    private String emailAddressStr = "";
    private String[] serverNames = null;
    private String[] serverHosts = null;
    private String[] serverPorts = null;
    private int serverIdx = 0;
    private Combo combo1;
    Log logger = LogFactory.getLog((String)LoginDialog.class.getName());
    GridData data;
    Label message;
    Link forgotPasswordLink;
    Composite msgComposite;
    Color red;

    public ForgetPasswordDialog(String[] connStrings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.parseConnStrings(connStrings);
    }

    private void parseConnStrings(String[] strings) {
        String[] temp = null;
        this.serverNames = new String[strings.length];
        this.serverHosts = new String[strings.length];
        this.serverPorts = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            temp = Utility.getTokens((String)strings[i], (String)":");
            this.serverNames[i] = temp[0];
            this.serverHosts[i] = temp[1];
            this.serverPorts[i] = temp[2];
            ++i;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LoginDialog_Caption);
        newShell.setSize(400, 300);
        newShell.setLocation(450, 250);
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(80);
    }

    protected Control createDialogArea(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("User ID: ");
        this.txtUserId = new Text(composite, 2048);
        this.txtUserId.setLayoutData((Object)new GridData(100, -1));
        this.txtUserId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ForgetPasswordDialog.this.validatePage();
            }
        });
        this.txtUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtUserId.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ForgetPasswordDialog.this.txtUserId.selectAll();
            }
        });
        this.txtUserId.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = false;
                    ForgetPasswordDialog.this.txtEmail.setFocus();
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("Email ID: ");
        this.txtEmail = new Text(composite, 2048);
        this.txtEmail.setLayoutData((Object)new GridData(100, -1));
        this.txtEmail.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ForgetPasswordDialog.this.validatePage();
            }
        });
        this.txtEmail.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ForgetPasswordDialog.this.txtEmail.selectAll();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.LoginDialog_Server);
        this.combo1 = new Combo(composite, 8);
        int i = 0;
        while (i < this.serverNames.length) {
            this.combo1.add(this.serverNames[i]);
            ++i;
        }
        this.combo1.select(this.serverIdx);
        this.combo1.setLayoutData((Object)new GridData(85, -1));
        if (this.serverNames.length == 1) {
            this.combo1.setVisible(false);
            label.setVisible(false);
            this.combo1.select(0);
        }
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.createButton(buttonComposite, 0, "Submit", false);
        this.createButton(buttonComposite, 1, "Cancel", false);
        this.msgComposite = new Group(parent, 16);
        this.msgComposite.setLayout((Layout)new GridLayout());
        this.data = new GridData(4, 4, true, true, 4, 4);
        this.msgComposite.setLayoutData((Object)this.data);
        this.message = new Label(this.msgComposite, 0);
        this.message.setText("");
        this.forgotPasswordLink = new Link(this.msgComposite, 0);
        this.forgotPasswordLink.setText("");
        Display display = Display.getCurrent();
        this.red = display.getSystemColor(3);
        this.data.exclude = !this.data.exclude;
        this.msgComposite.setVisible(!this.data.exclude);
        parent.layout();
        return super.createDialogArea(parent);
    }

    private boolean forgotPasswordValidation() {
        block6: {
            block5: {
                try {
                    if (!this.userIdStr.equals("")) break block5;
                    MessageDialog.openError(null, (String)"Forgot Password", (String)"Please enter your user Id.");
                    this.txtUserId.setFocus();
                    return false;
                }
                catch (Exception exception) {}
            }
            if (!this.emailAddressStr.equals("")) break block6;
            MessageDialog.openError(null, (String)"Forgot Password", (String)"Please enter your email address.");
            this.txtEmail.setFocus();
            return false;
        }
        if (!this.emailAddressStr.contains("@") || this.emailAddressStr.length() <= 5) {
            MessageDialog.openError(null, (String)"Forgot Password", (String)"Please enter a valid email address.");
            this.txtEmail.setFocus();
            return false;
        }
        return true;
    }

    public void showMessage(String msg) {
        this.message.setForeground(this.red);
        this.data.exclude = false;
        this.msgComposite.setVisible(true);
        Display.getDefault().getActiveShell().setSize(485, 290);
    }

    protected void okPressed() {
        Cursor cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 1);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
        this.userIdStr = this.txtUserId.getText();
        this.emailAddressStr = this.txtEmail.getText();
        if (this.forgotPasswordValidation()) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!Resources.tcpLink) {
                        ForgetPasswordDialog.this.startMessageServerLink();
                    }
                    if (Resources.tcpLink) {
                        Resources.loginRejected = false;
                        Resources.respForgotPasswordResponse = null;
                        ForgetPasswordDialog.this.sendForgotPasswordMessage();
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                while (Resources.respForgotPasswordResponse == null) {
                                    try {
                                        Thread.sleep(200L);
                                    }
                                    catch (Exception exception) {}
                                }
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Resources.respForgotPasswordResponse.getAction() == 0) {
                                            ForgetPasswordDialog.this.cancelPressed();
                                            MessageDialog.openInformation(null, (String)"Information", (String)Resources.respForgotPasswordResponse.getRemarks());
                                        } else {
                                            ((this).this).ForgetPasswordDialog.this.message.setText(Resources.respForgotPasswordResponse.getRemarks());
                                            ForgetPasswordDialog.this.showMessage(Resources.respForgotPasswordResponse.getRemarks());
                                            Display.getDefault().getActiveShell().setSize(485, 295);
                                        }
                                    }
                                });
                            }
                        });
                    } else {
                        CorePlugin.closeSockets();
                    }
                }
            });
        }
        cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 0);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void validatePage() {
        if (this.txtUserId.getText().equals("")) {
            this.setErrorMessage("Please enter user id");
        } else if (this.txtEmail.getText().equals("")) {
            this.setErrorMessage("Please enter email adddress");
        } else if (!this.txtEmail.getText().contains("@") || this.txtEmail.getText().length() <= 5) {
            this.setErrorMessage(null);
        }
    }

    public int open() {
        this.create();
        this.setTitle("Forgot Password");
        this.setMessage("Please enter user id and email adddress");
        this.setTitleImage(null);
        return super.open();
    }

    protected void sendForgotPasswordMessage() {
        if (Resources.tradeLink != null) {
            ForgetPasswordRequest msg = new ForgetPasswordRequest(this.userIdStr.toUpperCase(), this.emailAddressStr.toUpperCase());
            Resources.sendToAllMS((Message)msg);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void startMessageServerLink() {
        Resources.clientLinks = new Hashtable<K, V>();
        Resources.msLinks = new HashMap<K, V>();
        host = "localhost";
        port = "6789";
        if (Resources.ipWebServicePath == null || Resources.ipWebServicePath.length() <= 0) ** GOTO lbl31
        msLinks = WebServiceUtil.getIpPort((String)this.txtUserId.getText());
        this.logger.info((Object)("MS links = " + (msLinks.length() > 200 ? msLinks.substring(0, 199) : msLinks)));
        if (msLinks == null || msLinks.equals("")) ** GOTO lbl29
        servers = msLinks.split("\\|");
        if (servers != null && servers.length > 0) {
            i = 0;
            while (i < servers.length) {
                ipPort = servers[i].split("\\:");
                if (ipPort != null && ipPort.length != 3) {
                    MessageDialog.openError(null, (String)"Invalid Server Configuration", (String)(String.valueOf(i) + "-Invalid configuration recieved from server = " + Arrays.toString(ipPort)));
                    return;
                }
                Resources.clientLinks.put(ipPort[0], String.valueOf(ipPort[1]) + ":" + (String)ipPort[2]);
                Resources.msLinks.put(String.valueOf(ipPort[1]) + ":" + (String)ipPort[2], null);
                ++i;
            }
            links = Resources.msLinks.size();
            CorePlugin.MS_CONNECTED = String.valueOf(links) + "/" + links + " MS Connected";
            CorePlugin.MS_NOT_CONNECTED = String.valueOf(links) + "/" + links + " MS Disconnected";
        } else {
            MessageDialog.openError(null, (String)"Invalid Format", (String)("Invalid format of MS configuration recieved from server = " + msLinks));
            return;
lbl29:
            // 1 sources

            MessageDialog.openError(null, (String)"Invalid Format", (String)("MS configuration not recieved from server = " + msLinks));
            return;
lbl31:
            // 1 sources

            host = this.serverHosts[this.combo1.getSelectionIndex()];
            port = this.serverPorts[this.combo1.getSelectionIndex()];
            Resources.clientLinks.put(this.txtUserId.getText(), String.valueOf(host) + ":" + port);
            Resources.msLinks.put(String.valueOf(host) + ":" + port, null);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int connected = 0;
                for (String ipPort : Resources.clientLinks.values()) {
                    if (Resources.msLinks.get(ipPort) != null) continue;
                    TCPLink link = new TCPLink(Resources.tradeQueue);
                    String[] arr = ipPort.split("\\:");
                    if (link.initTcpLink(arr[0], arr[1])) {
                        ForgetPasswordDialog.this.logger.info((Object)(String.valueOf(connected) + " MS link connected " + ipPort));
                        link.setName("MS Link " + connected);
                        Resources.msLinks.put(ipPort, link);
                        Resources.tradeLink = link;
                        ++connected;
                        continue;
                    }
                    MessageDialog.openError(null, (String)"Login Dialog", (String)("Unable to connect to " + ipPort));
                    Resources.tcpLink = false;
                    return;
                }
                Resources.tcpLink = true;
            }
        });
    }

    public String getUserId() {
        return this.txtUserId.getText();
    }

    public String getEmailAddress() {
        return this.txtEmail.getText();
    }
}

