/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import notification.INotification;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.ExchangeData;
import pk.com.softech.messages.FeedData;
import pk.com.softech.messages.INAV;
import pk.com.softech.messages.MBO;
import pk.com.softech.messages.MBP;
import pk.com.softech.messages.SymbolFeedData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.IFeed;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.Event;
import pk.com.softech.tradingterminal.core.db.History;
import pk.com.softech.tradingterminal.core.db.IntradayHistory;
import pk.com.softech.tradingterminal.core.db.LockedSecurity;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.PopupEvent;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.feed.FeedSource;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.core.internal.XMLRepository;
import pk.com.softech.tradingterminal.core.link.TerminalFileWriter;
import pk.com.softech.tradingterminal.core.notificationimpl.LockNotification;
import pk.com.softech.tradingterminal.kseServer.KSEServerPlugin;
import pk.com.softech.tradingterminal.trading.views.PortfolioWatch;
import pk.com.softech.util.Utility;

public class Feed
implements IFeed,
Runnable {
    private Map<String, Security> map = new HashMap<String, Security>();
    private Thread thread;
    private boolean stopping = false;
    private SimpleDateFormat exDateTimeParser = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleDateFormat usDateTimeParser = new SimpleDateFormat("MM/dd/yyyy h:mma");
    private SimpleDateFormat usDateParser = new SimpleDateFormat("MM/dd/yyyy");
    private SimpleDateFormat usTimeParser = new SimpleDateFormat("h:mma");
    private Log log = LogFactory.getLog(this.getClass());
    private TerminalFileWriter fileWriter = null;
    NumberFormat pf = CorePlugin.getPriceFormatter();
    DecimalFormat f = new DecimalFormat("#.00");

    public void subscribe(Security security) {
        if (security.getId() != null) {
            this.map.put(security.getId(), security);
        }
    }

    public void unSubscribe(Security security) {
        if (security.getId() != null) {
            this.map.remove(security.getId());
        }
    }

    public void start() {
        if (this.thread == null) {
            this.stopping = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
        if (Resources.feedDumpFile != null && !Resources.feedDumpFile.equals("")) {
            this.fileWriter = new TerminalFileWriter(Resources.feedDumpFile, true);
        }
    }

    public void stop() {
        this.stopping = true;
        if (this.thread != null) {
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException e) {
                this.log.error((Object)e, (Throwable)e);
            }
            this.thread = null;
        }
    }

    public void snapshot() {
        this.log.info((Object)"Snapshot update");
        boolean updateHistory = KSEServerPlugin.getDefault().getPreferenceStore().getBoolean("UPDATE_HISTORY");
        if (updateHistory) {
            this.updateHistory();
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            try {
                if (Resources.feedQueue != null) {
                    Object obj = Resources.feedQueue.remove();
                    String msg = "";
                    if (obj instanceof FeedData) {
                        try {
                            FeedData feed = (FeedData)obj;
                            SymbolFeedData symbolFeed = feed.getSymbolData();
                            ExchangeData exchangeData = feed.getExchangeData();
                            MBO mbo = feed.getMBO();
                            MBP mbp = feed.getMBP();
                            INAV inav = feed.getInav();
                            if (symbolFeed != null) {
                                msg = symbolFeed.formatString();
                                this.log.info((Object)("Feed Received : " + msg));
                            } else if (exchangeData != null) {
                                msg = exchangeData.getExchange().equalsIgnoreCase("GSE") ? exchangeData.formatString("") : exchangeData.formatString();
                            } else if (mbo != null) {
                                msg = mbo.formatString();
                            } else if (mbp != null) {
                                msg = mbp.formatString();
                            } else if (inav != null) {
                                msg = inav.formatString();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        msg = (String)obj;
                    }
                    if (this.fileWriter != null && msg.length() > 0) {
                        this.log.info((Object)("Feed Received : " + msg));
                        this.fileWriter.write(msg);
                    }
                    this.update(msg);
                    continue;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.error((Object)ex.getMessage());
            }
        }
    }

    private void update(String msg) {
        if (msg.indexOf("|") > -1 && msg.substring(0, msg.indexOf("|")).equals("MBO")) {
            this.log.debug((Object)("MBO Msg Type " + msg));
            if (Resources.MBOQueue != null) {
                Resources.MBOQueue.add((Object)msg);
            }
        } else if (msg.indexOf("|") > -1 && msg.substring(0, msg.indexOf("|")).equals("MBP")) {
            this.log.debug((Object)("MBP Msg Type " + msg));
            if (Resources.MBOQueue != null) {
                Resources.MBOQueue.add((Object)msg);
            }
        } else {
            String[] item = Utility.getTokens((String)msg, (String)",");
            if (item == null || item.length == 0) {
                return;
            }
            if (item[2].equals("INAV")) {
                String exchange = item[1];
                String calculationTime = item[4];
                String symbol = item[5];
                long inavVolume = Utility.parseLong((String)item[6], (int)0);
                Utility.parseDouble((String)item[7], (double)0.0);
                double inavValue = Utility.parseDouble((String)item[8], (double)0.0);
                String market = "REG";
                String id = String.valueOf(exchange) + "." + symbol + "(" + market + ")";
                Security security = this.map.get(id);
                if (security != null) {
                    Quote tempQuote = security.getQuote();
                    Quote newQuote = Quote.getQuoteShallow((Quote)tempQuote);
                    newQuote.setInavValue(inavValue);
                    newQuote.setInavVolume(inavVolume);
                    try {
                        newQuote.setInavCalculationTime(calculationTime);
                    }
                    catch (Exception exception) {}
                    security.setETFQuote(newQuote);
                } else {
                    security = CorePlugin.getRepository().getSecurity(exchange, market, symbol);
                    if (security != null && security.getSymbol().equals(symbol)) {
                        Quote tempQuote = security.getQuote();
                        Quote newQuote = Quote.getQuoteShallow((Quote)tempQuote);
                        newQuote.setInavValue(inavValue);
                        newQuote.setInavVolume(inavVolume);
                        try {
                            newQuote.setInavCalculationTime(calculationTime);
                        }
                        catch (Exception exception) {}
                        security.setETFQuote(newQuote);
                    }
                }
                if (security != null) {
                    security.getQuoteMonitor().notifyObservers((Object)security);
                }
            } else if (item[2].equals("LLT") || item[2].equals("LLM")) {
                try {
                    Double open = new Double(0.0);
                    Double high = null;
                    Double low = null;
                    Double close = null;
                    Double change = null;
                    Float average = null;
                    Quote quote = new Quote();
                    String direction = null;
                    String exchange = item[1];
                    String comments = item[3];
                    String symbol = item[4];
                    quote.setLast(Utility.parseDouble((String)item[5], (double)0.0));
                    quote.setVolume(Utility.parseLong((String)item[6], (int)0));
                    String market = item[7];
                    quote.setBid(Utility.parseDouble((String)item[8], (double)0.0));
                    quote.setAsk(Utility.parseDouble((String)item[9], (double)0.0));
                    quote.setBidSize(Utility.parseInt((String)item[10], (int)0));
                    quote.setAskSize(Utility.parseInt((String)item[11], (int)0));
                    close = new Double(Utility.parseDouble((String)item[12], (double)0.0));
                    long totalTurnover = Utility.parseLong((String)item[13], (int)0);
                    high = new Double(Utility.parseDouble((String)item[14], (double)0.0));
                    low = new Double(Utility.parseDouble((String)item[15], (double)0.0));
                    average = new Float(Utility.parseDouble((String)item[16], (double)0.0));
                    change = Utility.parseDouble((String)item[18], (double)0.0);
                    Double changePercentage = Resources.getChangePercentage((double)quote.getLast(), (double)change);
                    Double highPercentage = Resources.getHighPercentage((double)quote.getLast(), (double)high);
                    Double lowPercentage = Resources.getChangePercentage((double)quote.getLast(), (double)low);
                    String spot = item[19];
                    try {
                        quote.setDate(this.exDateTimeParser.parse(item[24]));
                    }
                    catch (Exception exception) {}
                    quote.setQuoteType(item[2]);
                    long totalTrades = Utility.parseLong((String)item[25], (int)0);
                    try {
                        open = Utility.parseDouble((String)item[26], (double)0.0);
                        direction = item[27];
                    }
                    catch (Exception exception) {}
                    String id = String.valueOf(exchange) + "." + symbol + "(" + market + ")";
                    Security security = this.map.get(id);
                    if (security != null) {
                        try {
                            Quote tempQuote = security.getQuote();
                            try {
                                quote.setInavVolume(tempQuote.getInavVolume());
                            }
                            catch (NullPointerException nullPointerException) {}
                            try {
                                quote.setInavValue(tempQuote.getInavValue());
                            }
                            catch (NullPointerException nullPointerException) {}
                            try {
                                quote.setInavCalculationTime(tempQuote.getInavCalculationTime());
                            }
                            catch (NullPointerException nullPointerException) {}
                            this.updateIntradayHistory(security, quote);
                            this.updateHistory(security, quote);
                        }
                        catch (NullPointerException nullPointerException) {}
                    } else {
                        security = CorePlugin.getRepository().getSecurity(exchange, market, symbol);
                        if (security == null) {
                            if (CorePlugin.getDefault().getPreferenceStore().getBoolean("ADD_NEW_SECURITIES_AUTOMATIC")) {
                                security = new Security();
                                security.setId(String.valueOf(exchange) + "." + symbol + "(" + market + ")");
                                security.setExchange(exchange);
                                security.setSymbol(symbol);
                                security.setMarket(market);
                                security.setDescription(symbol);
                                security.setSector("MISCELLANEOUS");
                                security.setCurrency(Currency.getInstance("PKR"));
                                security.setBeginTime(0);
                                security.setEndTime(0);
                                security.setWeekDays(62);
                                security.setKeepDays(1);
                                security.setEnableDataCollector(true);
                                security.setUp(0L);
                                security.setDown(0L);
                                security.setEqual(0L);
                                security.setMaximumVolume(500000);
                                security.setMaximumValue(2.5E7);
                                security.setLotSize(1);
                                FeedSource feed = new FeedSource();
                                feed.setSymbol(symbol);
                                feed.setExchange(exchange);
                                feed.setId("pk.com.softech.tradingterminal.kseServer");
                                security.setQuoteFeed(feed);
                                feed = new FeedSource();
                                feed.setSymbol(symbol);
                                feed.setExchange(exchange);
                                feed.setId("pk.com.softech.tradingterminal.kseServer");
                                security.setLevel2Feed(feed);
                                feed = new FeedSource();
                                feed.setSymbol(symbol);
                                feed.setExchange(exchange);
                                feed.setId("pk.com.softech.tradingterminal.kseServer");
                                security.setHistoryFeed(feed);
                                ((XMLRepository)CorePlugin.getRepository()).addSecurity(security);
                            }
                        } else {
                            try {
                                Quote tempQuote = security.getQuote();
                                try {
                                    quote.setInavVolume(tempQuote.getInavVolume());
                                }
                                catch (NullPointerException nullPointerException) {}
                                try {
                                    quote.setInavValue(tempQuote.getInavValue());
                                }
                                catch (NullPointerException nullPointerException) {}
                                try {
                                    quote.setInavCalculationTime(tempQuote.getInavCalculationTime());
                                }
                                catch (NullPointerException nullPointerException) {}
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                    }
                    if (security != null) {
                        security.setQuote(quote, open, high, low, close);
                        security.setCurrentIndex(Double.valueOf(quote.getLast()));
                        security.setTotalTurnover(totalTurnover);
                        security.setAverage(average.floatValue());
                        security.setChange(change);
                        security.setChangePerc(changePercentage);
                        security.setHighPerc(highPercentage);
                        security.setLowPerc(lowPercentage);
                        security.setComment(comments);
                        security.setSpot(spot);
                        security.setTotalTrades(totalTrades);
                        security.setDirection(direction);
                        security.getQuoteMonitor().notifyObservers((Object)security);
                        this.updateLockedSymbols(security);
                        this.updatePortfolioWatch(security);
                        this.updatePortfolioPositionWatch(security);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.info((Object)("Exception in Trade Msg Feed : " + e));
                }
            } else if (item[2].equals("LLS")) {
                String exchMarket = "EXCH";
                Double open = null;
                Double high = null;
                Double low = null;
                Double close = null;
                Double current = null;
                Double last = null;
                Double change = null;
                Double changePerc = null;
                Quote quote = new Quote();
                long denominator = 0L;
                long multiplier = 0L;
                open = new Double(0.0);
                close = new Double(0.0);
                try {
                    long equal;
                    long down;
                    long up;
                    String exchange = item[1];
                    try {
                        quote.setDate(this.exDateTimeParser.parse(item[3]));
                    }
                    catch (Exception exception) {}
                    current = new Double(Utility.parseDouble((String)item[4], (double)0.0));
                    high = new Double(Utility.parseDouble((String)item[5], (double)0.0));
                    low = new Double(Utility.parseDouble((String)item[6], (double)0.0));
                    last = new Double(Utility.parseDouble((String)item[7], (double)0.0));
                    long totalTrades = Utility.parseLong((String)item[8], (int)0);
                    long totalTurnover = Utility.parseLong((String)item[9], (int)0);
                    long monetaryValue = Utility.parseLong((String)item[10], (int)0);
                    quote.setVolume(0L);
                    if (exchange.equalsIgnoreCase("GSE")) {
                        this.log.info((Object)("Exchange : " + exchange));
                        denominator = Utility.parseLong((String)item[11], (int)0);
                        multiplier = Utility.parseLong((String)item[12], (int)0);
                        change = new Double(Utility.parseDouble((String)item[13], (double)0.0));
                        up = 0L;
                        down = 0L;
                        equal = 0L;
                    } else {
                        up = Utility.parseLong((String)item[11], (int)0);
                        down = Utility.parseLong((String)item[12], (int)0);
                        equal = Utility.parseLong((String)item[13], (int)0);
                        change = current - last;
                    }
                    String symbol = item[14];
                    quote.setLast(last.doubleValue());
                    changePerc = Resources.getChangePercentage((double)current, (double)change);
                    quote.setBid(0.0);
                    quote.setBidSize(0);
                    quote.setAsk(0.0);
                    quote.setAskSize(0);
                    String id = String.valueOf(exchange) + "." + symbol + "(" + exchMarket + ")";
                    Security security = this.map.get(id);
                    if (security != null) {
                        try {
                            Quote tempQuote = security.getQuote();
                            try {
                                quote.setInavVolume(tempQuote.getInavVolume());
                            }
                            catch (NullPointerException nullPointerException) {}
                            try {
                                quote.setInavValue(tempQuote.getInavValue());
                            }
                            catch (NullPointerException nullPointerException) {}
                            try {
                                quote.setInavCalculationTime(tempQuote.getInavCalculationTime());
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                        catch (NullPointerException nullPointerException) {}
                        security.setQuote(quote, open, high, low, close);
                        security.setCurrentIndex(current);
                        security.setChange(change);
                        security.setChangePerc(changePerc);
                        security.setUp(up);
                        security.setDown(down);
                        security.setEqual(equal);
                        security.setTotalTrades(totalTrades);
                        security.setTotalTurnover(totalTurnover);
                        security.setMonetaryValue(monetaryValue);
                        if (exchange.equalsIgnoreCase("GSE")) {
                            security.setMultiplier(multiplier);
                            security.setDenominator(denominator);
                        }
                        this.updateIntradayHistory(security, quote);
                        this.updateHistory(security, quote);
                    } else {
                        security = CorePlugin.getRepository().getSecurity(exchange, exchMarket, symbol);
                        if (security != null && security.getSymbol().equals(symbol) && security.getMarket().equals(exchMarket) && security.getExchange().equals(exchange)) {
                            try {
                                Quote tempQuote = security.getQuote();
                                try {
                                    quote.setInavVolume(tempQuote.getInavVolume());
                                }
                                catch (NullPointerException nullPointerException) {}
                                try {
                                    quote.setInavValue(tempQuote.getInavValue());
                                }
                                catch (NullPointerException nullPointerException) {}
                                try {
                                    quote.setInavCalculationTime(tempQuote.getInavCalculationTime());
                                }
                                catch (NullPointerException nullPointerException) {}
                            }
                            catch (NullPointerException nullPointerException) {}
                            security.setQuote(quote, open, high, low, close);
                            security.setCurrentIndex(current);
                            security.setChange(change);
                            security.setChangePerc(changePerc);
                            security.setUp(up);
                            security.setDown(down);
                            security.setEqual(equal);
                            security.setTotalTrades(totalTrades);
                            security.setTotalTurnover(totalTurnover);
                            security.setMonetaryValue(monetaryValue);
                            if (exchange.equalsIgnoreCase("GSE")) {
                                security.setMultiplier(multiplier);
                                security.setDenominator(denominator);
                            }
                        }
                    }
                    if (security != null) {
                        security.getQuoteMonitor().notifyObservers((Object)security);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.info((Object)("Exception in Exchange Feed " + e));
                }
            }
        }
    }

    private synchronized void updateLockedSymbols(Security security) {
        double tradePrice = -1.0;
        double bid = -1.0;
        double ask = -1.0;
        tradePrice = security.getQuote().getLast();
        bid = security.getQuote().getBid();
        ask = security.getQuote().getAsk();
        int position = this.contains(security.getMarket(), security.getSymbol());
        String upperLimit = this.f.format(security.getUpperLimit());
        String LowerLimit = this.f.format(security.getLowerLimit());
        String bidStr = this.f.format(bid);
        String askStr = this.f.format(ask);
        if (tradePrice != -1.0) {
            if ((bid == 0.0 || bid == 0.0) && askStr.equalsIgnoreCase(LowerLimit)) {
                if (position == -1) {
                    this.addLowerLockedSymbol(security);
                } else {
                    LockedSecurity lockedSecurity = (LockedSecurity)CorePlugin.getRepository().allLockedSymbols().get(position);
                    lockedSecurity.setDate(security.getQuote().getDate());
                    lockedSecurity.setLastPrice("" + tradePrice);
                    lockedSecurity.setVolume((long)security.getQuote().getAskSize());
                    lockedSecurity.setChanged();
                    lockedSecurity.notifyObservers();
                }
            } else if ((ask == 0.0 || ask == 0.0) && bidStr.equalsIgnoreCase(upperLimit)) {
                if (position == -1) {
                    this.addUpperLockedSymbol(security);
                } else {
                    LockedSecurity lockedSecurity = (LockedSecurity)CorePlugin.getRepository().allLockedSymbols().get(position);
                    lockedSecurity.setDate(security.getQuote().getDate());
                    lockedSecurity.setLastPrice("" + tradePrice);
                    lockedSecurity.setVolume((long)security.getQuote().getBidSize());
                    lockedSecurity.setChanged();
                    lockedSecurity.notifyObservers();
                }
            } else if (position != -1) {
                LockedSecurity sec = (LockedSecurity)CorePlugin.getRepository().allLockedSymbols().get(position);
                CorePlugin.getRepository().allLockedSymbols().remove(position);
                this.addToEvent(security, sec.isUpperLocked(), false);
            }
        }
    }

    private void addLowerLockedSymbol(Security security) {
        LockedSecurity lockedSecurity = new LockedSecurity(security.getMarket(), security.getSymbol(), (long)security.getQuote().getAskSize(), String.valueOf(security.getQuote().getLast()), security.getQuote().getDate(), false);
        CorePlugin.getRepository().allLockedSymbols().add((Object)lockedSecurity);
        this.addToEvent(security, false, true);
    }

    private void addUpperLockedSymbol(Security security) {
        LockedSecurity lockedSecurity = new LockedSecurity(security.getMarket(), security.getSymbol(), (long)security.getQuote().getBidSize(), String.valueOf(security.getQuote().getLast()), security.getQuote().getDate(), true);
        CorePlugin.getRepository().allLockedSymbols().add((Object)lockedSecurity);
        this.addToEvent(security, true, true);
    }

    private void addToEvent(Security security, boolean upperLock, boolean added) {
        String addOrRemove = "";
        addOrRemove = added ? "added to " : "removed from ";
        String message = "";
        message = upperLock ? String.valueOf(security.getComment()) + ". Upper Lock " + addOrRemove + security.getMarket() + "." + security.getSymbol() + " at " + security.getQuote().getBid() : String.valueOf(security.getComment()) + ". Lower Lock " + addOrRemove + security.getMarket() + "." + security.getSymbol() + " at " + security.getQuote().getAsk();
        int event_type = 9;
        event_type = upperLock && added ? 6 : (!upperLock && added ? 7 : 8);
        if (CorePlugin.getDefault().getPreferenceStore().getBoolean("LOCKED_ADD_TO_EVENTS_BOOL ")) {
            Object event = null;
            event = CorePlugin.getDefault().getPreferenceStore().getBoolean("LOCKED_POPUP_BOOL") ? new PopupEvent(new Integer(CorePlugin.getRepository().allEvents().size() + 1).toString()) : new Event();
            try {
                event.setSecurity(security);
            }
            catch (Exception exception) {}
            event.setMessage(message);
            event.setLongMessage(message);
            event.setEvent_type(event_type);
            CorePlugin.getRepository().save((PersistentObject)event);
        }
        if (CorePlugin.getDefault().getPreferenceStore().getBoolean("LOCKED_NOTIFICATION_ALERT_BOOL")) {
            LockNotification notification = new LockNotification("Symbol Lock", "Remarks : " + message, event_type);
            CorePlugin.getDefault().triggerNofication((INotification)notification);
        }
    }

    private int contains(String market, String symbol) {
        int poistion = -1;
        ObservableList list = CorePlugin.getRepository().allLockedSymbols();
        int i = 0;
        while (i < list.size()) {
            LockedSecurity lockedSecurity = (LockedSecurity)list.get(i);
            if (lockedSecurity.getMarket().equals(market) && lockedSecurity.getSymbol().equals(symbol)) {
                poistion = i;
                break;
            }
            ++i;
        }
        return poistion;
    }

    private String stripQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected void updateHistory() {
        for (Security security : this.map.keySet()) {
            this.updateHistory(security, security.getQuote());
        }
    }

    protected void updateHistory(Security security, Quote quote) {
        History history = security.getHistory();
        if (quote.getDate() != null && history != null && !history.isEmpty()) {
            Calendar currentFeedDate = Calendar.getInstance();
            currentFeedDate.setTime(quote.getDate());
            currentFeedDate = new GregorianCalendar(currentFeedDate.get(1), currentFeedDate.get(2), currentFeedDate.get(5));
            Bar lastBar = history.get(history.size() - 1);
            Calendar lastBarDate = Calendar.getInstance();
            lastBarDate.setTime(lastBar.getDate());
            Calendar.getInstance();
            if (currentFeedDate.getTime().after(lastBarDate.getTime())) {
                Bar bar = new Bar();
                bar.setDate(currentFeedDate.getTime());
                bar.setOpen(security.getOpen().doubleValue());
                bar.setHigh(security.getHigh().doubleValue());
                bar.setLow(security.getLow().doubleValue());
                bar.setClose(quote.getLast());
                bar.setVolume(quote.getVolume());
                history.add(bar);
                CorePlugin.getRepository().save((PersistentObject)history);
            }
        }
    }

    protected void updateIntradayHistory(Security security, Quote quote) {
        IntradayHistory history = security.getIntradayHistory();
        if (quote.getDate() != null && !history.isEmpty()) {
            Calendar quoteCalendar = Calendar.getInstance();
            quoteCalendar.setTime(quote.getDate());
            Bar lastBar = history.get(history.size() - 1);
            Calendar lastBarDate = Calendar.getInstance();
            lastBarDate.setTime(lastBar.getDate());
            Calendar securityEndTime = Calendar.getInstance();
            securityEndTime.setTime(quote.getDate());
            securityEndTime.set(11, security.getEndTime() / 60);
            securityEndTime.set(12, security.getEndTime() % 60);
            securityEndTime.set(13, 0);
            securityEndTime.set(14, 0);
            Calendar.getInstance();
            if (quoteCalendar.getTime().after(lastBarDate.getTime())) {
                Bar bar = new Bar();
                bar.setDate(quoteCalendar.getTime());
                bar.setOpen(security.getOpen().doubleValue());
                bar.setHigh(security.getHigh().doubleValue());
                bar.setLow(security.getLow().doubleValue());
                bar.setClose(quote.getLast());
                bar.setVolume(quote.getVolume());
                history.add(bar);
                CorePlugin.getRepository().save((PersistentObject)history);
            }
        } else if (quote.getDate() != null && history != null) {
            Calendar quoteCalendar = Calendar.getInstance();
            quoteCalendar.setTime(quote.getDate());
            Calendar.getInstance();
            Bar bar = new Bar();
            bar.setDate(quoteCalendar.getTime());
            bar.setOpen(security.getOpen().doubleValue());
            bar.setHigh(security.getHigh().doubleValue());
            bar.setLow(security.getLow().doubleValue());
            bar.setClose(quote.getLast());
            bar.setVolume(quote.getVolume());
            history.add(bar);
            CorePlugin.getRepository().save((PersistentObject)history);
        }
        security.setChanged();
    }

    private int containsPortfolioWatch(String market, String symbol) {
        int poistion = -1;
        ObservableList list = CorePlugin.getRepository().allSecurityPortfolio();
        int i = 0;
        while (i < list.size()) {
            Security portfolioSecurity = (Security)list.get(i);
            if (portfolioSecurity != null && portfolioSecurity.getMarket().equals(market) && portfolioSecurity.getSymbol().equals(symbol)) {
                poistion = i;
                break;
            }
            ++i;
        }
        return poistion;
    }

    private synchronized void updatePortfolioWatch(Security security) {
        int position = this.containsPortfolioWatch(security.getMarket(), security.getSymbol());
        if (position != -1) {
            final Security OldSecurity = (Security)CorePlugin.getRepository().allSecurityPortfolio().get(position);
            OldSecurity.setMarket(security.getMarket());
            OldSecurity.setSymbol(security.getSymbol());
            OldSecurity.setQuote(security.getQuote());
            OldSecurity.setChange(security.getChange());
            OldSecurity.setTotalTurnover(security.getTotalTurnover());
            OldSecurity.setTotalTrades(security.getTotalTrades());
            OldSecurity.setOpen(security.getOpen());
            OldSecurity.setClose(security.getClose());
            OldSecurity.setLow(security.getLow());
            OldSecurity.setHigh(security.getHigh());
            OldSecurity.setLowerLimit(security.getLowerLimit());
            OldSecurity.setUpperLimit(security.getUpperLimit());
            OldSecurity.setSector(security.getSector());
            OldSecurity.setDescription(security.getDescription());
            OldSecurity.notifyObservers();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("pk.com.softech.tradingterminal.trading.portfolioWatch");
                        if (view != null) {
                            ((PortfolioWatch)view).update(OldSecurity);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private int containsOpeningPortfolioWatch(String market, String symbol) {
        int poistion = -1;
        ObservableList list = CorePlugin.getRepository().allSecurityPositionPortfolio();
        int i = 0;
        while (i < list.size()) {
            Security portfolioSecurity = (Security)list.get(i);
            if (portfolioSecurity != null && portfolioSecurity.getMarket().equals(market) && portfolioSecurity.getSymbol().equals(symbol)) {
                poistion = i;
                break;
            }
            ++i;
        }
        return poistion;
    }

    private synchronized void updatePortfolioPositionWatch(Security security) {
        int position = this.containsOpeningPortfolioWatch(security.getMarket(), security.getSymbol());
        if (position != -1) {
            final Security OldSecurity = (Security)CorePlugin.getRepository().allSecurityPositionPortfolio().get(position);
            OldSecurity.setMarket(security.getMarket());
            OldSecurity.setSymbol(security.getSymbol());
            OldSecurity.setQuote(security.getQuote());
            OldSecurity.setChange(security.getChange());
            OldSecurity.setTotalTurnover(security.getTotalTurnover());
            OldSecurity.setTotalTrades(security.getTotalTrades());
            OldSecurity.setOpen(security.getOpen());
            OldSecurity.setClose(security.getClose());
            OldSecurity.setLow(security.getLow());
            OldSecurity.setHigh(security.getHigh());
            OldSecurity.setLowerLimit(security.getLowerLimit());
            OldSecurity.setUpperLimit(security.getUpperLimit());
            OldSecurity.setSector(security.getSector());
            OldSecurity.setDescription(security.getDescription());
            OldSecurity.notifyObservers();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("pk.com.softech.tradingterminal.trading.portfolioWatch");
                        if (view != null) {
                            ((PortfolioWatch)view).updatePosition(OldSecurity);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

