/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.kseServer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.util.NumberVerifyListener;
import pk.com.softech.tradingterminal.kseServer.KSEServerPlugin;
import pk.com.softech.util.WebServiceUtil;

public class ClientRegistrationDialog
extends TitleAreaDialog {
    Text txtUserName;
    Text txtMobNo;
    Text txtEmailId;
    Log logger = LogFactory.getLog((String)ClientRegistrationDialog.class.getName());
    private Image image = KSEServerPlugin.getImageDescriptor("icons/key.gif").createImage();

    public ClientRegistrationDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    public ClientRegistrationDialog(String[] connStrings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Client Registration");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData data1 = new GridData(100, -1);
        GridData data = new GridData(200, -1);
        Label label = new Label(composite, 0);
        label.setText("Name");
        label.setLayoutData((Object)data1);
        this.txtUserName = new Text(composite, 2048);
        this.txtUserName.setLayoutData((Object)data);
        this.txtUserName.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ClientRegistrationDialog.this.validation();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        label = new Label(composite, 0);
        label.setLayoutData((Object)data1);
        label.setText("Contact No");
        this.txtMobNo = new Text(composite, 2048);
        this.txtMobNo.setLayoutData((Object)data);
        this.txtMobNo.setTextLimit(11);
        this.txtMobNo.addVerifyListener((VerifyListener)new NumberVerifyListener());
        this.txtMobNo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ClientRegistrationDialog.this.validation();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        label = new Label(composite, 0);
        label.setLayoutData((Object)data1);
        label.setText("Email Address");
        this.txtEmailId = new Text(composite, 2048);
        this.txtEmailId.setLayoutData((Object)data);
        this.txtEmailId.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ClientRegistrationDialog.this.validation();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return super.createDialogArea(parent);
    }

    public int open() {
        this.create();
        this.setTitleImage(this.image);
        this.getButton(0).setText("Register");
        this.validation();
        return super.open();
    }

    protected void okPressed() {
        Cursor cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 1);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                String resp = WebServiceUtil.registerUser((String)ClientRegistrationDialog.this.txtUserName.getText(), (String)ClientRegistrationDialog.this.txtMobNo.getText(), (String)ClientRegistrationDialog.this.txtEmailId.getText());
                MessageDialog.openInformation(null, (String)"User Registration", (String)resp);
            }
        });
        cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 0);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void validation() {
        String email_pattern = "(([\\w-_\\.+])*[\\w-_\\.]\\@([\\w]+\\.)+[\\w][\\w]+)";
        this.getButton(0).setEnabled(false);
        if (this.txtUserName.getText().trim().equals("")) {
            this.setErrorMessage("Please enter your name");
        } else if (this.txtUserName.getText().length() > 30) {
            this.setErrorMessage("User name can be maximam 30 characters long");
        } else if (this.txtMobNo.getText().trim().equals("")) {
            this.setErrorMessage("Please enter your contact number.\ne.g Mobile Mobile (03001122333) or PTCL (04231122333)");
        } else if (this.txtMobNo.getText().length() < 10) {
            this.setErrorMessage("Invalid contact number format. \nExpected Mobile (03001122333) or PTCL (04231122333)");
        } else if (this.txtEmailId.getText().trim().equals("")) {
            this.setErrorMessage("Please enter your email");
        } else if (!this.txtEmailId.getText().matches(email_pattern)) {
            this.setErrorMessage("Please enter a valid email address");
        } else if (this.txtEmailId.getText().length() > 50) {
            this.setErrorMessage("Email Id can be maximam 50 characters long");
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage("Press register button to create your free account.", 1);
        }
    }
}

