/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.charts.repository;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.charts.repository.IChartVisitor;
import org.eclipsetrader.core.charts.repository.IElementSection;
import org.eclipsetrader.core.charts.repository.ISecuritySection;
import org.eclipsetrader.core.internal.charts.repository.ElementSection;
import org.eclipsetrader.core.internal.charts.repository.ElementSectionAdapter;
import org.eclipsetrader.core.internal.markets.SecurityAdapter;
import pk.com.softech.tradingterminal.core.db.Security;

@XmlRootElement(name="security")
public class SecuritySection
implements ISecuritySection {
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private Security securityy;
    @XmlElement(name="indicator")
    @XmlJavaTypeAdapter(value=ElementSectionAdapter.class)
    private List<IElementSection> indicators;

    protected SecuritySection() {
    }

    protected SecuritySection(ISecuritySection section) {
        this.securityy = section.getSecurity();
        this.indicators = section.getIndicators() != null ? Arrays.asList(section.getIndicators()) : null;
    }

    public SecuritySection(Security security) {
        this.securityy = security;
    }

    @Override
    @XmlTransient
    public Security getSecurity() {
        return this.securityy;
    }

    @Override
    @XmlTransient
    public IElementSection[] getIndicators() {
        return this.indicators.toArray(new ElementSection[this.indicators.size()]);
    }

    @Override
    public void setIndicators(IElementSection[] indicators) {
        this.indicators = indicators != null ? Arrays.asList(indicators) : null;
    }

    @Override
    public void accept(IChartVisitor visitor) {
        if (visitor.visit(this)) {
            IElementSection[] d = this.getIndicators();
            int i = 0;
            while (i < d.length) {
                d[i].accept(visitor);
                ++i;
            }
        }
    }
}

