/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.charts;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.IDataSeriesVisitor;
import org.eclipsetrader.core.charts.VolumeValueWrapper;
import org.eclipsetrader.core.feed.IOHLC;

public class VolumeDataSeries
implements IDataSeries {
    private String name;
    private IAdaptable first;
    private IAdaptable last;
    private IAdaptable highest;
    private IAdaptable lowest;
    private IAdaptable[] values;
    private Long lowestValue;
    private Long highestValue;
    private Date firstValue;
    private Date lastValue;

    public VolumeDataSeries(String name, IAdaptable[] values) {
        this.name = name;
        this.values = new IAdaptable[values.length];
        int i = 0;
        while (i < values.length) {
            IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
            this.values[i] = new VolumeValueWrapper(ohlc);
            this.updateHighestLowest(ohlc.getVolume(), this.values[i]);
            if (ohlc.getDate() != null) {
                this.updateFirstLast(ohlc.getDate(), this.values[i]);
            }
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IAdaptable getFirst() {
        return this.first;
    }

    @Override
    public IAdaptable getLast() {
        return this.last;
    }

    @Override
    public IAdaptable getHighest() {
        return this.highest;
    }

    @Override
    public IAdaptable getLowest() {
        return this.lowest;
    }

    @Override
    public IAdaptable[] getValues() {
        return this.values;
    }

    @Override
    public IDataSeries getSeries(IAdaptable first, IAdaptable last) {
        return new DataSeries(this.getName(), this.getSubset(first, last));
    }

    protected IAdaptable[] getSubset(IAdaptable first, IAdaptable last) {
        Date firstValue = first != null ? (Date)first.getAdapter(Date.class) : null;
        Date lastValue = last != null ? (Date)last.getAdapter(Date.class) : null;
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>(this.values.length);
        IAdaptable[] iAdaptableArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable v = iAdaptableArray[n2];
            Date date = (Date)v.getAdapter(Date.class);
            if (!(firstValue != null && date.before(firstValue) || lastValue != null && date.after(lastValue))) {
                list.add(v);
            }
            ++n2;
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    @Override
    public boolean isHighestOverride() {
        return false;
    }

    @Override
    public boolean isLowestOverride() {
        return false;
    }

    @Override
    public IDataSeries[] getChildren() {
        return new IDataSeries[0];
    }

    @Override
    public void setChildren(IDataSeries[] childrens) {
    }

    @Override
    public void accept(IDataSeriesVisitor visitor) {
        visitor.visit(this);
    }

    private void updateHighestLowest(Long value, IAdaptable reference) {
        if (this.lowestValue == null || value < this.lowestValue) {
            this.lowestValue = value;
            this.lowest = reference;
        }
        if (this.highestValue == null || value > this.highestValue) {
            this.highestValue = value;
            this.highest = reference;
        }
    }

    private void updateFirstLast(Date date, IAdaptable reference) {
        if (this.firstValue == null || date.before(this.firstValue)) {
            this.firstValue = date;
            this.first = reference;
        }
        if (this.lastValue == null || date.after(this.lastValue)) {
            this.lastValue = date;
            this.last = reference;
        }
    }
}

