/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.charts;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.IDataSeriesVisitor;
import org.eclipsetrader.core.feed.IOHLC;

public class DataSeries
implements IDataSeries {
    private String name;
    private IAdaptable first;
    private IAdaptable last;
    private IAdaptable highest;
    private IAdaptable lowest;
    private IAdaptable[] values;
    private IDataSeries[] childrens;
    private boolean highestOverride = false;
    private boolean lowestOverride = false;

    public DataSeries(String name, IAdaptable[] values) {
        this.name = name;
        this.values = values;
        this.accept(new RangeVisitor());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IAdaptable getFirst() {
        return this.first;
    }

    @Override
    public IAdaptable getLast() {
        return this.last;
    }

    @Override
    public IAdaptable getHighest() {
        return this.highest;
    }

    @Override
    public boolean isHighestOverride() {
        return this.highestOverride;
    }

    public void setHighest(IAdaptable highest) {
        this.highest = highest;
        this.highestOverride = true;
    }

    @Override
    public IAdaptable getLowest() {
        return this.lowest;
    }

    @Override
    public boolean isLowestOverride() {
        return this.lowestOverride;
    }

    public void setLowest(IAdaptable lowest) {
        this.lowest = lowest;
        this.lowestOverride = true;
    }

    @Override
    public IAdaptable[] getValues() {
        return this.values;
    }

    @Override
    public IDataSeries getSeries(IAdaptable first, IAdaptable last) {
        DataSeries series = new DataSeries(this.getName(), this.getSubset(first, last));
        if (this.isHighestOverride()) {
            series.setHighest(this.getHighest());
        }
        if (this.isLowestOverride()) {
            series.setLowest(this.getLowest());
        }
        return series;
    }

    protected IAdaptable[] getSubset(IAdaptable first, IAdaptable last) {
        Date firstValue = first != null ? (Date)first.getAdapter(Date.class) : null;
        Date lastValue = last != null ? (Date)last.getAdapter(Date.class) : null;
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>(this.values.length);
        IAdaptable[] iAdaptableArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable v = iAdaptableArray[n2];
            Date date = (Date)v.getAdapter(Date.class);
            if (!(firstValue != null && date.before(firstValue) || lastValue != null && date.after(lastValue))) {
                list.add(v);
            }
            ++n2;
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    @Override
    public IDataSeries[] getChildren() {
        return this.childrens;
    }

    @Override
    public void setChildren(IDataSeries[] childrens) {
        this.childrens = childrens;
        this.first = null;
        this.last = null;
        this.highest = null;
        this.lowest = null;
        this.accept(new RangeVisitor());
    }

    @Override
    public void accept(IDataSeriesVisitor visitor) {
        if (visitor.visit(this) && this.childrens != null) {
            int i = 0;
            while (i < this.childrens.length) {
                this.childrens[i].accept(visitor);
                ++i;
            }
        }
    }

    private class RangeVisitor
    implements IDataSeriesVisitor {
        private Double lowestValue;
        private Double highestValue;
        private Date firstValue;
        private Date lastValue;

        @Override
        public boolean visit(IDataSeries data) {
            IAdaptable[] iAdaptableArray = data.getValues();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable v = iAdaptableArray[n2];
                IOHLC ohlc = (IOHLC)v.getAdapter(IOHLC.class);
                if (ohlc != null) {
                    this.updateHighestLowest(ohlc.getLow() != null ? ohlc.getLow() : ohlc.getClose(), v);
                    this.updateHighestLowest(ohlc.getHigh() != null ? ohlc.getHigh() : ohlc.getClose(), v);
                    if (ohlc.getDate() != null) {
                        this.updateFirstLast(ohlc.getDate(), v);
                    }
                } else {
                    Number value = (Number)v.getAdapter(Number.class);
                    this.updateHighestLowest(value, v);
                    Date date = (Date)v.getAdapter(Date.class);
                    if (date != null) {
                        this.updateFirstLast(date, v);
                    }
                }
                ++n2;
            }
            if (data.isHighestOverride()) {
                DataSeries.this.highest = data.getHighest();
            }
            if (data.isLowestOverride()) {
                DataSeries.this.lowest = data.getLowest();
            }
            return true;
        }

        private void updateHighestLowest(Number value, IAdaptable reference) {
            if (this.lowestValue == null || value.doubleValue() < this.lowestValue) {
                this.lowestValue = value.doubleValue();
                DataSeries.this.lowest = reference;
            }
            if (this.highestValue == null || value.doubleValue() > this.highestValue) {
                this.highestValue = value.doubleValue();
                DataSeries.this.highest = reference;
            }
        }

        private void updateFirstLast(Date date, IAdaptable reference) {
            if (this.firstValue == null || date.before(this.firstValue)) {
                this.firstValue = date;
                DataSeries.this.first = reference;
            }
            if (this.lastValue == null || date.after(this.lastValue)) {
                this.lastValue = date;
                DataSeries.this.last = reference;
            }
        }
    }
}

