/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.util;

import javaxt.webservices.Method;
import javaxt.webservices.Parameter;
import javaxt.webservices.Parameters;
import javaxt.webservices.Service;
import javaxt.webservices.SoapRequest;
import javaxt.webservices.WSDL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pk.com.softech.tradingterminal.core.Resources;

public class WebServiceUtil {
    static Log logger = LogFactory.getLog((String)WebServiceUtil.class.getName());

    public static void listAllMethods() {
        WSDL wsdl = new WSDL(Resources.ipWebServicePath);
        Service[] serviceArray = wsdl.getServices();
        int n = serviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            System.out.println("------------------------");
            System.out.println(String.valueOf(service.getName()) + " Service");
            System.out.println("------------------------");
            Method[] methodArray = service.getMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                System.out.println(" + " + method.getName());
                Parameters parameters = method.getParameters();
                if (parameters != null) {
                    Parameter[] parameterArray = parameters.getArray();
                    int n5 = parameterArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Parameter parameter = parameterArray[n6];
                        System.out.println("  - " + parameter.getName() + " (" + parameter.getType() + ")");
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static String getIP() {
        String ip = "";
        try {
            WSDL wsdl = new WSDL(Resources.ipWebServicePath);
            Service service = wsdl.getServices()[0];
            Method method = service.getMethod("getIP");
            Parameters parameters = method.getParameters();
            SoapRequest soap = new SoapRequest(service, method, (Object)parameters);
            ip = soap.getResponse().toString();
            System.out.println("IP is " + ip);
        }
        catch (Exception e) {
            e.printStackTrace();
            ip = "Unable to get IP and Port from given web service. Check your web service path. " + e.getMessage();
            logger.error((Object)"Error while getting ip:port from web service : ", (Throwable)e);
        }
        return ip;
    }

    public static String getIpPort(String userId) {
        String ipPort = "";
        try {
            WSDL wsdl = new WSDL(Resources.ipWebServicePath);
            Service service = wsdl.getServices()[0];
            Method method = service.getMethod("getServerInfoFromUserId");
            Parameters parameters = method.getParameters();
            parameters.setValue("userId", userId);
            SoapRequest soap = new SoapRequest(service, method, (Object)parameters);
            ipPort = soap.getResponse().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
            ipPort = "Unable to get IP and Port from given web service. Check your web service path. " + e.getMessage();
            logger.error((Object)"Error while getting ip:port from web service : ", (Throwable)e);
        }
        return ipPort;
    }

    public static String registerUser(String clientName, String mobileNo, String emailId) {
        String response = "";
        try {
            WSDL wsdl = new WSDL(Resources.registrationWebServicePath);
            Service service = wsdl.getServices()[0];
            Method method = service.getMethod("registerUser");
            Parameters parameters = method.getParameters();
            parameters.setValue("clientName", clientName);
            parameters.setValue("mobileNo", mobileNo);
            parameters.setValue("emailId", emailId);
            SoapRequest soap = new SoapRequest(service, method, (Object)parameters);
            response = soap.getResponse().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            response = "Unable to connect to server for registration. Server is down. " + e.getMessage();
            logger.error((Object)"Unable to connect to server for registration : ", (Throwable)e);
        }
        return response;
    }
}

