/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.StringTokenizer;

public class Utility {
    public static int clientPort = -1;

    public static String captureStackTrace(Throwable exception) {
        StringBuffer stackTrace = new StringBuffer();
        stackTrace.append("Exception in thread \"");
        stackTrace.append(Thread.currentThread());
        stackTrace.append("\" ");
        stackTrace.append(exception);
        stackTrace.append("\n");
        StackTraceElement[] elements = exception.getStackTrace();
        int x = 0;
        while (x < elements.length) {
            stackTrace.append(elements[x].toString());
            stackTrace.append("\n");
            ++x;
        }
        return stackTrace.toString();
    }

    public static String[] getTokens(String sStr, String sDel) {
        StringTokenizer tokenizer = new StringTokenizer(sStr, sDel);
        String[] str = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            str[i] = tokenizer.nextToken();
            ++i;
        }
        return str;
    }

    public static float parseFloat(String value, float defaultVal) {
        value = value.replaceAll(",", "");
        try {
            return Float.parseFloat(value);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static double parseDouble(String value, double defaultVal) {
        value = value.replaceAll(",", "");
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static int parseInt(String value, int defaultVal) {
        value = value.replaceAll(",", "");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static long parseLong(String value, int defaultVal) {
        value = value.replaceAll(",", "");
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }

    public static String replaceString(String raw) {
        if (raw == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        raw = raw.replaceAll("%dd%", "" + calendar.get(5));
        raw = raw.replaceAll("%mm%", "" + (calendar.get(2) + 1));
        raw = raw.replaceAll("%yyyy%", "" + calendar.get(1));
        raw = raw.replaceAll("%DD%", Utility.padLeft("" + calendar.get(5), '0', 2));
        raw = raw.replaceAll("%MM%", Utility.padLeft("" + (calendar.get(2) + 1), '0', 2));
        raw = raw.replaceAll("%YYYY%", Utility.padLeft("" + calendar.get(1), '0', 4));
        return raw;
    }

    public static String padLeft(String str, char ch, int size) {
        if (str == null) {
            str = "";
        }
        while (str.length() < size) {
            str = String.valueOf(ch) + str;
        }
        return str;
    }

    public static String padRight(String str, char ch, int size) {
        if (str == null) {
            str = "";
        }
        while (str.length() < size) {
            str = String.valueOf(str) + ch;
        }
        return str;
    }

    public static String padRight(String str, int size) {
        return String.format("%1$-" + size + "s", str);
    }

    public static String padLeft(String str, int size) {
        return String.format("%1$#" + size + "s", str);
    }

    public static int byteArrayToInt(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(bis);
        return in.readInt();
    }

    public static int generateFeedPort() {
        Random ran = new Random();
        clientPort = ran.nextInt(3000) + 2064;
        return clientPort;
    }

    public static void main(String[] arg) {
        int x = 0;
        int y = 10;
        try {
            y /= x;
        }
        catch (Exception e) {
            System.out.println(Utility.captureStackTrace(e));
        }
    }
}

