/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.History;
import pk.com.softech.util.SaveFileDialog;

public class ExportChartDataToFile {
    HSSFWorkbook workbook;
    HSSFSheet sheet;
    CellStyle headerStyle;
    HSSFCellStyle cellStyle;
    HSSFFont font;
    private static ExportChartDataToFile export_instance = null;
    String[] columns = new String[]{"Date", "Open", "High", "Low", "Close", "Volume"};
    public static NumberFormat numberFormtater = new DecimalFormat("#.##");
    public static DateFormat INDICATOR_DATE = new SimpleDateFormat("M/d/yyyy");

    ExportChartDataToFile() {
        if (this.workbook == null) {
            this.workbook = new HSSFWorkbook();
            this.sheet = this.workbook.createSheet("Student Portfolio Data");
            this.cellStyle = this.workbook.createCellStyle();
            this.font = this.workbook.createFont();
            this.font.setFontName("Arial");
            this.font.setFontHeightInPoints((short)11);
            this.font.setColor(IndexedColors.BLUE.getIndex());
            this.headerStyle = this.workbook.createCellStyle();
            this.headerStyle.setFont((Font)this.font);
            this.headerStyle.setAlignment((short)2);
        }
    }

    public static ExportChartDataToFile getInstance() {
        if (export_instance == null) {
            export_instance = new ExportChartDataToFile();
        }
        return export_instance;
    }

    public void export(History history, String Symbol) throws IOException {
        Bar[] charData;
        int rownum = 0;
        this.createHeadRow((Row)this.sheet.createRow(rownum++), this.columns);
        Bar[] barArray = charData = history.toArray();
        int n = charData.length;
        int n2 = 0;
        while (n2 < n) {
            Bar barObj = barArray[n2];
            HSSFRow row = this.sheet.createRow(rownum++);
            ExportChartDataToFile.createList(barObj, (Row)row);
            ++n2;
        }
        try {
            Shell shell = new Shell(Display.getDefault());
            SaveFileDialog saveFileDlgObj = new SaveFileDialog(shell);
            saveFileDlgObj.setFilterNames(new String[]{"Excel Files", "All Files (*.*)"});
            saveFileDlgObj.setFilterExtensions(new String[]{"*.xls", "*.*"});
            saveFileDlgObj.setFilterPath(String.valueOf(System.getProperty("user.home")) + "/Desktop");
            saveFileDlgObj.setFileName("Chart_Data_" + Symbol + ".xls");
            saveFileDlgObj.open();
            String path = String.valueOf(saveFileDlgObj.getFilterPath()) + "/" + saveFileDlgObj.getFileName();
            FileOutputStream out = new FileOutputStream(new File(path));
            this.workbook.write((OutputStream)out);
            out.close();
            MessageDialog.openInformation((Shell)shell, (String)"Success", (String)("Data is export at this path " + path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void createHeadRow(Row row, String[] COLUMN_NAMES) {
        Cell cell_1 = row.createCell(0);
        cell_1.setCellValue(COLUMN_NAMES[0]);
        cell_1.setCellStyle(this.headerStyle);
        this.sheet.setColumnWidth(0, 8960);
        Cell cell_2 = row.createCell(1);
        cell_2.setCellValue(COLUMN_NAMES[1]);
        cell_2.setCellStyle(this.headerStyle);
        Cell cell_3 = row.createCell(2);
        cell_3.setCellValue(COLUMN_NAMES[2]);
        cell_3.setCellStyle(this.headerStyle);
        Cell cell_4 = row.createCell(3);
        cell_4.setCellValue(COLUMN_NAMES[3]);
        cell_4.setCellStyle(this.headerStyle);
        Cell cell_5 = row.createCell(4);
        cell_5.setCellValue(COLUMN_NAMES[4]);
        cell_5.setCellStyle(this.headerStyle);
        Cell cell_6 = row.createCell(5);
        cell_6.setCellValue(COLUMN_NAMES[5]);
        cell_6.setCellStyle(this.headerStyle);
        int i = 1;
        while (i < 6) {
            this.sheet.setColumnWidth(i, 3840);
            ++i;
        }
    }

    private static void createList(Bar barObj, Row row) {
        Cell cell_13 = row.createCell(0);
        cell_13.setCellValue("" + barObj.getDate());
        Cell cell_1 = row.createCell(1);
        cell_1.setCellValue(String.valueOf(numberFormtater.format(barObj.getOpen())));
        Cell cell_2 = row.createCell(2);
        cell_2.setCellValue(String.valueOf(numberFormtater.format(barObj.getHigh())));
        Cell cell_3 = row.createCell(3);
        cell_3.setCellValue(String.valueOf(numberFormtater.format(barObj.getLow())));
        Cell cell_4 = row.createCell(4);
        cell_4.setCellValue(String.valueOf(numberFormtater.format(barObj.getClose())));
        Cell cell_5 = row.createCell(5);
        cell_5.setCellValue(String.valueOf(numberFormtater.format(barObj.getVolume())));
    }
}

