/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.util;

import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;

public class Clock
extends TimerTask {
    private int second;
    private int minute;
    private int hour;
    private SimpleDateFormat timeFormat = null;

    public Clock() {
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
    }

    public Clock(Date timeStamp) {
        this.timeFormat = new SimpleDateFormat("HH:mm:ss");
        this.setTimeStamp(timeStamp);
    }

    public void setTimeStamp(Date timeStamp) {
        this.second = timeStamp.getSeconds();
        this.minute = timeStamp.getMinutes();
        this.hour = timeStamp.getHours();
        Resources.serverDate = new Date(timeStamp.getTime());
        this.startTimer();
    }

    private void startTimer() {
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Clock clock = Clock.this;
                clock.second = clock.second + 1;
                if (Clock.this.second == 60) {
                    Clock.this.second = 0;
                    Clock clock2 = Clock.this;
                    clock2.minute = clock2.minute + 1;
                    if (Clock.this.minute == 60) {
                        Clock.this.minute = 0;
                        Clock clock3 = Clock.this;
                        clock3.hour = clock3.hour + 1;
                        if (Clock.this.hour == 24) {
                            Clock.this.hour = 0;
                        }
                    }
                }
            }
        }, 0L, 1000L);
    }

    public void setSecond(int s) {
        if (s >= 0 && s < 60) {
            this.second = s;
        } else {
            System.out.println("Invalid seconds value, not set.");
        }
    }

    public void setMinute(int m) {
        if (m >= 0 && m < 60) {
            this.minute = m;
        } else {
            System.out.println("Invalid minutes value, not set.");
        }
    }

    public void setHour(int h) {
        if (h >= 0 && h < 24) {
            this.hour = h;
        } else {
            System.out.println("Invalid hours value.");
        }
    }

    public void setTime(int s, int m, int h) {
        this.setSecond(s);
        this.setMinute(m);
        this.setHour(h);
    }

    public void tick() {
    }

    public int getSecond() {
        return this.second;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getHour() {
        return this.hour;
    }

    public String getTime() {
        Calendar now = Calendar.getInstance();
        now.set(1, 2, 5, this.getHour(), this.getMinute(), this.getSecond());
        Date dt = new Date(now.getTimeInMillis());
        return this.timeFormat.format(dt);
    }

    public String toString() {
        return String.valueOf(this.hour) + ":" + this.minute + ":" + this.second;
    }

    @Override
    public void run() {
        CorePlugin.updateStausBar("CLOCK", "Server Time = " + this.getTime());
    }

    public void actionPerformed(ActionEvent e) {
    }
}

