/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.widgets;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.widgets.IEditableColumn;
import pk.com.softech.tradingterminal.core.ui.widgets.IEditableItem;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.NumberVerifyListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;

public class EditableTableColumn
extends TableColumn
implements IEditableColumn {
    public static final int TEXT = 0;
    public static final int FLOAT = 1;
    public static final int INT = 2;
    public static final int MARKET_COMBO = 3;
    public static final int EXCHANGE_COMBO = 4;
    protected int type = -1;
    protected boolean editable = true;
    protected TableItem item = null;
    protected int index = -1;
    protected Text editor;
    protected Combo cmbMarket;
    protected Combo cmbExchange;

    public EditableTableColumn(Table parent, int style) {
        super(parent, style);
    }

    public EditableTableColumn(Table parent, int style, int index) {
        super(parent, style, index);
    }

    protected void checkSubclass() {
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public Control getEditor(Item item, int index) {
        this.item = (TableItem)item;
        this.index = index;
        if (this.type == -1) {
            return null;
        }
        if (this.type == 4) {
            this.cmbExchange = new Combo((Composite)this.getParent(), 8);
            if (Resources.exchangeNames != null) {
                this.cmbExchange.removeAll();
                int i = 0;
                while (i < Resources.exchangeNames.size()) {
                    this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                    ++i;
                }
                this.cmbExchange.select(0);
            }
            this.cmbExchange.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableColumn.this.destroyEditor();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.cmbExchange.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    EditableTableColumn.this.destroyEditor();
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.cmbExchange.setText(this.item.getText(index));
            return this.cmbExchange;
        }
        if (this.type == 3) {
            this.cmbMarket = new Combo((Composite)this.getParent(), 8);
            if (Resources.marketTypes != null) {
                int i = 0;
                while (i < Resources.marketTypes.size()) {
                    this.cmbMarket.add("" + Resources.marketTypes.get(i));
                    ++i;
                }
            }
            this.cmbMarket.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EditableTableColumn.this.destroyEditor();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.cmbMarket.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    EditableTableColumn.this.destroyEditor();
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.cmbMarket.setText(this.item.getText(index));
            return this.cmbMarket;
        }
        this.editor = new Text((Composite)this.getParent(), 0);
        if (this.type == 2) {
            this.editor.addVerifyListener((VerifyListener)new NumberVerifyListener());
        } else if (this.type == 1) {
            this.editor.addVerifyListener((VerifyListener)new PriceVerifyListener());
        } else {
            this.editor.addVerifyListener((VerifyListener)new CapitalTextListener());
        }
        this.editor.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    EditableTableColumn.this.destroyEditor();
                }
            }
        });
        String text = this.item.getText(index).toUpperCase().replaceAll(",", "");
        this.editor.setText(text == null ? "" : text);
        this.editor.selectAll();
        return this.editor;
    }

    @Override
    public void destroyEditor() {
        try {
            if (this.type == 4) {
                if (this.cmbExchange != null && !this.cmbExchange.isDisposed()) {
                    if (this.item != null && this.index != -1) {
                        this.setItemValue(this.index, this.cmbExchange.getText());
                    }
                    this.cmbExchange.dispose();
                }
                this.cmbMarket = null;
            } else if (this.type == 3) {
                if (this.cmbMarket != null && !this.cmbMarket.isDisposed()) {
                    if (this.item != null && this.index != -1) {
                        this.setItemValue(this.index, this.cmbMarket.getText());
                    }
                    this.cmbMarket.dispose();
                }
                this.cmbMarket = null;
            } else {
                if (this.editor != null && !this.editor.isDisposed()) {
                    if (this.item != null && this.index != -1) {
                        this.setItemValue(this.index, this.editor.getText());
                    }
                    this.editor.dispose();
                }
                this.editor = null;
            }
        }
        catch (Exception exception) {}
    }

    protected void setItemValue(int index, String value) {
        String oldValue = this.item.getText(index);
        this.item.setText(index, value);
        if (this.item instanceof IEditableItem && !oldValue.equals(value)) {
            ((IEditableItem)this.item).itemEdited(index, value);
        }
    }

    public void setEditorType(int type) {
        this.type = type;
    }
}

