/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.widgets;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import pk.com.softech.tradingterminal.core.ui.widgets.IEditableColumn;
import pk.com.softech.tradingterminal.core.ui.widgets.IEditableItem;

public class EditableTable
extends Table {
    private TableEditor editor;
    private TableItem selectedItem;
    private int selectedColumnIndex = -1;

    public EditableTable(Composite parent, int style) {
        super(parent, style);
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableItem item;
                if (e.keyCode == 13 && (item = EditableTable.this.getSelectedItem()) != null && EditableTable.this.selectedColumnIndex == -1) {
                    int i = 0;
                    while (i < EditableTable.this.getColumnCount()) {
                        if (EditableTable.this.getColumn(i) instanceof IEditableColumn) {
                            EditableTable.this.selectedColumnIndex = i;
                            EditableTable.this.activateEditor();
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableItem item;
                IEditableColumn column;
                if (EditableTable.this.selectedItem != null && EditableTable.this.selectedColumnIndex != -1 && EditableTable.this.editor.getEditor() != null && !EditableTable.this.editor.getEditor().isDisposed() && (column = (IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).isEditable()) {
                    column.destroyEditor();
                }
                if ((item = EditableTable.this.getItem(new Point(e.x, e.y))) != null) {
                    int columnIndex = -1;
                    int i = 0;
                    while (i < EditableTable.this.getColumnCount()) {
                        if (EditableTable.this.getColumn(i) instanceof IEditableColumn && ((IEditableColumn)EditableTable.this.getColumn(i)).isEditable() && item.getBounds(i).contains(e.x, e.y)) {
                            columnIndex = i;
                        }
                        ++i;
                    }
                    if (columnIndex != -1 && item == EditableTable.this.selectedItem && columnIndex == EditableTable.this.selectedColumnIndex && EditableTable.this.getSelectionIndex() != -1) {
                        EditableTable.this.activateEditor();
                    }
                    EditableTable.this.selectedItem = item;
                    EditableTable.this.selectedColumnIndex = columnIndex;
                }
            }
        });
        this.editor = new TableEditor((Table)this);
        this.editor.horizontalAlignment = 0x1000000;
        this.editor.grabHorizontal = true;
    }

    protected void checkSubclass() {
    }

    private TableItem getSelectedItem() {
        if (this.getSelectionCount() != 1) {
            return null;
        }
        return this.getSelection()[0];
    }

    private TableItem selectNextRow() {
        if (this.getSelectionCount() != 1) {
            return null;
        }
        TableItem item = this.getSelection()[0];
        int row = this.indexOf(item) + 1;
        if (row < this.getItemCount()) {
            TableItem[] selection = new TableItem[]{this.getItem(row)};
            this.setSelection(selection);
            return selection[0];
        }
        return null;
    }

    private TableItem selectPreviousRow() {
        if (this.getSelectionCount() != 1) {
            return null;
        }
        TableItem item = this.getSelection()[0];
        int row = this.indexOf(item) - 1;
        if (row >= 0) {
            TableItem[] selection = new TableItem[]{this.getItem(row)};
            this.setSelection(selection);
            return selection[0];
        }
        return null;
    }

    private void activateEditor() {
        TableItem item = this.getItem(this.getSelectionIndex());
        if (item == null) {
            return;
        }
        if (this.selectedColumnIndex == -1 || !(this.getColumn(this.selectedColumnIndex) instanceof IEditableColumn)) {
            return;
        }
        IEditableColumn column = (IEditableColumn)this.getColumn(this.selectedColumnIndex);
        if (!column.isEditable()) {
            return;
        }
        if (!(!(item instanceof IEditableItem) || ((IEditableItem)item).isEditable() && ((IEditableItem)item).canEdit(this.selectedColumnIndex))) {
            return;
        }
        Control newEditor = column.getEditor((Item)item, this.selectedColumnIndex);
        if (newEditor != null) {
            newEditor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16) {
                        ((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).destroyEditor();
                        do {
                            EditableTable editableTable = EditableTable.this;
                            editableTable.selectedColumnIndex = editableTable.selectedColumnIndex + 1;
                        } while (EditableTable.this.selectedColumnIndex < EditableTable.this.getColumnCount() && (!(EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).isEditable()));
                        if (EditableTable.this.selectedColumnIndex < EditableTable.this.getColumnCount()) {
                            EditableTable.this.activateEditor();
                        } else if (EditableTable.this.selectNextRow() != null) {
                            EditableTable.this.selectedColumnIndex = -1;
                            do {
                                EditableTable editableTable = EditableTable.this;
                                editableTable.selectedColumnIndex = editableTable.selectedColumnIndex + 1;
                            } while (EditableTable.this.selectedColumnIndex < EditableTable.this.getColumnCount() && (!(EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).isEditable()));
                            EditableTable.this.activateEditor();
                        } else {
                            EditableTable.this.setFocus();
                            EditableTable.this.selectedColumnIndex = -1;
                        }
                        e.doit = false;
                    } else if (e.detail == 8) {
                        ((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).destroyEditor();
                        do {
                            EditableTable editableTable = EditableTable.this;
                            editableTable.selectedColumnIndex = editableTable.selectedColumnIndex - 1;
                        } while (EditableTable.this.selectedColumnIndex >= 0 && (!(EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).isEditable()));
                        if (EditableTable.this.selectedColumnIndex >= 0) {
                            EditableTable.this.activateEditor();
                        } else if (EditableTable.this.selectPreviousRow() != null) {
                            EditableTable.this.selectedColumnIndex = EditableTable.this.getColumnCount();
                            do {
                                EditableTable editableTable = EditableTable.this;
                                editableTable.selectedColumnIndex = editableTable.selectedColumnIndex - 1;
                            } while (EditableTable.this.selectedColumnIndex >= 0 && (!(EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex) instanceof IEditableColumn) || !((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).isEditable()));
                            EditableTable.this.activateEditor();
                        } else {
                            EditableTable.this.setFocus();
                            EditableTable.this.selectedColumnIndex = -1;
                        }
                        e.doit = false;
                    } else if (e.detail == 2) {
                        ((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).destroyEditor();
                        EditableTable.this.setFocus();
                        EditableTable.this.selectedColumnIndex = -1;
                        e.doit = false;
                    }
                }
            });
            newEditor.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000001 && !(EditableTable.this.editor.getEditor() instanceof Combo)) {
                        ((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).destroyEditor();
                        if (EditableTable.this.selectPreviousRow() != null) {
                            EditableTable.this.activateEditor();
                        } else {
                            EditableTable.this.setFocus();
                        }
                        e.doit = false;
                    } else if (e.keyCode == 0x1000002 && !(EditableTable.this.editor.getEditor() instanceof Combo)) {
                        ((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).destroyEditor();
                        if (EditableTable.this.selectNextRow() != null) {
                            EditableTable.this.activateEditor();
                        } else {
                            EditableTable.this.setFocus();
                        }
                        e.doit = false;
                    }
                }
            });
            newEditor.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (!(EditableTable.this.editor.getEditor() instanceof Combo)) {
                        ((IEditableColumn)EditableTable.this.getColumn(EditableTable.this.selectedColumnIndex)).destroyEditor();
                    }
                }
            });
            this.editor.setEditor(newEditor, item, this.selectedColumnIndex);
            newEditor.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditableTable.this.editor.getEditor().setFocus();
                    }
                    catch (Exception exception) {}
                }
            });
        }
    }
}

