/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.internal.ImageResource;
import pk.com.softech.tradingterminal.core.ui.internal.ToolbarLayout;
import pk.com.softech.tradingterminal.core.util.ProductNames;

public class WebBrowserView
extends ViewPart {
    public static Map<String, Map<String, String>> brand_urls;
    public static final String PREFERENCES_ID = "BROWSER_PREFS_";
    public static final String PREFS_SECONDARY_ID = "PREFS_SECONDARY_ID";
    public String PREFS_URL = "PREFS_URL";
    public static String URL_DEFAULT;
    public static String URL_RESEARCH;
    public static final String URL_SOFTECH = "www.softech.com.pk";
    public static String URL_FACEBOOK;
    public static String URL_TWITTER;
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.webbrowser";
    private static String URL_LINKDEDIN;
    private ToolItem back;
    private ToolItem forward;
    private Combo combo;
    private Browser browser;
    private String url = "";

    static {
        URL_DEFAULT = "www.google.com";
        URL_RESEARCH = "www.google.com";
        URL_FACEBOOK = "www.facebook.com";
        URL_TWITTER = "www.twitter.com";
        URL_LINKDEDIN = "www.linkedin.com";
        HashMap<String, String> LUMS_URLS = new HashMap<String, String>();
        LUMS_URLS.put(URL_RESEARCH, "https://lums.edu.pk/research-lums");
        LUMS_URLS.put(URL_TWITTER, "https://twitter.com/LifeAtLUMS");
        LUMS_URLS.put(URL_LINKDEDIN, "https://www.linkedin.com/school/lahore-university-of-management-sciences/");
        LUMS_URLS.put(URL_FACEBOOK, "https://www.facebook.com/lahoreuniversityofmanagementsciences/");
        HashMap<String, String> FOUNDATION_URLS = new HashMap<String, String>();
        FOUNDATION_URLS.put(URL_RESEARCH, "http://www.fsedge.com/research.php");
        FOUNDATION_URLS.put(URL_TWITTER, "");
        FOUNDATION_URLS.put(URL_LINKDEDIN, "");
        FOUNDATION_URLS.put(URL_FACEBOOK, "https://www.facebook.com/foundationsecurities/");
        HashMap<String, String> ABBASI_URLS = new HashMap<String, String>();
        ABBASI_URLS.put(URL_RESEARCH, "https://www.abbasiandcompany.com/");
        ABBASI_URLS.put(URL_TWITTER, "");
        ABBASI_URLS.put(URL_LINKDEDIN, "https://pk.linkedin.com/company/abbasi-and-company-pvt-ltd");
        ABBASI_URLS.put(URL_FACEBOOK, "https://www.facebook.com/ACPLCommodities/");
        HashMap<String, String> ASKARI_URLS = new HashMap<String, String>();
        ASKARI_URLS.put(URL_RESEARCH, "http://www.askarisecurities.com.pk/");
        ASKARI_URLS.put(URL_TWITTER, "https://twitter.com/askarisec");
        ASKARI_URLS.put(URL_LINKDEDIN, "");
        ASKARI_URLS.put(URL_FACEBOOK, "https://www.facebook.com/AskariSecurities");
        HashMap<String, String> IGI_URLS = new HashMap<String, String>();
        IGI_URLS.put(URL_RESEARCH, "http://www.igisecurities.com.pk/");
        IGI_URLS.put(URL_TWITTER, "https://www.twitter.com/igisec/");
        IGI_URLS.put(URL_LINKDEDIN, "https://www.linkedin.com/company/igi/");
        IGI_URLS.put(URL_FACEBOOK, "https://www.facebook.com/igisecurities");
        HashMap<String, String> IMS_URLS = new HashMap<String, String>();
        IMS_URLS.put(URL_RESEARCH, "http://www.imsecurities.com.pk/");
        IMS_URLS.put(URL_TWITTER, "https://twitter.com/imstradeonline");
        IMS_URLS.put(URL_LINKDEDIN, "");
        IMS_URLS.put(URL_FACEBOOK, "https://www.facebook.com/IMStradeonline/");
        HashMap<String, String> AHL_URLS = new HashMap<String, String>();
        AHL_URLS.put(URL_RESEARCH, "https://arifhabibltd.com/");
        AHL_URLS.put(URL_TWITTER, "https://twitter.com/ArifHabibLtd");
        AHL_URLS.put(URL_LINKDEDIN, "https://www.linkedin.com/company/arif-habib-limited/?originalSubdomain=pk");
        AHL_URLS.put(URL_FACEBOOK, "https://www.facebook.com/arifhabibltd/");
        HashMap<String, String> VECTOR_URLS = new HashMap<String, String>();
        VECTOR_URLS.put(URL_RESEARCH, "https://vector.com.pk/");
        VECTOR_URLS.put(URL_TWITTER, "");
        VECTOR_URLS.put(URL_LINKDEDIN, "https://pk.linkedin.com/company/vector-securities");
        VECTOR_URLS.put(URL_FACEBOOK, "https://www.facebook.com/pages/category/Financial-Service/Vector-Securities-698455453524270/");
        HashMap<String, String> IEL_URLS = new HashMap<String, String>();
        IEL_URLS.put(URL_RESEARCH, "");
        IEL_URLS.put(URL_TWITTER, "");
        IEL_URLS.put(URL_LINKDEDIN, "");
        IEL_URLS.put(URL_FACEBOOK, "");
        brand_urls = new HashMap<String, Map<String, String>>();
        brand_urls.put(ProductNames.ASKARI.toString(), ASKARI_URLS);
        brand_urls.put(ProductNames.FOUNDATION.toString(), FOUNDATION_URLS);
        brand_urls.put(ProductNames.ITRADE.toString(), IGI_URLS);
        brand_urls.put(ProductNames.IMTRADE.toString(), IMS_URLS);
        brand_urls.put(ProductNames.ABBASI.toString(), ABBASI_URLS);
        brand_urls.put(ProductNames.LUMS.toString(), LUMS_URLS);
        brand_urls.put(ProductNames.AHL.toString(), AHL_URLS);
        brand_urls.put(ProductNames.VECTOR.toString(), VECTOR_URLS);
        brand_urls.put(ProductNames.IEL.toString(), IEL_URLS);
        Map<String, String> brand_url = brand_urls.get(Resources.PRODUCT_NAME.toString());
        if (brand_url != null && !brand_url.isEmpty()) {
            String brand_twitter = brand_url.get(URL_TWITTER);
            String brand_facebook = brand_url.get(URL_FACEBOOK);
            String brand_research = brand_url.get(URL_RESEARCH);
            String brand_linkedin = brand_url.get(URL_LINKDEDIN);
            if (!"".equals(brand_twitter)) {
                URL_TWITTER = brand_twitter;
            }
            if (!"".equals(brand_facebook)) {
                URL_FACEBOOK = brand_facebook;
            }
            if (!"".equals(brand_research)) {
                URL_RESEARCH = brand_research;
            }
            if (!"".equals(brand_linkedin)) {
                URL_LINKDEDIN = brand_linkedin;
            }
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String partName;
        String page_label = this.getActivePage();
        if (site.getSecondaryId() != null && (partName = CorePlugin.getDefault().getPreferenceStore().getString("pk.com.softech.tradingterminal.webbrowser:" + site.getSecondaryId())).length() != 0) {
            this.setPartName(partName);
        }
        String id = null;
        if (site.getSecondaryId() != null) {
            try {
                Integer.parseInt(site.getSecondaryId());
            }
            catch (Exception exception) {
                id = site.getSecondaryId();
            }
        }
        if (page_label.equalsIgnoreCase("Research") || page_label.equalsIgnoreCase("Reports")) {
            URL_DEFAULT = URL_RESEARCH;
        } else if (page_label.equalsIgnoreCase("Social")) {
            if (memento != null) {
                id = memento.getString(this.PREFS_URL);
            }
            URL_DEFAULT = id != null && !id.equals("") ? (id.contains("twitter") ? URL_TWITTER : (id.contains("facebook") ? URL_FACEBOOK : (id.contains("linkedin") ? URL_LINKDEDIN : URL_FACEBOOK))) : URL_FACEBOOK;
        }
        if (Resources.PRODUCT_NAME == ProductNames.FOUNDATION || Resources.PRODUCT_NAME == ProductNames.ABBASI) {
            id = URL_DEFAULT;
        } else {
            if (memento != null) {
                id = memento.getString(this.PREFS_URL);
            }
            if (id == null || id.equals("")) {
                id = URL_DEFAULT;
            }
        }
        this.url = id;
        super.init(site);
    }

    private String getActivePage() {
        String active_page = "";
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return active_page;
        }
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective != null) {
            active_page = perspective.getLabel();
        }
        return active_page;
    }

    public void saveState(IMemento memento) {
        if (this.browser.getUrl() != null) {
            memento.putString(this.PREFS_URL, this.browser.getUrl());
        }
        super.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        Composite toolbarComp = new Composite(content, 0);
        toolbarComp.setLayout((Layout)new ToolbarLayout());
        toolbarComp.setLayoutData((Object)new GridData(770));
        this.createToolbar(toolbarComp);
        this.createLocationBar(toolbarComp);
        this.browser = new Browser(content, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                String[] items = WebBrowserView.this.combo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(event.location)) {
                        return;
                    }
                    ++i;
                }
                WebBrowserView.this.combo.add(event.location, 0);
                WebBrowserView.this.combo.setText(event.location);
            }

            public void changing(LocationEvent event) {
                WebBrowserView.this.combo.setText(event.location);
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                WebBrowserView.this.setPartName(event.title);
            }
        });
        this.setTitleToolTip(this.getPartName());
        try {
            this.browser.setUrl(this.url);
        }
        catch (Exception exception) {}
    }

    private ToolBar createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        this.back = new ToolItem(toolbar, 0);
        this.back.setImage(ImageResource.getImage("IMG_ELCL_NAV_BACKWARD"));
        this.back.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_BACKWARD"));
        this.back.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_BACKWARD"));
        this.back.setToolTipText("Back");
        this.back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowserView.this.back();
            }
        });
        this.forward = new ToolItem(toolbar, 0);
        this.forward.setImage(ImageResource.getImage("IMG_ELCL_NAV_FORWARD"));
        this.forward.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_FORWARD"));
        this.forward.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_FORWARD"));
        this.forward.setToolTipText("Forward");
        this.forward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowserView.this.forward();
            }
        });
        ToolItem stop = new ToolItem(toolbar, 0);
        stop.setImage(ImageResource.getImage("IMG_ELCL_NAV_STOP"));
        stop.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_STOP"));
        stop.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_STOP"));
        stop.setToolTipText("Stop");
        stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowserView.this.stop();
            }
        });
        ToolItem refresh = new ToolItem(toolbar, 0);
        refresh.setImage(ImageResource.getImage("IMG_ELCL_NAV_REFRESH"));
        refresh.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_REFRESH"));
        refresh.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_REFRESH"));
        refresh.setToolTipText("Refresh");
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebBrowserView.this.refresh();
            }
        });
        return toolbar;
    }

    private ToolBar createLocationBar(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.setVisibleItemCount(20);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent we) {
                try {
                    if (WebBrowserView.this.combo.getSelectionIndex() != -1) {
                        WebBrowserView.this.setUrl(WebBrowserView.this.combo.getItem(WebBrowserView.this.combo.getSelectionIndex()));
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.combo.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                WebBrowserView.this.setUrl(WebBrowserView.this.combo.getText());
            }
        });
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        ToolItem go = new ToolItem(toolbar, 0);
        go.setImage(ImageResource.getImage("IMG_ELCL_NAV_GO"));
        go.setHotImage(ImageResource.getImage("IMG_CLCL_NAV_GO"));
        go.setDisabledImage(ImageResource.getImage("IMG_DLCL_NAV_GO"));
        go.setToolTipText("Go");
        go.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WebBrowserView.this.browser.getUrl().length() != 0 && WebBrowserView.this.combo.indexOf(WebBrowserView.this.browser.getUrl()) == -1) {
                    WebBrowserView.this.combo.add(WebBrowserView.this.browser.getUrl());
                }
                WebBrowserView.this.setUrl(WebBrowserView.this.combo.getText());
            }
        });
        return toolbar;
    }

    public boolean forward() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.forward();
    }

    public boolean back() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.back();
    }

    public boolean isBackEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isBackEnabled();
    }

    public boolean isForwardEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isForwardEnabled();
    }

    public void stop() {
        if (this.browser != null) {
            this.browser.stop();
        }
    }

    public void refresh() {
        if (this.browser != null) {
            this.browser.refresh();
        }
    }

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public void setPage(String page) {
        this.browser.setText(page);
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
        this.browser.setFocus();
    }
}

