/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.views;

import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.TickerData;
import pk.com.softech.tradingterminal.core.ui.actions.ColorAndFontAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.SpeedDialog;

public class TickerView
extends ViewPart
implements ICollectionObserver,
Observer {
    private Composite parent;
    private Composite content;
    protected final String FG_COLOR_POSITIVE = "FG_COLOR_POSITIVE";
    protected final String FG_COLOR_NEGATIVE = "FG_COLOR_NEGATIVE";
    protected final String FG_COLOR_EQUAL = "FG_COLOR_EQUAL";
    protected final String BG_COLOR = "BG_COLOR";
    protected final String LBG_COLOR = "LBG_COLOR";
    protected final String FONT_NAME = "FONT_NAME";
    protected final String TICKER_DIRECTION = "TICKER_DIRECTION";
    protected final String TICKER_SPEED = "TICKER_SPEED";
    protected final String VERTICAL_POSITION = "VERTICAL_POSITION";
    private ITheme theme;
    private Font font;
    private Color fgPositive;
    private Color fgNegative;
    private Color fgEqual;
    private Color background;
    private Color lblBackgroud;
    static String space = "&#160;";
    static String percent = "&#37;";
    private Cursor cursor;
    private RefreshThread t = null;
    private boolean pause = false;
    private int timeInterval = 30;
    static final int MIN_SPEED = 10;
    static final int MAX_SPEED = 50;
    public static boolean leftToRight = true;
    private int x = 1;
    private int y = 1;
    protected ObservableList<TickerData> tickerData = new ObservableList();
    private Hashtable<String, Label> tickerHash = new Hashtable();
    private Action tickerSettingsAction;
    private Action colorsAndFonts;
    private IPreferenceStore prefs;
    private String colorPreferencePageId = "";
    private MouseListener mouseClickListener;
    public String viewType = "";
    public static final String SYMBOL_TICKER = "STV_";
    public static final String MARQUEE_TICKER = "MTV_";
    public static final String ANNOUNCEMENT_TICKER = "ATV_";
    public static final String NEWS_TICKER = "NTV_";
    IPropertyChangeListener themeChangeListenr = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                TickerView.this.setTheme((ITheme)event.getNewValue());
            } else {
                if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "FG_COLOR_POSITIVE")) {
                    TickerView.this.fgPositive = TickerView.this.theme.getColorRegistry().get(String.valueOf(TickerView.this.viewType) + "FG_COLOR_POSITIVE");
                    TickerView.this.resetLabels();
                }
                if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "FG_COLOR_NEGATIVE")) {
                    TickerView.this.fgNegative = TickerView.this.theme.getColorRegistry().get(String.valueOf(TickerView.this.viewType) + "FG_COLOR_NEGATIVE");
                    TickerView.this.resetLabels();
                }
                if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "FG_COLOR_EQUAL")) {
                    TickerView.this.fgEqual = TickerView.this.theme.getColorRegistry().get(String.valueOf(TickerView.this.viewType) + "FG_COLOR_EQUAL");
                    TickerView.this.resetLabels();
                }
                if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "BG_COLOR")) {
                    TickerView.this.background = TickerView.this.theme.getColorRegistry().get(String.valueOf(TickerView.this.viewType) + "BG_COLOR");
                    TickerView.this.parent.setBackground(TickerView.this.background);
                }
                if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "LBG_COLOR")) {
                    TickerView.this.lblBackgroud = TickerView.this.theme.getColorRegistry().get(String.valueOf(TickerView.this.viewType) + "LBG_COLOR");
                    for (String key : TickerView.this.tickerHash.keySet()) {
                        ((Label)TickerView.this.tickerHash.get(key)).setBackground(TickerView.this.lblBackgroud);
                    }
                }
                if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "FONT_NAME")) {
                    TickerView.this.font = TickerView.this.theme.getFontRegistry().get(String.valueOf(TickerView.this.viewType) + "FONT_NAME");
                    TickerView.this.resetLabels();
                }
            }
        }
    };
    IPropertyChangeListener prefChangeListenr = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "TICKER_DIRECTION")) {
                leftToRight = TickerView.this.prefs.getBoolean(String.valueOf(TickerView.this.viewType) + "TICKER_DIRECTION");
            }
            if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "TICKER_SPEED")) {
                TickerView.this.timeInterval = TickerView.this.prefs.getInt(String.valueOf(TickerView.this.viewType) + "TICKER_SPEED");
            }
            if (event.getProperty().equals(String.valueOf(TickerView.this.viewType) + "VERTICAL_POSITION")) {
                TickerView.this.y = TickerView.this.prefs.getInt(String.valueOf(TickerView.this.viewType) + "VERTICAL_POSITION");
            }
        }
    };
    MouseTrackListener mouseTrackListener = new MouseTrackListener(){

        public void mouseHover(MouseEvent e) {
            TickerView.this.pause = true;
        }

        public void mouseExit(MouseEvent e) {
            TickerView.this.pause = false;
        }

        public void mouseEnter(MouseEvent e) {
            TickerView.this.pause = true;
        }
    };

    public TickerView(String viewType, String colorPreferencePageId) {
        this.prefs = CorePlugin.getDefault().getPreferenceStore();
        this.viewType = viewType;
        this.colorPreferencePageId = colorPreferencePageId;
    }

    private void setTheme(ITheme theme) {
        if (theme != null) {
            this.theme = theme;
            this.fgPositive = theme.getColorRegistry().get(String.valueOf(this.viewType) + "FG_COLOR_POSITIVE");
            this.fgNegative = theme.getColorRegistry().get(String.valueOf(this.viewType) + "FG_COLOR_NEGATIVE");
            this.fgEqual = theme.getColorRegistry().get(String.valueOf(this.viewType) + "FG_COLOR_EQUAL");
            this.background = theme.getColorRegistry().get(String.valueOf(this.viewType) + "BG_COLOR");
            this.lblBackgroud = theme.getColorRegistry().get(String.valueOf(this.viewType) + "LBG_COLOR");
            this.font = theme.getFontRegistry().get(String.valueOf(this.viewType) + "FONT_NAME");
            theme.addPropertyChangeListener(this.themeChangeListenr);
            this.parent.setBackground(this.background);
            this.resetLabels();
            for (String key : this.tickerHash.keySet()) {
                this.tickerHash.get(key).setBackground(this.lblBackgroud);
            }
        }
    }

    protected void addMouseClickListener(MouseListener mouseListener) {
        this.mouseClickListener = mouseListener;
    }

    public void init(IViewSite site) throws PartInitException {
        this.prefs = CorePlugin.getDefault().getPreferenceStore();
        this.tickerData.addCollectionObserver(this);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver(this);
        this.tickerSettingsAction = new Action(){

            public void run() {
                SpeedDialog dialog = new SpeedDialog(TickerView.this.parent.getShell(), TickerView.this.prefs, String.valueOf(TickerView.this.viewType) + "TICKER_DIRECTION", String.valueOf(TickerView.this.viewType) + "TICKER_SPEED", String.valueOf(TickerView.this.viewType) + "VERTICAL_POSITION", 10, 50);
                dialog.open();
                CorePlugin.getDefault().getPreferenceStore().setValue(String.valueOf(TickerView.this.viewType) + "TICKER_DIRECTION", leftToRight);
                CorePlugin.getDefault().getPreferenceStore().setValue(String.valueOf(TickerView.this.viewType) + "TICKER_SPEED", TickerView.this.timeInterval);
                CorePlugin.getDefault().getPreferenceStore().setValue(String.valueOf(TickerView.this.viewType) + "VERTICAL_POSITION", TickerView.this.y);
            }
        };
        this.tickerSettingsAction.setText("Ticker Settings");
        this.tickerSettingsAction.setToolTipText("Ticker Settings");
        this.tickerSettingsAction.setImageDescriptor(CorePlugin.getImageDescriptor("icons/etool16/setting.png"));
        this.colorsAndFonts = new ColorAndFontAction(new String[]{this.colorPreferencePageId});
        super.init(site);
    }

    public void createPartControl(Composite composite) {
        this.parent = composite;
        this.cursor = new Cursor((Device)this.parent.getDisplay(), 21);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 10;
        this.parent.setBackgroundMode(2);
        this.parent.setDragDetect(false);
        this.parent.setLayout((Layout)rowLayout);
        this.content = new Composite(this.parent, 0x100000);
        this.content.setLayout((Layout)rowLayout);
        this.content.addMouseTrackListener(this.mouseTrackListener);
        this.content.setDragDetect(false);
        leftToRight = CorePlugin.getDefault().getPreferenceStore().getBoolean(String.valueOf(this.viewType) + "TICKER_DIRECTION");
        this.timeInterval = CorePlugin.getDefault().getPreferenceStore().getInt(String.valueOf(this.viewType) + "TICKER_SPEED");
        this.y = CorePlugin.getDefault().getPreferenceStore().getInt(String.valueOf(this.viewType) + "VERTICAL_POSITION");
        if (this.timeInterval <= 0) {
            this.timeInterval = 20;
        }
        this.prefs.addPropertyChangeListener(this.prefChangeListenr);
        this.resetLabels();
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener(this.themeChangeListenr);
        ITheme theme = themeManager.getCurrentTheme();
        this.setTheme(theme);
        this.addActions();
        this.startAnimation();
    }

    private void addActions() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.appendToGroup("top", (IAction)this.tickerSettingsAction);
        menuManager.appendToGroup("top", (IAction)this.colorsAndFonts);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
        toolBarManager.appendToGroup("top", (IAction)this.tickerSettingsAction);
        toolBarManager.appendToGroup("top", (IAction)this.colorsAndFonts);
    }

    private void resetLabels() {
        int i = 0;
        while (i < this.tickerData.size()) {
            TickerData data = (TickerData)this.tickerData.get(i);
            if (data != null) {
                this.setTextLabel(this.tickerHash.get(data.getId()), data);
            }
            ++i;
        }
        this.parent.layout();
    }

    private void addLabel(TickerData data) {
        if (data != null) {
            Label lable = new Label(this.content, 0);
            lable.setCursor(this.cursor);
            lable.setDragDetect(false);
            lable.setData((Object)data);
            if (this.mouseClickListener != null) {
                lable.addMouseListener(this.mouseClickListener);
            }
            lable.addMouseTrackListener(this.mouseTrackListener);
            this.setTextLabel(lable, data);
            lable.setBackground(this.lblBackgroud);
            this.tickerHash.put(data.getId(), lable);
            data.addObserver(this);
            this.content.layout();
            this.parent.layout();
        }
    }

    private void removeLabel(TickerData data) {
        Label lable = this.tickerHash.get(data.getId());
        if (lable != null) {
            if (this.mouseClickListener != null) {
                lable.removeMouseListener(this.mouseClickListener);
            }
            lable.removeMouseTrackListener(this.mouseTrackListener);
            lable.dispose();
            data.deleteObserver(this);
            this.tickerHash.remove(data.getId());
            this.content.layout();
            this.parent.layout();
        }
    }

    private void setTextLabel(Label lable, TickerData data) {
        try {
            if (lable == null || data == null) {
                return;
            }
            if (data.getColor().equals("FG_COLOR_NEGATIVE")) {
                lable.setForeground(this.fgNegative);
            } else if (data.getColor().equals("FG_COLOR_POSITIVE")) {
                lable.setForeground(this.fgPositive);
            } else {
                lable.setForeground(this.fgEqual);
            }
            lable.setFont(this.font);
            lable.setText(data.getLabel());
            lable.setToolTipText(data.getTooltip());
        }
        catch (Exception e) {
            System.out.println("Ex.Set ticker lable " + e.getMessage());
        }
    }

    public void animate() {
        if (this.parent != null && !this.parent.isDisposed() && !this.pause) {
            Point point = this.parent.getSize();
            if (leftToRight) {
                if (point.x < this.x) {
                    this.x = 1;
                }
                ++this.x;
            } else {
                if (1 > this.x + this.content.getBounds().width) {
                    this.x = point.x;
                }
                --this.x;
            }
            this.content.setLocation(this.x, this.y);
        }
    }

    private void startAnimation() {
        this.stopAnimation();
        this.t = new RefreshThread();
        this.t.start();
    }

    private void stopAnimation() {
        if (this.t != null) {
            this.t.interrupt();
            this.t = null;
        }
    }

    @Override
    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TickerData data;
                    if (o instanceof LoginConfirmation) {
                        TickerView.this.startAnimation();
                    }
                    if (o instanceof TickerData && (data = (TickerData)o) != null && data.getId() != null) {
                        try {
                            TickerView.this.addLabel(data);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
        TickerData data;
        if (o instanceof TickerData && (data = (TickerData)o) != null && data.getId() != null) {
            this.removeLabel(data);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        TickerData data;
        if (arg0 instanceof TickerData && (data = (TickerData)arg0) != null && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Label lbl = (Label)TickerView.this.tickerHash.get(data.getId());
                    TickerView.this.setTextLabel(lbl, data);
                }
            });
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        try {
            this.stopAnimation();
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            themeManager.removePropertyChangeListener(this.themeChangeListenr);
            ITheme theme = themeManager.getCurrentTheme();
            theme.removePropertyChangeListener(this.themeChangeListenr);
            this.prefs.removePropertyChangeListener(this.prefChangeListenr);
            CorePlugin.getRepository().miscMessagesList().removeCollectionObserver(this);
            this.tickerData.removeCollectionObserver(this);
            if (this.content != null && !this.content.isDisposed()) {
                if (this.mouseClickListener != null) {
                    this.content.removeMouseListener(this.mouseClickListener);
                }
                this.content.removeMouseTrackListener(this.mouseTrackListener);
                int i = 0;
                while (i < this.tickerData.size()) {
                    this.removeLabel((TickerData)this.tickerData.get(i));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    class RefreshThread
    extends Thread {
        RefreshThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(TickerView.this.timeInterval);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (TickerView.this.parent == null || TickerView.this.parent.isDisposed()) continue;
                TickerView.this.parent.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TickerView.this.animate();
                    }
                });
            }
        }
    }
}

