/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.views;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.ui.dialogs.CurrencyConversionDialog;

public class CurrencyExchangeView
extends ViewPart
implements Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.views.currencies";
    private Color evenForeground = new Color(null, 0, 0, 0);
    private Color evenBackground = new Color(null, 255, 255, 255);
    private Color oddForeground = new Color(null, 0, 0, 0);
    private Color oddBackground = new Color(null, 210, 240, 210);
    private Table table;
    private NumberFormat nf = NumberFormat.getInstance();

    public CurrencyExchangeView() {
        this.nf.setGroupingUsed(true);
        this.nf.setMinimumIntegerDigits(1);
        this.nf.setMinimumFractionDigits(4);
        this.nf.setMaximumFractionDigits(4);
    }

    public void init(IViewSite site) throws PartInitException {
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("begin"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("group6"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("end"));
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        this.table = new Table(content, 65536);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrencyExchangeView.this.table.deselectAll();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CurrencyExchangeView.this.table.deselectAll();
            }

            public void mouseDoubleClick(MouseEvent e) {
                Point pt = new Point(e.x, e.y);
                TableItem tableItem = CurrencyExchangeView.this.table.getItem(pt);
                if (tableItem != null) {
                    String to;
                    String from;
                    int columnIndex = -1;
                    int x = 0;
                    int i = 0;
                    while (i < CurrencyExchangeView.this.table.getColumnCount()) {
                        if (pt.x >= x && pt.x < x + CurrencyExchangeView.this.table.getColumn(i).getWidth()) {
                            columnIndex = i;
                        }
                        x += CurrencyExchangeView.this.table.getColumn(i).getWidth();
                        ++i;
                    }
                    if (columnIndex != -1 && !(from = tableItem.getText(0)).equals(to = CurrencyExchangeView.this.table.getColumn(columnIndex).getText()) && from.length() != 0 && to.length() != 0) {
                        CurrencyConversionDialog dlg = new CurrencyConversionDialog(CurrencyExchangeView.this.getSite().getShell(), from, to);
                        dlg.open();
                    }
                }
            }
        });
        new TableColumn(this.table, 0);
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CurrencyExchangeView.this.updateView();
                CurrencyConverter.getInstance().addObserver(CurrencyExchangeView.this);
            }
        });
    }

    public void setFocus() {
        this.table.getParent().setFocus();
    }

    public void dispose() {
        CurrencyConverter.getInstance().deleteObserver(this);
        this.evenForeground.dispose();
        this.evenBackground.dispose();
        this.oddForeground.dispose();
        this.oddBackground.dispose();
        super.dispose();
    }

    public void updateView() {
        this.table.setRedraw(false);
        List currencies = CurrencyConverter.getInstance().getCurrencies();
        Collections.sort(currencies, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((String)arg0).compareTo((String)arg1);
            }
        });
        int index = 1;
        Iterator iter = currencies.iterator();
        while (iter.hasNext()) {
            TableColumn column = null;
            column = index < this.table.getColumnCount() ? this.table.getColumn(index) : new TableColumn(this.table, 131072);
            column.setText((String)iter.next());
            ++index;
        }
        while (this.table.getColumnCount() > index) {
            this.table.getColumn(index).dispose();
        }
        index = 0;
        for (String symbol : currencies) {
            TableItem tableItem = null;
            tableItem = index < this.table.getItemCount() ? this.table.getItem(index) : new TableItem(this.table, 0);
            tableItem.setText(0, symbol);
            int i = 0;
            while (i < currencies.size()) {
                if (i != index) {
                    tableItem.setText(i + 1, this.nf.format(CurrencyConverter.getInstance().convert(1.0, symbol, (String)currencies.get(i))));
                }
                ++i;
            }
            tableItem.setBackground(0, tableItem.getDisplay().getSystemColor(22));
            tableItem.setBackground((index & 1) == 1 ? this.oddBackground : this.evenBackground);
            tableItem.setForeground((index & 1) == 1 ? this.oddForeground : this.evenForeground);
            ++index;
        }
        this.table.setItemCount(index);
        this.table.setRedraw(true);
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.getColumn(0).setWidth(this.table.getColumn(0).getWidth() + 5);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CurrencyExchangeView.this.table.isDisposed()) {
                        CurrencyExchangeView.this.updateView();
                    }
                }
            });
        }
    }
}

