/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class ProxyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enableHttpProxy;
    private Text httpProxyHostText;
    private Text httpProxyPortText;
    private Label httpProxyHostLabel;
    private Label httpProxyPortLabel;
    private Button enableProxyAuthentication;
    private Text httpProxyUserText;
    private Text httpProxyPasswordText;
    private Label httpProxyUserLabel;
    private Label httpProxyPasswordLabel;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        Group group = new Group(content, 0);
        group.setText(Messages.ProxyPreferencePage_Settings);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.enableHttpProxy = new Button((Composite)group, 32);
        this.enableHttpProxy.setText(Messages.ProxyPreferencePage_EnableHTTP);
        this.enableHttpProxy.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.enableHttpProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyPreferencePage.this.updateControlsEnablement();
            }
        });
        this.httpProxyHostLabel = new Label((Composite)group, 0);
        this.httpProxyHostLabel.setText(Messages.ProxyPreferencePage_HostAddress);
        this.httpProxyHostText = new Text((Composite)group, 2048);
        this.httpProxyHostText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.httpProxyPortLabel = new Label((Composite)group, 0);
        this.httpProxyPortLabel.setText(Messages.ProxyPreferencePage_HostPort);
        this.httpProxyPortText = new Text((Composite)group, 2048);
        this.httpProxyPortText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.httpProxyPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    String portValue = ProxyPreferencePage.this.httpProxyPortText.getText();
                    int num = 80;
                    if (portValue != null && portValue.trim().length() > 0) {
                        num = Integer.valueOf(portValue);
                    }
                    if (num >= 0 && num <= 65535) {
                        ProxyPreferencePage.this.setValid(true);
                        ProxyPreferencePage.this.setErrorMessage(null);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ProxyPreferencePage.this.setValid(false);
                ProxyPreferencePage.this.setErrorMessage(Messages.ProxyPreferencePage_PortErrorMessage);
            }
        });
        this.enableProxyAuthentication = new Button((Composite)group, 32);
        this.enableProxyAuthentication.setText(Messages.ProxyPreferencePage_EnableAuthentication);
        this.enableProxyAuthentication.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.enableProxyAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProxyPreferencePage.this.updateControlsEnablement();
            }
        });
        this.httpProxyUserLabel = new Label((Composite)group, 0);
        this.httpProxyUserLabel.setText(Messages.ProxyPreferencePage_Username);
        this.httpProxyUserText = new Text((Composite)group, 2048);
        this.httpProxyUserText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.httpProxyPasswordLabel = new Label((Composite)group, 0);
        this.httpProxyPasswordLabel.setText(Messages.ProxyPreferencePage_Password);
        this.httpProxyPasswordText = new Text((Composite)group, 0x400800);
        this.httpProxyPasswordText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        IPreferenceStore store = CorePlugin.getDefault().getPreferenceStore();
        this.enableHttpProxy.setSelection(store.getBoolean("ENABLE_HTTP_PROXY"));
        this.httpProxyHostText.setText(store.getString("PROXY_HOST_ADDRESS"));
        this.httpProxyPortText.setText(store.getString("PROXY_PORT_ADDRESS"));
        this.enableProxyAuthentication.setSelection(store.getBoolean("ENABLE_PROXY_AUTHENTICATION"));
        this.httpProxyUserText.setText(store.getString("PROXY_USER"));
        this.httpProxyPasswordText.setText(store.getString("PROXY_PASSWORD"));
        this.updateControlsEnablement();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = CorePlugin.getDefault().getPreferenceStore();
        store.setValue("ENABLE_HTTP_PROXY", this.enableHttpProxy.getSelection());
        store.setValue("PROXY_HOST_ADDRESS", this.httpProxyHostText.getText());
        store.setValue("PROXY_PORT_ADDRESS", this.httpProxyPortText.getText());
        store.setValue("ENABLE_PROXY_AUTHENTICATION", this.enableProxyAuthentication.getSelection());
        store.setValue("PROXY_USER", this.httpProxyUserText.getText());
        store.setValue("PROXY_PASSWORD", this.httpProxyPasswordText.getText());
        return super.performOk();
    }

    protected void updateControlsEnablement() {
        this.httpProxyPortLabel.setEnabled(this.enableHttpProxy.getSelection());
        this.httpProxyHostLabel.setEnabled(this.enableHttpProxy.getSelection());
        this.httpProxyPortText.setEnabled(this.enableHttpProxy.getSelection());
        this.httpProxyHostText.setEnabled(this.enableHttpProxy.getSelection());
        this.enableProxyAuthentication.setEnabled(this.enableHttpProxy.getSelection());
        this.httpProxyUserLabel.setEnabled(this.enableProxyAuthentication.getSelection() && this.enableProxyAuthentication.isEnabled());
        this.httpProxyPasswordLabel.setEnabled(this.enableProxyAuthentication.getSelection() && this.enableProxyAuthentication.isEnabled());
        this.httpProxyUserText.setEnabled(this.enableProxyAuthentication.getSelection() && this.enableProxyAuthentication.isEnabled());
        this.httpProxyPasswordText.setEnabled(this.enableProxyAuthentication.getSelection() && this.enableProxyAuthentication.isEnabled());
    }
}

