/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class LoggerPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button console;
    Button file;
    Combo format;
    Combo rootLogger;
    Map loggers = new HashMap();
    IExtensionRegistry registry;
    IExtensionPoint extensionPoint;
    PreferenceStore preferences = new PreferenceStore();

    public void init(IWorkbench workbench) {
        this.preferences.setFilename(CorePlugin.getDefault().getStateLocation().append("log4j.properties").toOSString());
        this.registry = Platform.getExtensionRegistry();
        this.extensionPoint = this.registry.getExtensionPoint("pk.com.softech.tradingterminal.core.loggingPreferences");
        IConfigurationElement[] members = this.extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < members.length) {
            IConfigurationElement element = members[i];
            if (element.getName().equals("logger") && element.getAttribute("defaultValue") != null) {
                String[] item = element.getAttribute("name").split(";");
                int n = 0;
                while (n < item.length) {
                    this.preferences.setDefault("log4j.logger." + item[n], element.getAttribute("defaultValue"));
                    ++n;
                }
            }
            ++i;
        }
        try {
            URL url = CorePlugin.getDefault().getBundle().getResource("log4j.properties");
            Properties properties = new Properties();
            properties.load(url.openStream());
            for (String string : properties.keySet()) {
                this.preferences.setDefault(string, (String)properties.get(string));
            }
            File file = CorePlugin.getDefault().getStateLocation().append("log4j.properties").toFile();
            if (file.exists()) {
                this.preferences.load((InputStream)new FileInputStream(file));
            }
        }
        catch (Exception e) {
            CorePlugin.logException(e);
        }
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        String rootValue = this.preferences.getString("log4j.rootLogger");
        String currentPattern = this.preferences.getString("log4j.appender.stdout.layout.ConversionPattern");
        this.console = new Button(content, 32);
        this.console.setText(Messages.LoggerPreferencesPage_WriteToConsole);
        this.console.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        if (rootValue != null && rootValue.indexOf("stdout") != -1) {
            this.console.setSelection(true);
        }
        this.file = new Button(content, 32);
        this.file.setText(Messages.LoggerPreferencesPage_WriteToFile);
        this.file.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        if (rootValue != null && rootValue.indexOf("file") != -1) {
            this.file.setSelection(true);
        }
        Label label = new Label(content, 0);
        label.setText(Messages.LoggerPreferencesPage_Format);
        label.setLayoutData((Object)new GridData(107, -1));
        this.format = new Combo(content, 8);
        this.format.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.format.add(Messages.LoggerPreferencesPage_Default);
        this.format.setData(String.valueOf(this.format.getItemCount() - 1), (Object)Messages.LoggerPreferencesPage_DefaultPattern);
        Group group = new Group(content, 512);
        group.setText(Messages.LoggerPreferencesPage_Levels);
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)group.getLayoutData()).heightHint = 200;
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 3;
        group.setLayout((Layout)gridLayout);
        this.rootLogger = LoggerPreferencesPage.createLevelCombo((Composite)group, Messages.LoggerPreferencesPage_General, this.preferences.getString("log4j.rootLogger"));
        List<IConfigurationElement> list = Arrays.asList(this.extensionPoint.getConfigurationElements());
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((IConfigurationElement)arg0).getAttribute("description").compareTo(((IConfigurationElement)arg1).getAttribute("description"));
            }
        });
        IConfigurationElement[] members = list.toArray(new IConfigurationElement[list.size()]);
        int i = 0;
        while (i < members.length) {
            IConfigurationElement element = members[i];
            if (element.getName().equals("logger") && this.loggers.get(element.getAttribute("name")) == null) {
                String[] item = element.getAttribute("name").split(";");
                Combo combo = LoggerPreferencesPage.createLevelCombo((Composite)group, element.getAttribute("description"), this.preferences.getString("log4j.logger." + item[0]));
                combo.setData("logger", (Object)element.getAttribute("name"));
                this.loggers.put(element.getAttribute("name"), combo);
            } else if (element.getName().equals("layout")) {
                this.format.setData(String.valueOf(this.format.getItemCount()), (Object)element.getAttribute("pattern"));
                this.format.add(element.getAttribute("description"));
                if (element.getAttribute("pattern").equals(currentPattern)) {
                    this.format.select(this.format.getItemCount() - 1);
                }
            }
            ++i;
        }
        if (this.format.getSelectionIndex() == -1) {
            this.format.select(0);
        }
        return content;
    }

    public boolean performOk() {
        String pattern = (String)this.format.getData(String.valueOf(this.format.getSelectionIndex()));
        if (pattern != null) {
            this.preferences.setValue("log4j.appender.stdout.layout.ConversionPattern", pattern);
            this.preferences.setValue("log4j.appender.file.layout.ConversionPattern", pattern);
        }
        String root = (String)this.rootLogger.getData(String.valueOf(this.rootLogger.getSelectionIndex()));
        if (this.console.getSelection()) {
            root = String.valueOf(root) + ", stdout";
        }
        if (this.file.getSelection()) {
            root = String.valueOf(root) + ", file";
        }
        this.preferences.setValue("log4j.rootLogger", root);
        for (String logger : this.loggers.keySet()) {
            Combo combo = (Combo)this.loggers.get(logger);
            if (combo.getData(String.valueOf(combo.getSelectionIndex())) == null) continue;
            String[] item = logger.split(";");
            int x = 0;
            while (x < item.length) {
                this.preferences.setValue("log4j.logger." + item[x], (String)combo.getData(String.valueOf(combo.getSelectionIndex())));
                ++x;
            }
        }
        try {
            this.preferences.save();
        }
        catch (Exception e) {
            CorePlugin.logException(e);
        }
        CorePlugin.getDefault().configureLogging();
        return super.performOk();
    }

    public static Combo createLevelCombo(Composite parent, String text, String value) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Combo level = new Combo(parent, 8);
        level.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        level.setData(String.valueOf(level.getItemCount()), (Object)"off");
        level.add(Messages.LoggerPreferencesPage_Off);
        level.setData(String.valueOf(level.getItemCount()), (Object)"fatal");
        level.add(Messages.LoggerPreferencesPage_Fatal);
        level.setData(String.valueOf(level.getItemCount()), (Object)"error");
        level.add(Messages.LoggerPreferencesPage_Error);
        level.setData(String.valueOf(level.getItemCount()), (Object)"warn");
        level.add(Messages.LoggerPreferencesPage_Warn);
        level.setData(String.valueOf(level.getItemCount()), (Object)"info");
        level.add(Messages.LoggerPreferencesPage_Info);
        level.setData(String.valueOf(level.getItemCount()), (Object)"debug");
        level.add(Messages.LoggerPreferencesPage_Debug);
        level.setData(String.valueOf(level.getItemCount()), (Object)"all");
        level.add(Messages.LoggerPreferencesPage_All);
        if (value != null) {
            int i = 0;
            while (i < level.getItemCount()) {
                if (value.indexOf((String)level.getData(String.valueOf(i))) != -1) {
                    level.select(i);
                }
                ++i;
            }
        }
        return level;
    }
}

