/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class CurrencyPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button autoUpdate;
    Table table;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        TableItem tableItem;
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.autoUpdate = new Button(content, 32);
        this.autoUpdate.setText("Update currencies when starting feed");
        this.autoUpdate.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.autoUpdate.setSelection(CorePlugin.getDefault().getPreferenceStore().getBoolean("UPDATE_CURRENCIES"));
        this.table = new Table(content, 65572);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 250;
        this.table.setLayoutData((Object)gridData);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(Messages.CurrencyPreferencesPage_Country);
        column = new TableColumn(this.table, 0);
        column.setText(Messages.CurrencyPreferencesPage_Code);
        ArrayList<Locale> available = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        Collections.sort(available, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Locale)arg0).getDisplayCountry().compareTo(((Locale)arg1).getDisplayCountry());
            }
        });
        int i = available.size() - 1;
        while (i >= 1) {
            if (((Locale)available.get(i)).getDisplayCountry().equals(((Locale)available.get(i - 1)).getDisplayCountry())) {
                available.remove(i);
            }
            --i;
        }
        List enabled = CurrencyConverter.getInstance().getCurrencies();
        Currency currency = Currency.getInstance("PKR");
        if (currency != null) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, "Pakistan");
            tableItem.setText(1, currency.getCurrencyCode());
            tableItem.setChecked(enabled.contains(currency.getCurrencyCode()));
            tableItem.setData((Object)currency);
        }
        if ((currency = Currency.getInstance("GHS")) != null) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, "Ghana");
            tableItem.setText(1, currency.getCurrencyCode());
            tableItem.setChecked(enabled.contains(currency.getCurrencyCode()));
            tableItem.setData((Object)currency);
        }
        int i2 = 0;
        while (i2 < available.size()) {
            try {
                Locale locale = (Locale)available.get(i2);
                currency = Currency.getInstance(locale);
                if (currency != null) {
                    TableItem tableItem2 = new TableItem(this.table, 0);
                    tableItem2.setText(0, locale.getDisplayCountry());
                    tableItem2.setText(1, currency.getCurrencyCode());
                    tableItem2.setChecked(enabled.contains(currency.getCurrencyCode()));
                    tableItem2.setData((Object)currency);
                }
            }
            catch (Exception exception) {}
            ++i2;
        }
        i2 = 0;
        while (i2 < this.table.getColumnCount()) {
            this.table.getColumn(i2).pack();
            ++i2;
        }
        return content;
    }

    public boolean performOk() {
        ArrayList<String> enabled = new ArrayList<String>();
        CorePlugin.getDefault().getPreferenceStore().setValue("UPDATE_CURRENCIES", this.autoUpdate.getSelection());
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            String code;
            if (items[i].getChecked() && !enabled.contains(code = ((Currency)items[i].getData()).getCurrencyCode())) {
                enabled.add(code);
            }
            ++i;
        }
        CurrencyConverter.getInstance().setCurrencies(enabled);
        Job job = new Job(Messages.CurrencyPreferencesPage_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                return CurrencyConverter.getInstance().updateExchanges(monitor);
            }
        };
        job.setUser(false);
        job.schedule();
        return super.performOk();
    }
}

