/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import pk.com.softech.messages.HousePerformanceRequest;
import pk.com.softech.messages.HousePerformanceResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;

public class TargetSaleDialog
extends Dialog
implements ICollectionObserver {
    private String browserString;
    Color gray;
    private StringBuilder template;
    private Composite composite;
    private Browser browser;

    public TargetSaleDialog(Shell parentShell) {
        super(parentShell);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver(this);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 980;
        data.heightHint = 740;
        this.composite.setLayoutData((Object)data);
        Display shell = parent.getDisplay();
        this.gray = shell.getSystemColor(22);
        String hex = String.format("#%02x%02x%02x", this.gray.getRed(), this.gray.getGreen(), this.gray.getBlue());
        this.browserString = "<body bgcolor='" + hex + "'><h2>Please wait Dashboard is loading...</h2></body>";
        this.browser = new Browser(this.composite, 0);
        this.browser.setText(this.browserString);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Resources.dashboardTemplateStr == null) {
                        Resources.dashboardTemplateStr = TargetSaleDialog.this.loadTemplate();
                    }
                    TargetSaleDialog.this.sendTargetSaleViewRequest();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return this.composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Target Sale Dashboard");
    }

    public void okPressed() {
        this.close();
    }

    public boolean close() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver(this);
        return super.close();
    }

    @Override
    public void itemAdded(Object o) {
        final Object obj = o;
        try {
            if (!this.composite.isDisposed()) {
                this.composite.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (obj instanceof HousePerformanceResponse) {
                            String template = Resources.dashboardTemplateStr;
                            template = TargetSaleDialog.this.updateDialogContent((HousePerformanceResponse)obj);
                            if (TargetSaleDialog.this.browser != null && !"".equalsIgnoreCase(template)) {
                                TargetSaleDialog.this.browser.setText(template);
                            } else {
                                TargetSaleDialog.this.browser.setText("No Valid Respose Yield!");
                            }
                        }
                    }
                });
            }
        }
        catch (Exception exception) {}
    }

    public String loadTemplate() throws IOException {
        if (this.template != null) {
            return this.template.toString();
        }
        File file = new File(Platform.getLocation().toFile(), "HousePerformanceTemplate.html");
        if (file.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                this.template = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    this.template.append(line);
                    this.template.append("\n");
                    line = br.readLine();
                }
                String string = this.template.toString();
                return string;
            }
        }
        return "";
    }

    private String updateDialogContent(HousePerformanceResponse obj) {
        String str = "";
        if (Resources.dashboardTemplateStr != null && obj != null) {
            str = Resources.dashboardTemplateStr;
            Long temp = (Long)((Object)Utility.getValueOrDefault(obj.getDailyVolume(), 0));
            String tempStr = Utility.getMillionString(temp);
            str = str.replace("#daillyVol#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getMonthlyVolume(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#monthVol#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getTargetVolume(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#targetVol#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getDailyValue(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#daillyValue#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getMonthlyValue(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#monthValue#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getTargetValue(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#targetValue#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getDailyTrades(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#daillyTrades#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getMonthlyTrades(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#monthTrades#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getTargetTrades(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#targetTrades#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getDailyClients(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#daillyClients#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getMonthlyClients(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#monthClients#", tempStr);
            temp = (Long)((Object)Utility.getValueOrDefault(obj.getTargetClients(), 0));
            tempStr = Utility.getMillionString(temp);
            str = str.replace("#targetClients#", tempStr);
            tempStr = Utility.getValueOrDefault(obj.getTraderOfTheMonth(), "N/A").toString();
            str = str.replace("#traderMonth#", tempStr);
            tempStr = Utility.getValueOrDefault(obj.getTraderOfLastTheMonth(), "N/A").toString();
            str = str.replace("#traderLMonth#", tempStr);
            Long perValue = obj.getPerVolume();
            String curColor = "#4caf50";
            curColor = perValue != null && perValue > 0L ? "#4caf50" : "#d93025";
            tempStr = ((Number)Utility.getValueOrDefault(perValue, 0)).toString();
            str = str.replace("#percVol#", String.valueOf(tempStr) + '%');
            str = str.replace("#percVolColor#", curColor);
            perValue = obj.getPerValue();
            curColor = perValue != null && perValue > 0L ? "#4caf50" : "#d93025";
            tempStr = ((Number)Utility.getValueOrDefault(perValue, 0)).toString();
            str = str.replace("#percVal#", String.valueOf(tempStr) + '%');
            str = str.replace("#percValColor#", curColor);
            perValue = obj.getPerTrades();
            curColor = perValue != null && perValue > 0L ? "#4caf50" : "#d93025";
            tempStr = ((Number)Utility.getValueOrDefault(perValue, 0)).toString();
            str = str.replace("#percTrades#", String.valueOf(tempStr) + '%');
            str = str.replace("#percTradesColor#", curColor);
            perValue = obj.getPerClients();
            curColor = perValue != null && perValue > 0L ? "#4caf50" : "#d93025";
            tempStr = ((Number)Utility.getValueOrDefault(perValue, 0)).toString();
            str = str.replace("#percClients#", String.valueOf(tempStr) + '%');
            str = str.replace("#percClientsColor#", curColor);
        }
        return str;
    }

    public void sendTargetSaleViewRequest() {
        try {
            HousePerformanceRequest request = new HousePerformanceRequest();
            if (Resources.getServerLink("", false, true).writeData(request)) {
                System.out.println("Request has been sent");
            } else {
                MessageDialog.openError(null, (String)"Connection Error", (String)"You seem to be disconnected from the server. \n Please re-connect again from the file menu.");
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void itemRemoved(Object o) {
    }
}

