/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class SpeedDialog
extends Dialog {
    private Composite content;
    private Button rbLeftToRight;
    private Button rbRightToLeft;
    private Scale speedSlider;
    private Spinner spnrYlocation;
    IPreferenceStore store;
    String propDirection = "";
    String propSpeed = "";
    String verticalPostion = "";
    private int speed = 20;
    private int minSpeed = 50;
    private int maxSpeed = 60;

    public SpeedDialog(Shell parentShell, IPreferenceStore store, String propDirection, String propSpeed, String verticalPostion, int minSpeed, int maxSpeed) {
        super(parentShell);
        this.store = store;
        this.propDirection = propDirection;
        this.propSpeed = propSpeed;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.verticalPostion = verticalPostion;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Speed Setting");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new GridLayout(2, true));
        this.rbLeftToRight = new Button(this.content, 16);
        this.rbLeftToRight.setText("Left To Righ");
        this.rbLeftToRight.setSelection(this.store.getBoolean(this.propDirection));
        this.rbLeftToRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                SpeedDialog.this.store.setValue(SpeedDialog.this.propDirection, SpeedDialog.this.rbLeftToRight.getSelection());
            }
        });
        this.rbRightToLeft = new Button(this.content, 16);
        this.rbRightToLeft.setText("Righ To Left");
        this.rbRightToLeft.setSelection(!this.store.getBoolean(this.propDirection));
        this.speedSlider = new Scale(this.content, 256);
        this.speedSlider.setLayoutData((Object)new GridData(-1, -1, true, false, 2, 1));
        this.speedSlider.setMinimum(this.minSpeed);
        this.speedSlider.setMaximum(this.maxSpeed);
        this.speed = this.store.getInt(this.propSpeed);
        this.speedSlider.setSelection(this.maxSpeed - this.speed + this.minSpeed);
        this.speedSlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int newSpeed = SpeedDialog.this.maxSpeed - SpeedDialog.this.speedSlider.getSelection() + SpeedDialog.this.minSpeed;
                SpeedDialog.this.speed = newSpeed < SpeedDialog.this.minSpeed ? SpeedDialog.this.minSpeed : newSpeed;
                SpeedDialog.this.store.setValue(SpeedDialog.this.propSpeed, SpeedDialog.this.speed);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblSpiner = new Label(this.content, 0);
        lblSpiner.setText("Vertical Position :");
        this.spnrYlocation = new Spinner(this.content, 2048);
        this.spnrYlocation.setSelection(this.store.getInt(this.verticalPostion));
        this.spnrYlocation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int yPosition = Integer.parseInt(SpeedDialog.this.spnrYlocation.getText());
                SpeedDialog.this.store.setValue(SpeedDialog.this.verticalPostion, yPosition);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return this.content;
    }
}

