/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;

public class LockApplicationDialog
extends TitleAreaDialog {
    private String passwordStr = "";
    private Text txtPassword;

    public LockApplicationDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Unlock Application");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Application Locked");
        this.setMessage("Please enter your password to unlock application.");
        Image image = CorePlugin.getImageDescriptor("icons/key.gif").createImage();
        this.setTitleImage(image);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createButton(parent, 0, "Unlock", false);
        this.createButton(parent, 1, "Logout", false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Password");
        this.txtPassword = new Text(composite, 0x400800);
        this.txtPassword.setText(this.passwordStr);
        this.txtPassword.setLayoutData((Object)new GridData(200, -1));
        this.txtPassword.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                LockApplicationDialog.this.txtPassword.selectAll();
            }
        });
        this.txtPassword.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    LockApplicationDialog.this.okPressed();
                }
            }
        });
        return super.createDialogArea(parent);
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    public int open() {
        this.create();
        if (Resources.timer != null) {
            Resources.timer.stop();
            Resources.lockDialogOpened = true;
        }
        return super.open();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void okPressed() {
        this.passwordStr = this.txtPassword.getText();
        if (!this.loginValidation()) {
            this.txtPassword.setFocus();
            return;
        }
        if (!this.passwordStr.equals(Resources.password)) {
            MessageDialog.openError(null, (String)"Invalid Password", (String)"Please enter your valid password.");
            this.txtPassword.setFocus();
            return;
        }
        if (Resources.timer != null) {
            Resources.timer.start();
        }
        super.okPressed();
        Resources.lockDialogOpened = false;
    }

    protected void cancelPressed() {
        CorePlugin.closeSockets();
        super.cancelPressed();
        Resources.lockDialogOpened = false;
    }

    private boolean loginValidation() {
        try {
            if (this.passwordStr.equals("")) {
                MessageDialog.openError(null, (String)"Unlock Application", (String)"Please enter your password.");
                this.txtPassword.setFocus();
                return false;
            }
        }
        catch (Exception exception) {}
        return true;
    }
}

