/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.Resources;

public class LiveAnnouncementsDialog {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.liveAnnouncement";
    public static Shell shell = null;
    public static boolean isRunning = false;
    public Display display = null;

    public LiveAnnouncementsDialog() {
        if (Resources.loginStatus && Resources.trnCode.contains("OV27")) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                this.createMediaPlayerDialog();
            } else {
                this.openAnnouncementLink();
            }
        }
    }

    public void createMediaPlayerDialog() {
        if (!isRunning) {
            try {
                this.display = PlatformUI.getWorkbench().getDisplay();
                shell = new Shell(this.display, 128);
                shell.setText("Window Media Player ");
                shell.setLayout((Layout)new FillLayout());
                shell.setSize(300, 300);
                shell.addListener(21, new Listener(){

                    public void handleEvent(Event event) {
                        shell.dispose();
                        isRunning = false;
                    }
                });
                isRunning = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                isRunning = false;
            }
        }
    }

    public void openAnnouncementLink() {
        try {
            String fileURL = "http://www.psx.com.pk/phps/announce.m3u";
            URL url = new URL(fileURL);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                InputStream inputStream = httpConn.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line.toString());
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(line));
                }
                inputStream.close();
                br.close();
            } else {
                System.out.println("No Announcement Link Found ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        if (isRunning) {
            shell.open();
        }
    }

    static void fileOpen() {
    }

    public static void stop() {
        Display display;
        if (isRunning && (display = Display.getCurrent()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    shell.close();
                }
            });
        }
    }
}

