/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.FeedbackRequest;
import pk.com.softech.messages.FeedbackResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.util.ProductNames;

public class Feedback
extends Dialog
implements ICollectionObserver {
    Text txtComments;
    String userComments = null;
    private Text txtFileName;
    private Logger logger = Logger.getLogger(Feedback.class);
    private FileDialog fd;
    private FeedbackRequest feedBackReq;
    private Label txtStatus;

    public Feedback() {
        super(Display.getDefault().getActiveShell());
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver(this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.createButton(parent, 0, "Submit", false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected Control createDialogArea(Composite parent) {
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout grid = new GridLayout();
        composite.setLayout((Layout)grid);
        Label label = new Label(composite, 0);
        label.setText("Please submit your Feedback");
        Label limitLabel = new Label(composite, 0);
        String limitStr = "* Maximum limit is 350 characters. Provide * Userid * Email";
        if (Resources.PRODUCT_NAME != null && Resources.PRODUCT_NAME == ProductNames.LUMS) {
            limitStr = "* Maximum limit is 350 characters. Provide * Userid * Batch * Email";
        }
        limitLabel.setText(limitStr);
        Color clr = new Color((Device)parent.getDisplay(), 255, 0, 0);
        limitLabel.setForeground(clr);
        GridData gdMultyLine = new GridData(1808);
        gdMultyLine.heightHint = 5 * fontMetrics.getHeight();
        this.txtComments = new Text(composite, 2882);
        this.txtComments.setLayoutData((Object)gdMultyLine);
        this.txtComments.setTextLimit(350);
        Composite compositeFile = new Composite(composite, 0);
        compositeFile.setLayoutData((Object)new GridData(4, 4, true, true));
        compositeFile.setLayout((Layout)new GridLayout(5, false));
        final Shell shell = new Shell(composite.getDisplay());
        this.feedBackReq = new FeedbackRequest();
        this.txtFileName = new Text(compositeFile, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        this.txtFileName.setLayoutData((Object)data);
        Button open = new Button(compositeFile, 8);
        open.setText("Open...");
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Feedback.this.importFile(shell);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        GridData gridThreeSpan = new GridData();
        gridThreeSpan.grabExcessHorizontalSpace = false;
        gridThreeSpan.horizontalSpan = 1;
        this.txtStatus = new Label(composite, 0);
        this.txtStatus.setLayoutData((Object)gridThreeSpan);
        return area;
    }

    protected void importFile(Shell sh) throws IOException {
        this.fd = new FileDialog(sh, 4096);
        this.fd.setText("Select Feed Back Attachment");
        String[] filterExt = new String[]{"*.*", "*.jpg", "*.png", "*.txt", "*.doc", ".rtf", "*.csv", "*.jpeg", "*.gif", "*.pdf"};
        String[] filterNames = new String[]{"All files", "jpg", "png", "txt", "doc", "rtf", "csv", "jpeg", "gif", "pdf"};
        this.fd.setFilterExtensions(filterExt);
        this.fd.setFilterNames(filterNames);
        String filePath = this.fd.open();
        if (filePath != null) {
            try {
                File importFile = new File(filePath);
                if (importFile == null && !importFile.exists()) {
                    return;
                }
                String fileName = importFile.getName();
                int i = fileName.lastIndexOf(46);
                String fileExt = "";
                if (i >= 0) {
                    fileExt = fileName.substring(i + 1);
                }
                boolean found = false;
                if (!"".equalsIgnoreCase(fileExt)) {
                    String[] stringArray = filterNames;
                    int n = filterNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        if (element.equals(fileExt)) {
                            found = true;
                            this.txtFileName.setText(filePath);
                            int length = (int)importFile.length();
                            byte[] bytes = new byte[length];
                            FileInputStream inputStreamFile = new FileInputStream(importFile);
                            ((InputStream)inputStreamFile).read(bytes);
                            this.feedBackReq.setFileType("image/" + fileExt);
                            this.feedBackReq.setAttachment(bytes);
                            return;
                        }
                        ++n2;
                    }
                    if (!found) {
                        MessageDialog.openInformation(null, (String)"Not Allowed", (String)("Invalid File Extension: " + fileExt));
                    }
                } else {
                    MessageDialog.openInformation(null, (String)"Alert", (String)"No File found in System!");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.error((Object)"File not found. ");
            }
        }
    }

    public boolean fieldValidation() {
        if (this.txtComments == null || this.txtComments.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Please Give Your Feedback");
            return false;
        }
        return true;
    }

    public boolean feedbackValidation(String msg) {
        ArrayList<String> words = new ArrayList<String>();
        words.add("Ass");
        words.add("Bum");
        words.add("Arsehole");
        words.add("Butthole");
        words.add("Ass boy");
        words.add("Assfuck");
        words.add("Asswipe");
        words.add("Bang");
        words.add("Bastard");
        words.add("Berk");
        words.add("Biatch");
        words.add("Bitch");
        words.add("bloody hell");
        words.add("blow job");
        words.add("BOB");
        words.add("Boob");
        words.add("Buns");
        words.add("Cock");
        words.add("Cocksmoker");
        words.add("Cocksucker");
        words.add("Cum");
        words.add("Dick");
        words.add("Dork");
        words.add("Shit");
        words.add("Finger fuck");
        words.add("Fist fuck");
        words.add("French kiss");
        words.add("Fuck around");
        words.add("Fuck off\t");
        words.add("cockknoker");
        words.add("dickhole");
        words.add("dumshit");
        words.add("dildo");
        words.add("dickface");
        words.add("fuckin");
        words.add("gayass");
        words.add("gay");
        words.add("kooch");
        words.add("motherfucker");
        words.add("motherfucking");
        words.add("munging");
        words.add("pussylicking");
        words.add("queer");
        words.add("queerhole");
        words.add("rimjob");
        words.add("shitty");
        words.add("slut");
        words.add("slutbag");
        words.add("shitter");
        words.add("shittiest");
        words.add("skeet");
        words.add("shithouse");
        words.add("shitass");
        words.add("unclefucker");
        words.add("vagina");
        words.add("son of a bitch");
        words.add("Brat");
        words.add("Fuck up");
        words.add("Fucker");
        words.add("Tits");
        words.add("Pussy");
        words.add("Bitches");
        words.add("Bitchy");
        words.add("brotherfucker");
        words.add("Bullshit");
        words.add("Homosexual");
        words.add("Lesbians");
        words.add("Buttfucker");
        words.add("Boner");
        words.add("ass-hat");
        words.add("asssucker");
        words.add("sucker");
        words.add("cockass");
        int i = 0;
        while (i < words.size()) {
            if (msg.toUpperCase().contains(((String)words.get(i)).toUpperCase())) {
                MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Your Feedback could not be submitted because it contains some slang words");
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void cancelPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver(this);
        super.cancelPressed();
    }

    public boolean close() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver(this);
        return super.close();
    }

    protected void okPressed() {
        this.txtStatus.setText("");
        if (this.fieldValidation()) {
            this.userComments = this.txtComments.getText();
            if (this.feedbackValidation(this.userComments)) {
                Date date = Utility.getDate(Utility.getCurrentDate());
                if (Resources.traderId != null && Resources.userId != null) {
                    if (Resources.isServerConnected("", false, true)) {
                        this.feedBackReq.setTraderId(Resources.traderId);
                        this.feedBackReq.setUserId(Resources.userId);
                        this.feedBackReq.setDate(date);
                        this.feedBackReq.setUserComments(this.userComments);
                        if (Resources.getServerLink("", false, true).writeData(this.feedBackReq)) {
                            this.txtComments.setText("");
                            this.txtFileName.setText("");
                            this.txtStatus.setText("Request has been Sent!");
                        }
                    }
                } else {
                    MessageDialog.openInformation(null, (String)"Invalid User", (String)"Perhaps, user id or Trader id is not present.");
                }
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("User Feedback");
    }

    @Override
    public void itemAdded(final Object o) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (o instanceof FeedbackResponse) {
                    FeedbackResponse response = (FeedbackResponse)o;
                    if (response.isSubmit()) {
                        MessageDialog.openInformation(null, (String)"Confirmation", (String)response.getMessage());
                        Feedback.this.feedBackReq.setAttachment(null);
                        Feedback.this.feedBackReq.setFileType("");
                        Feedback.this.txtFileName.setText("");
                        Feedback.this.txtStatus.setText("Successfull Submitted!");
                    } else {
                        Feedback.this.txtStatus.setText("Try in some moment, Server not responding!");
                        MessageDialog.openInformation(null, (String)"Confirmation", (String)("Comments could not be submitted. " + response.getMessage()));
                    }
                }
            }
        });
    }

    @Override
    public void itemRemoved(Object o) {
    }
}

