/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class ExchangeRateDialog
extends Dialog {
    Text text;
    Combo from;
    Combo to;
    Spinner ratio;
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat dateParse = new SimpleDateFormat("dd/MM/yy");

    public ExchangeRateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ExchangeRateDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText(Messages.ExchangeRateDialog_Date);
        label.setLayoutData((Object)new GridData(60, -1));
        this.text = new Text(content, 2048);
        this.text.setSize(80, -1);
        GridData gridData = new GridData(1, 1, false, false, 5, 1);
        gridData.widthHint = 80;
        this.text.setLayoutData((Object)gridData);
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    Date date = ExchangeRateDialog.this.dateParse.parse(ExchangeRateDialog.this.text.getText());
                    ExchangeRateDialog.this.text.setText(ExchangeRateDialog.this.dateFormat.format(date));
                }
                catch (Exception exception) {
                    ExchangeRateDialog.this.text.setText(ExchangeRateDialog.this.dateFormat.format(Calendar.getInstance().getTime()));
                }
                ExchangeRateDialog.this.update();
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    try {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(ExchangeRateDialog.this.dateParse.parse(ExchangeRateDialog.this.text.getText()));
                        calendar.add(5, 1);
                        ExchangeRateDialog.this.text.setText(ExchangeRateDialog.this.dateFormat.format(calendar.getTime()));
                    }
                    catch (Exception exception) {
                        ExchangeRateDialog.this.text.setText(ExchangeRateDialog.this.dateFormat.format(Calendar.getInstance().getTime()));
                    }
                    ExchangeRateDialog.this.update();
                } else if (e.keyCode == 0x1000002) {
                    try {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(ExchangeRateDialog.this.dateParse.parse(ExchangeRateDialog.this.text.getText()));
                        calendar.add(5, -1);
                        ExchangeRateDialog.this.text.setText(ExchangeRateDialog.this.dateFormat.format(calendar.getTime()));
                    }
                    catch (Exception exception) {
                        ExchangeRateDialog.this.text.setText(ExchangeRateDialog.this.dateFormat.format(Calendar.getInstance().getTime()));
                    }
                    ExchangeRateDialog.this.update();
                }
            }
        });
        label = new Label(content, 0);
        this.from = new Combo(content, 8);
        this.from.setLayoutData((Object)new GridData(4, 1, false, false));
        this.from.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExchangeRateDialog.this.update();
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.ExchangeRateDialog_To);
        this.to = new Combo(content, 8);
        this.to.setLayoutData((Object)new GridData(4, 1, false, false));
        this.to.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExchangeRateDialog.this.update();
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.ExchangeRateDialog_Equals);
        this.ratio = new Spinner(content, 2048);
        this.ratio.setMinimum(1);
        this.ratio.setMaximum(999999999);
        this.ratio.setDigits(4);
        this.ratio.setIncrement(100);
        List list = CurrencyConverter.getInstance().getCurrencies();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((String)arg0).compareTo((String)arg1);
            }
        });
        for (String symbol : list) {
            this.from.add(symbol);
            this.to.add(symbol);
        }
        this.text.setText(this.dateFormat.format(Calendar.getInstance().getTime()));
        String locale = Currency.getInstance(Locale.getDefault()).getCurrencyCode();
        this.from.setText(locale.equals(Messages.ExchangeRateDialog_DefaultTo) ? Messages.ExchangeRateDialog_DefaultFrom : Messages.ExchangeRateDialog_DefaultTo);
        this.to.setText(locale.equals(Messages.ExchangeRateDialog_DefaultTo) ? Messages.ExchangeRateDialog_DefaultTo : Messages.ExchangeRateDialog_DefaultFrom);
        this.update();
        return content;
    }

    private void update() {
        try {
            this.dateParse.parse(this.text.getText());
            Double r = null;
            if (r == null) {
                r = CurrencyConverter.getInstance().getExchangeRatio(this.from.getText(), this.to.getText());
            }
            if (r != null) {
                this.ratio.setSelection((int)(r * Math.pow(10.0, this.ratio.getDigits())));
            } else {
                this.ratio.setSelection((int)(1.0 * Math.pow(10.0, this.ratio.getDigits())));
            }
        }
        catch (Exception e) {
            this.ratio.setSelection((int)(1.0 * Math.pow(10.0, this.ratio.getDigits())));
            LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)e);
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(!this.from.getText().equals(this.to.getText()));
        }
    }

    protected void okPressed() {
        try {
            Date date = this.dateParse.parse(this.text.getText());
            double r = (double)this.ratio.getSelection() / Math.pow(10.0, this.ratio.getDigits());
            CurrencyConverter.getInstance().setExchangeRatio(date, this.from.getText(), this.to.getText(), r);
            CurrencyConverter.getInstance().setExchangeRatio(this.from.getText(), this.to.getText(), r);
        }
        catch (Exception e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).warn((Object)e);
        }
        super.okPressed();
    }
}

