/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import java.text.SimpleDateFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.Event;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class EventDetailsDialog
extends Dialog
implements ICollectionObserver {
    Event event;
    Label date;
    Label security;
    Text message;
    Text longMessage;
    Button up;
    Button down;
    boolean navigation;
    Image upImage = CorePlugin.getImageDescriptor("icons/elcl16/prev_nav.gif").createImage();
    Image downImage = CorePlugin.getImageDescriptor("icons/elcl16/next_nav.gif").createImage();
    SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private DisposeListener dialogDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            CorePlugin.getRepository().allEvents().removeCollectionObserver(EventDetailsDialog.this);
            EventDetailsDialog.this.upImage.dispose();
            EventDetailsDialog.this.downImage.dispose();
        }
    };

    public EventDetailsDialog(Event event, Shell parentShell, boolean navigation) {
        super(parentShell);
        this.event = event;
        this.navigation = navigation;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EventDetailsDialog_Title);
        newShell.addDisposeListener(this.dialogDisposeListener);
        CorePlugin.getRepository().allEvents().addCollectionObserver(this);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText(Messages.EventDetailsDialog_Date);
        label.setLayoutData((Object)new GridData(60, -1));
        this.date = new Label(content, 0);
        if (this.navigation) {
            Composite buttons = new Composite(content, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttons.setLayout((Layout)gridLayout);
            buttons.setLayoutData((Object)new GridData(1, 4, false, false, 1, 3));
            this.createNavigationButtons(buttons);
        } else {
            Label lbl = new Label(content, 0);
            lbl.setLayoutData((Object)new GridData(1, 4, false, false, 1, 3));
        }
        label = new Label(content, 0);
        label.setText(Messages.EventDetailsDialog_Security);
        label.setLayoutData((Object)new GridData(60, -1));
        this.security = new Label(content, 0);
        label = new Label(content, 0);
        label.setText(Messages.EventDetailsDialog_Message);
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.message = new Text(content, 2120);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 300;
        gridData.heightHint = 40;
        this.message.setLayoutData((Object)gridData);
        label = new Label(content, 0);
        label.setText(Messages.EventDetailsDialog_Details);
        label.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
        this.longMessage = new Text(content, 2634);
        gridData = new GridData(4, 1, true, false, 3, 1);
        gridData.widthHint = 350;
        gridData.heightHint = 150;
        this.longMessage.setLayoutData((Object)gridData);
        this.updateEvent();
        return content;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getButton(0).setFocus();
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void createNavigationButtons(Composite parent) {
        this.up = new Button(parent, 8);
        this.up.setImage(this.upImage);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDetailsDialog.this.upPressed();
            }
        });
        this.down = new Button(parent, 8);
        this.down.setImage(this.downImage);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventDetailsDialog.this.downPressed();
            }
        });
        this.updateButtonStatus();
    }

    protected void upPressed() {
        int index = CorePlugin.getRepository().allEvents().indexOf(this.event);
        if (index < CorePlugin.getRepository().allEvents().size() - 1) {
            this.event = (Event)CorePlugin.getRepository().allEvents().get(index + 1);
            this.updateEvent();
        }
        this.updateButtonStatus();
    }

    protected void downPressed() {
        int index = CorePlugin.getRepository().allEvents().indexOf(this.event);
        if (index > 0) {
            this.event = (Event)CorePlugin.getRepository().allEvents().get(index - 1);
            this.updateEvent();
        }
        this.updateButtonStatus();
    }

    protected void updateButtonStatus() {
        int index = CorePlugin.getRepository().allEvents().indexOf(this.event);
        this.up.setEnabled(index < CorePlugin.getRepository().allEvents().size() - 1);
        this.down.setEnabled(index > 0);
    }

    protected void updateEvent() {
        this.date.setText(this.dateTimeFormatter.format(this.event.getDate()));
        this.security.setText(this.event.getSecurity() != null ? this.event.getSecurity().getDescription() : "");
        this.message.setText(this.event.getMessage());
        this.longMessage.setText(this.event.getLongMessage());
        this.message.getParent().layout();
    }

    protected Event getEvent() {
        return this.event;
    }

    @Override
    public void itemAdded(Object o) {
        if (!this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!EventDetailsDialog.this.getShell().isDisposed()) {
                        EventDetailsDialog.this.updateButtonStatus();
                    }
                }
            });
        }
    }

    @Override
    public void itemRemoved(Object o) {
        if (!this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!EventDetailsDialog.this.getShell().isDisposed()) {
                        EventDetailsDialog.this.updateButtonStatus();
                    }
                }
            });
        }
    }
}

