/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class CurrencyConversionDialog
extends Dialog {
    private Spinner amount;
    private Combo from;
    private Combo to;
    private Text result;
    private NumberFormat nf = CorePlugin.getPriceFormatterLong();
    private String defaultFrom;
    private String defaultTo;

    public CurrencyConversionDialog(Shell parentShell) {
        this(parentShell, null, null);
    }

    public CurrencyConversionDialog(Shell parentShell, String defaultFrom, String defaultTo) {
        super(parentShell);
        this.defaultFrom = defaultFrom;
        this.defaultTo = defaultTo;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CurrencyConversionDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText(Messages.CurrencyConversionDialog_Convert);
        label.setLayoutData((Object)new GridData(60, -1));
        this.amount = new Spinner(content, 2048);
        this.amount.setMinimum(1);
        this.amount.setMaximum(999999999);
        this.amount.setDigits(2);
        this.amount.setIncrement(100);
        this.amount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrencyConversionDialog.this.update();
            }
        });
        this.from = new Combo(content, 8);
        this.from.setLayoutData((Object)new GridData(4, 1, false, false));
        this.from.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrencyConversionDialog.this.update();
            }
        });
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        label = new Label(content, 0);
        label = new Label(content, 0);
        label.setText(Messages.CurrencyConversionDialog_To);
        label.setLayoutData((Object)new GridData(60, -1));
        this.to = new Combo(content, 8);
        this.to.setLayoutData((Object)new GridData(4, 1, false, false));
        this.to.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrencyConversionDialog.this.update();
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.CurrencyConversionDialog_Equal);
        this.result = new Text(content, 2056);
        this.result.setLayoutData((Object)new GridData(80, -1));
        List list = CurrencyConverter.getInstance().getCurrencies();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((String)arg0).compareTo((String)arg1);
            }
        });
        for (String symbol : list) {
            this.from.add(symbol);
            this.to.add(symbol);
        }
        String locale = Currency.getInstance(Locale.getDefault()).getCurrencyCode();
        if (this.defaultFrom == null) {
            String string = this.defaultFrom = locale.equals("EUR") ? "USD" : "EUR";
        }
        if (this.defaultTo == null) {
            this.defaultTo = locale;
        }
        this.from.setText(this.defaultFrom);
        this.to.setText(this.defaultTo);
        this.amount.setSelection(100);
        this.update();
        return content;
    }

    private void update() {
        try {
            double value = (double)this.amount.getSelection() / Math.pow(10.0, this.amount.getDigits());
            this.result.setText(this.nf.format(CurrencyConverter.getInstance().convert(value, this.from.getText(), this.to.getText())));
        }
        catch (Exception exception) {
            this.to.setText("");
        }
    }
}

