/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;

public class ColumnsOptionDialog
extends Dialog {
    private String shownColumns;
    private String shownColumnSizes;
    private IViewPart view;
    private IPreferenceStore preferences;
    private Composite control;
    private TableViewer available;
    private Button right;
    private Button allRight;
    private Button allLeft;
    private Button left;
    private TableViewer selected;
    private Button up;
    private Button down;
    private Image rightImage = CorePlugin.getImageDescriptor("icons/buttons16/right.gif").createImage();
    private Image allRightImage = CorePlugin.getImageDescriptor("icons/buttons16/all-right.gif").createImage();
    private Image allLeftImage = CorePlugin.getImageDescriptor("icons/buttons16/all-left.gif").createImage();
    private Image leftImage = CorePlugin.getImageDescriptor("icons/buttons16/left.gif").createImage();
    private Image upImage = CorePlugin.getImageDescriptor("icons/buttons16/up.gif").createImage();
    private Image downImage = CorePlugin.getImageDescriptor("icons/buttons16/down.gif").createImage();
    private List<Element> availableList;
    private List<Element> selectedList;

    public ColumnsOptionDialog(IViewPart view, String shownColumns, String shownColumnSizes, IPreferenceStore pref) {
        super(view.getViewSite().getShell());
        this.view = view;
        this.shownColumns = shownColumns;
        this.shownColumnSizes = shownColumnSizes;
        this.preferences = pref;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.view.getTitle());
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.control.setLayout((Layout)gridLayout);
        this.createLabels(this.control);
        this.createInputViewer(this.control);
        this.createSelectionViewer(this.control);
        this.availableList = new ArrayList<Element>();
        this.selectedList = new ArrayList<Element>();
        IConfigurationElement[] members = new LabelProvidersRegistry(this.view.getViewSite().getId()).getProviders();
        int i = 0;
        while (i < members.length) {
            this.availableList.add(new Element(members[i].getAttribute("name"), members[i].getAttribute("id")));
            ++i;
        }
        String[] id = this.preferences.getString(this.shownColumns).split(";");
        ArrayList<Element> temp = new ArrayList<Element>();
        String[] sizes = this.preferences.getString(this.shownColumnSizes).split(";");
        int i2 = 0;
        while (i2 < id.length) {
            Element element = this.findIndex(id[i2]);
            if (element != null) {
                try {
                    element.width = sizes[i2];
                }
                catch (Exception exception) {}
                temp.add(element);
            }
            ++i2;
        }
        this.selectedList.addAll(temp);
        this.availableList.removeAll(temp);
        this.selected.setInput(this.selectedList);
        this.available.setInput(this.availableList);
        this.updateControlsEnablement();
        return this.control;
    }

    private Element findIndex(String id) {
        int i = 0;
        while (i < this.availableList.size()) {
            Element element = this.availableList.get(i);
            if (element.id.equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    protected void createLabels(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Available Columns");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label(parent, 0);
        label.setText("Shown Columns");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    protected void createInputViewer(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        control.setLayout((Layout)gridLayout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)control.getLayoutData()).widthHint = 200;
        this.available = new TableViewer(control, 67586);
        this.available.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.available.getControl().getLayoutData()).heightHint = this.available.getTable().getItemHeight() * 15 + this.available.getTable().getBorderWidth() * 2;
        this.available.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Element)element).label;
            }
        });
        this.available.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.available.setSorter(new ViewerSorter());
        this.available.setInput(this.availableList);
        this.available.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnsOptionDialog.this.updateControlsEnablement();
            }
        });
        this.createInputButtons(control);
    }

    protected void createInputButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.right = new Button(buttons, 8);
        this.right.setImage(this.rightImage);
        this.right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnsOptionDialog.this.available.getSelection();
                ColumnsOptionDialog.this.selectedList.addAll(selection.toList());
                ColumnsOptionDialog.this.selected.refresh();
                ColumnsOptionDialog.this.availableList.removeAll(selection.toList());
                ColumnsOptionDialog.this.available.refresh();
                ColumnsOptionDialog.this.updateControlsEnablement();
            }
        });
        this.allRight = new Button(buttons, 8);
        this.allRight.setImage(this.allRightImage);
        this.allRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsOptionDialog.this.selectedList.addAll(ColumnsOptionDialog.this.availableList);
                ColumnsOptionDialog.this.selected.refresh();
                ColumnsOptionDialog.this.availableList.clear();
                ColumnsOptionDialog.this.available.refresh();
                ColumnsOptionDialog.this.updateControlsEnablement();
            }
        });
        this.allLeft = new Button(buttons, 8);
        this.allLeft.setImage(this.allLeftImage);
        this.allLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsOptionDialog.this.availableList.addAll(ColumnsOptionDialog.this.selectedList);
                ColumnsOptionDialog.this.available.refresh();
                ColumnsOptionDialog.this.selectedList.clear();
                ColumnsOptionDialog.this.selected.refresh();
                ColumnsOptionDialog.this.updateControlsEnablement();
            }
        });
        this.left = new Button(buttons, 8);
        this.left.setImage(this.leftImage);
        this.left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnsOptionDialog.this.selected.getSelection();
                ColumnsOptionDialog.this.selectedList.removeAll(selection.toList());
                ColumnsOptionDialog.this.selected.refresh();
                ColumnsOptionDialog.this.availableList.addAll(selection.toList());
                ColumnsOptionDialog.this.available.refresh();
                ColumnsOptionDialog.this.updateControlsEnablement();
            }
        });
    }

    protected void createSelectionViewer(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        control.setLayout((Layout)gridLayout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)control.getLayoutData()).widthHint = 200;
        this.selected = new TableViewer(control, 67586);
        this.selected.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.selected.getControl().getLayoutData()).heightHint = this.selected.getTable().getItemHeight() * 15 + this.selected.getTable().getBorderWidth() * 2;
        this.selected.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Element)element).label;
            }
        });
        this.selected.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selected.setInput(this.selectedList);
        this.selected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnsOptionDialog.this.updateControlsEnablement();
            }
        });
        this.createSelectionButtons(control);
    }

    protected void moveSelectionUp(Object[] s) {
        ArrayList<Element> l = new ArrayList<Element>();
        int index = 999999;
        int i = 0;
        while (i < s.length) {
            index = Math.min(index, this.selectedList.indexOf(s[i]));
            l.add((Element)s[i]);
            ++i;
        }
        if (index > 0) {
            this.selectedList.removeAll(l);
            this.selectedList.addAll(--index, l);
            this.selected.refresh();
        }
    }

    protected void moveSelectionDown(Object[] s) {
        ArrayList<Element> l = new ArrayList<Element>();
        int index = -1;
        int i = 0;
        while (i < s.length) {
            index = Math.max(index, this.selectedList.indexOf(s[i]));
            l.add((Element)s[i]);
            ++i;
        }
        if (index < this.selectedList.size() - 1) {
            ++index;
            this.selectedList.removeAll(l);
            this.selectedList.addAll(index -= l.size() - 1, l);
            this.selected.refresh();
        }
    }

    protected void createSelectionButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.up = new Button(buttons, 8);
        this.up.setImage(this.upImage);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnsOptionDialog.this.selected.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)ColumnsOptionDialog.this.selected.getSelection()).toArray();
                    ColumnsOptionDialog.this.moveSelectionUp(s);
                    ColumnsOptionDialog.this.updateControlsEnablement();
                }
            }
        });
        this.down = new Button(buttons, 8);
        this.down.setImage(this.downImage);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnsOptionDialog.this.selected.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)ColumnsOptionDialog.this.selected.getSelection()).toArray();
                    ColumnsOptionDialog.this.moveSelectionDown(s);
                    ColumnsOptionDialog.this.updateControlsEnablement();
                }
            }
        });
    }

    public void setAvailableElements(Element[] factories) {
        this.availableList.clear();
        this.availableList.addAll(Arrays.asList(factories));
        this.availableList.removeAll(this.selectedList);
        this.available.refresh();
        this.updateControlsEnablement();
    }

    public void setSelectedElements(Element[] columns) {
        this.selectedList.clear();
        this.selectedList.addAll(Arrays.asList(columns));
        this.selected.refresh();
        this.availableList.removeAll(this.selectedList);
        this.available.refresh();
        this.updateControlsEnablement();
    }

    public Element[] getSelectedElements() {
        return this.selectedList.toArray(new Element[this.selectedList.size()]);
    }

    protected void updateControlsEnablement() {
        this.right.setEnabled(!this.available.getSelection().isEmpty());
        this.allRight.setEnabled(this.availableList.size() != 0);
        this.left.setEnabled(!this.selected.getSelection().isEmpty());
        this.allLeft.setEnabled(this.selectedList.size() != 0);
        int upperIndex = -1;
        int lowerIndex = 999999;
        Object[] s = ((IStructuredSelection)this.selected.getSelection()).toArray();
        int i = 0;
        while (i < s.length) {
            upperIndex = Math.max(upperIndex, this.selectedList.indexOf(s[i]));
            lowerIndex = Math.min(lowerIndex, this.selectedList.indexOf(s[i]));
            ++i;
        }
        this.up.setEnabled(!this.selected.getSelection().isEmpty() && upperIndex > 0);
        this.down.setEnabled(!this.selected.getSelection().isEmpty() && lowerIndex < this.selectedList.size() - 1);
    }

    protected void okPressed() {
        StringBuffer columns = new StringBuffer();
        StringBuffer sizes = new StringBuffer();
        Element[] items = this.getSelectedElements();
        int i = 0;
        while (i < items.length) {
            Element c = items[i];
            columns.append(String.valueOf(c.id) + ";");
            sizes.append(String.valueOf(c.width) + ";");
            ++i;
        }
        this.preferences.setValue(this.shownColumns, columns.toString());
        this.preferences.setValue(this.shownColumnSizes, sizes.toString());
        super.okPressed();
    }

    private class Element {
        String label = "";
        String id = "";
        String width = "";

        Element(String label, String id) {
            this.label = label;
            this.id = id;
            this.width = "100";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Element)) {
                return false;
            }
            Element that = (Element)obj;
            return this.id.equals(that.id);
        }
    }
}

