/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;

public class FontPickerAction
extends Action {
    IPreferenceStore store = null;
    private String prefs = "";
    Font font = WidgetFactory.font_registry.get("FONT_10_BOLD");
    Font defaultFont = null;

    public FontPickerAction(IPreferenceStore store, String prefs, Font defaultFont) {
        this.setText("&Font Picker");
        this.setId("fontPicker");
        this.setImageDescriptor(CorePlugin.getImageDescriptor("icons/etool16/font.png"));
        this.store = store;
        this.prefs = prefs;
        this.defaultFont = defaultFont;
        this.loadFont();
    }

    public void run() {
        FontDialog fd = new FontDialog(Display.getDefault().getActiveShell(), 0);
        fd.setText("Select Font");
        fd.setFontList(this.font.getFontData());
        FontData newFont = fd.open();
        if (newFont != null) {
            this.font = new Font((Device)Display.getDefault(), newFont);
            this.store.setValue(this.prefs, String.valueOf(newFont.getName()) + "," + newFont.getHeight() + "," + newFont.getStyle());
        }
        super.run();
    }

    public void setFont(Font newFont) {
        if (this.font != null) {
            this.font = newFont;
            FontData data = newFont.getFontData()[0];
            this.store.setValue(this.prefs, String.valueOf(data.getName()) + "," + data.getHeight() + "," + data.getStyle());
        }
    }

    public void loadFont() {
        if (this.store != null) {
            String colorCode = this.store.getString(this.prefs);
            if (colorCode != null && colorCode.matches("([\\w\\W]*,\\d{1,3},\\d{1,3})")) {
                String[] font = colorCode.split(",");
                try {
                    this.font = new Font((Device)Display.getDefault(), font[0], Integer.parseInt(font[1]), Integer.parseInt(font[2]));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.setFont(this.defaultFont);
        }
    }

    public Font getFont() {
        return new Font((Device)Display.getDefault(), this.font.getFontData());
    }
}

