/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Event;

public class ExportToFileAction
extends Action {
    private Table table;
    private String fileName;

    public ExportToFileAction(Table table, String fileName) {
        this.table = table;
        this.fileName = fileName;
        this.setId("exportToFile");
        this.setText("Export To File");
        this.setToolTipText("Export To File");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT"));
    }

    public void run() {
        if (this.table != null && !this.table.isDisposed()) {
            String eol = "\r\n";
            FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            fd.setText("Save");
            fd.setFilterPath("" + Platform.getLocation());
            String[] filterExt = new String[]{"*.csv", "*.*"};
            fd.setFilterExtensions(filterExt);
            fd.setFileName(this.fileName);
            String selectedPath = fd.open();
            try {
                if (selectedPath != null) {
                    File file = new File(selectedPath);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    int j = 0;
                    while (j < this.table.getColumnCount()) {
                        writer.write(String.valueOf(this.table.getColumn(j).getText()) + ",");
                        ++j;
                    }
                    writer.write(eol);
                    int i = 0;
                    while (i < this.table.getItemCount()) {
                        int j2 = 0;
                        while (j2 < this.table.getColumnCount()) {
                            writer.write(String.valueOf(this.table.getItem(i).getText(j2).replaceAll(",", "")) + ",");
                            ++j2;
                        }
                        writer.write(eol);
                        ++i;
                    }
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    Event e = new Event();
                    e.setMessage("Watchlist exported to " + file.getAbsolutePath());
                    CorePlugin.getRepository().allEvents().add(e);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

