/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.core.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class ColorPickerAction
extends Action {
    IPreferenceStore store = null;
    private String prefs = "";
    private RGB rgb = new RGB(255, 255, 255);
    private Color defaultColor = null;

    public ColorPickerAction(IPreferenceStore store, String prefs, Color defaultColor) {
        this.setText("&Color Picker");
        this.setId("colorPicker");
        this.setImageDescriptor(CorePlugin.getImageDescriptor("icons/etool16/color.png"));
        this.store = store;
        this.prefs = prefs;
        this.defaultColor = defaultColor;
        this.loadColor();
    }

    public void run() {
        RGB temp;
        ColorDialog cd = new ColorDialog(Display.getDefault().getActiveShell());
        cd.setText("Color Chooser Dialog");
        if (this.rgb != null) {
            cd.setRGB(new RGB(this.rgb.red, this.rgb.green, this.rgb.blue));
        }
        if ((temp = cd.open()) != null) {
            this.rgb = temp;
            this.store.setValue(this.prefs, String.valueOf(this.rgb.red) + "," + this.rgb.green + "," + this.rgb.blue);
        }
        super.run();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.rgb = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            this.store.setValue(this.prefs, String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue());
        }
    }

    public void loadColor() {
        try {
            if (this.store != null) {
                String colorCode = this.store.getString(this.prefs);
                if (colorCode != null && colorCode.matches("(\\d{1,3},\\d{1,3},\\d{1,3})")) {
                    String[] rgb = colorCode.split(",");
                    this.rgb = new RGB(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                } else {
                    this.setColor(this.defaultColor);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public RGB getColor() {
        return new RGB(this.rgb.red, this.rgb.green, this.rgb.blue);
    }
}

